/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata.test;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.persistence.NoResultException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.rhq.core.clientapi.agent.measurement.MeasurementAgentService;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.measurement.MeasurementData;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.ResourceMeasurementScheduleRequest;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.enterprise.server.drift.DriftServerPluginService;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.test.TransactionCallbackReturnable;
import org.rhq.enterprise.server.util.LookupUtil;

public class UpdatePluginMetadataTestBase
extends AbstractEJB3Test {
    protected static final String RHQ_SERVER_NAME_PROPERTY_VALUE = "TestServer";
    protected TestServerCommunicationsService agentServiceContainer;
    protected static final String PLUGIN_NAME = "UpdatePluginMetadataTestBasePlugin";
    protected static final String AGENT_NAME = "-dummy agent-";
    protected static final String COMMON_PATH_PREFIX = "./test/metadata/";
    protected static PluginManagerLocal pluginMgr;
    protected static ResourceTypeManagerLocal resourceTypeManager;
    protected static ResourceManagerLocal resourceManager;
    private Server server;

    @Override
    protected void beforeMethod() throws Exception {
        this.agentServiceContainer = this.prepareForTestAgents();
        this.prepareMockAgentServiceContainer();
        this.prepareScheduler();
        this.preparePluginScannerService();
        DriftServerPluginService driftServerPluginService = new DriftServerPluginService(this.getTempDir());
        this.prepareCustomServerPluginService(driftServerPluginService);
        driftServerPluginService.masterConfig.getPluginDirectory().mkdirs();
        pluginMgr = LookupUtil.getPluginManager();
        resourceTypeManager = LookupUtil.getResourceTypeManager();
        resourceManager = LookupUtil.getResourceManager();
        this.setServerIdentity(RHQ_SERVER_NAME_PROPERTY_VALUE);
    }

    @Override
    protected void afterMethod() throws Exception {
        this.cleanupTest();
        this.unprepareServerPluginService();
        this.unpreparePluginScannerService();
        this.unprepareScheduler();
        this.unprepareForTestAgents();
        this.deleteServerIdentity();
    }

    protected void prepareMockAgentServiceContainer() {
        this.agentServiceContainer.measurementService = new MockMeasurementAgentService();
    }

    protected ResourceType getResourceType(String typeName) {
        return this.getResourceType(typeName, PLUGIN_NAME);
    }

    protected ResourceType getResourceType(String typeName, String pluginName) {
        Subject overlord = this.getOverlord();
        ResourceTypeCriteria resourceTypeCriteria = new ResourceTypeCriteria();
        resourceTypeCriteria.setStrict(true);
        resourceTypeCriteria.addFilterIgnored(null);
        resourceTypeCriteria.addFilterName(typeName);
        resourceTypeCriteria.addFilterPluginName(pluginName);
        resourceTypeCriteria.fetchMetricDefinitions(true);
        resourceTypeCriteria.fetchSubCategory(true);
        PageList results = resourceTypeManager.findResourceTypesByCriteria(overlord, resourceTypeCriteria);
        if (results.size() == 0) {
            return null;
        }
        if (results.size() == 1) {
            return (ResourceType)results.get(0);
        }
        throw new IllegalStateException("Found more than one resourceType with name " + typeName + " from plugin " + pluginName + ".");
    }

    protected Resource createResource(String resourceKey, String name, ResourceType type) {
        Resource resource = new Resource(resourceKey, name, type);
        resource.setUuid(UUID.randomUUID().toString());
        resource.setInventoryStatus(InventoryStatus.COMMITTED);
        return resource;
    }

    protected Resource getResource(ResourceCriteria resourceCriteria) {
        Subject overlord = this.getOverlord();
        PageList results = resourceManager.findResourcesByCriteria(overlord, resourceCriteria);
        if (results.size() == 0) {
            return null;
        }
        if (results.size() == 1) {
            return (Resource)results.get(0);
        }
        throw new IllegalStateException("Found more than one Resource with criteria " + resourceCriteria + ".");
    }

    protected String getSubsystemDirectory() {
        return ".";
    }

    protected void registerPlugin(String pathToDescriptor, String versionOverride) throws Exception {
        pathToDescriptor = COMMON_PATH_PREFIX + this.getSubsystemDirectory() + "/" + pathToDescriptor;
        this.registerPluginInternal(pathToDescriptor, versionOverride);
    }

    private void registerPluginInternal(String pathToDescriptor, String versionOverride) throws Exception {
        System.out.println("Registering plugin with descriptor [" + pathToDescriptor + "]...");
        String md5 = MessageDigestGenerator.getDigestString((String)pathToDescriptor);
        Plugin testPlugin = new Plugin(PLUGIN_NAME, "foo.jar", md5);
        testPlugin.setDisplayName("UpdatePluginMetadataTestBasePlugin: " + pathToDescriptor);
        PluginDescriptor descriptor = this.loadPluginDescriptor(pathToDescriptor);
        if (versionOverride != null) {
            testPlugin.setVersion(versionOverride);
        } else {
            testPlugin.setVersion(descriptor.getVersion());
        }
        try {
            pluginMgr.registerPlugin(testPlugin, descriptor, null, true);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    protected void registerPlugin(String pathToDescriptor) throws Exception {
        this.registerPlugin(pathToDescriptor, null);
    }

    public PluginDescriptor loadPluginDescriptor(String descriptorFile) throws Exception {
        URL descriptorUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource(descriptorFile);
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.rhq.core.clientapi.descriptor.plugin");
        URL pluginSchemaURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("rhq-plugin.xsd");
        Schema pluginSchema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(pluginSchemaURL);
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        ValidationEventCollector vec = new ValidationEventCollector();
        unmarshaller.setEventHandler((ValidationEventHandler)vec);
        unmarshaller.setSchema(pluginSchema);
        if (descriptorUrl == null) {
            throw new FileNotFoundException("File " + descriptorFile + " not found");
        }
        return (PluginDescriptor)unmarshaller.unmarshal(descriptorUrl.openStream());
    }

    protected boolean containedIn(String string, String[] references) {
        boolean found = false;
        for (String ref : references) {
            if (!string.equals(ref)) continue;
            found = true;
            break;
        }
        return found;
    }

    protected int getPluginId() throws NoResultException {
        Plugin existingPlugin = (Plugin)this.em.createNamedQuery("Plugin.findByName").setParameter("name", (Object)PLUGIN_NAME).getSingleResult();
        int plugin1Id = existingPlugin.getId();
        return plugin1Id;
    }

    protected int getAgentId() throws NoResultException {
        Agent existingAgent = this.getAgent();
        int agentId = existingAgent.getId();
        return agentId;
    }

    protected Agent getAgent() throws NoResultException {
        Agent existingAgent = (Agent)this.em.createNamedQuery("Agent.findByName").setParameter("name", (Object)AGENT_NAME).getSingleResult();
        return existingAgent;
    }

    protected void setUpAgent(Resource testResource) {
        Agent agent;
        try {
            agent = this.getAgent();
        }
        catch (NoResultException nre) {
            agent = new Agent(AGENT_NAME, "localhost", 12345, "http://localhost:12345/", "-dummy token-");
            this.em.persist((Object)agent);
        }
        testResource.setAgent(agent);
        this.agentServiceContainer.addStartedAgent(agent);
    }

    protected void createServerIdentity() {
        this.server = new Server();
        this.server.setName(RHQ_SERVER_NAME_PROPERTY_VALUE);
        this.server.setAddress("localhost");
        this.server.setPort(7080);
        this.server.setSecurePort(7443);
        this.server.setComputePower(1);
        this.server.setOperationMode(Server.OperationMode.MAINTENANCE);
        int serverId = LookupUtil.getServerManager().create(this.server);
        assert (serverId > 0) : "could not create our server identity in the DB";
        try {
            Agent agent = this.getAgent();
            agent.setServer(this.server);
            LookupUtil.getAgentManager().updateAgent(agent);
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }

    protected void deleteServerIdentity() throws Exception {
        if (this.server != null) {
            this.cleanupAgent();
            LookupUtil.getTopologyManager().deleteServer(LookupUtil.getSubjectManager().getOverlord(), Integer.valueOf(this.server.getId()));
            this.server = null;
        }
    }

    protected void cleanupTest() throws Exception {
        this.cleanupMetadata();
        this.cleanupAgent();
        this.cleanupPlugin();
    }

    protected void cleanupMetadata() throws Exception {
        String pathToDescriptor = "./test/metadata//noTypes.xml";
        this.registerPluginInternal(pathToDescriptor, null);
    }

    protected void cleanupAgent() throws Exception {
        this.getTransactionManager().begin();
        try {
            try {
                int agentId = this.getAgentId();
                Agent agent = (Agent)this.em.getReference(Agent.class, (Object)agentId);
                if (null != agent) {
                    this.em.remove((Object)agent);
                }
            }
            catch (NoResultException nre) {
                // empty catch block
            }
        }
        catch (Exception e) {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
            System.out.println("CANNOT CLEAN UP AGENT: " + e);
            throw e;
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().commit();
            }
        }
    }

    protected void cleanupPlugin() throws Exception {
        this.getTransactionManager().begin();
        try {
            try {
                int plugin1Id = this.getPluginId();
                Plugin plugin1 = (Plugin)this.em.getReference(Plugin.class, (Object)plugin1Id);
                if (null != plugin1) {
                    this.em.remove((Object)plugin1);
                }
            }
            catch (NoResultException nre) {
                // empty catch block
            }
        }
        catch (Exception e) {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
            System.out.println("CANNOT CLEAN UP PLUGIN: " + e);
            throw e;
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().commit();
            }
        }
    }

    protected void cleanupResourceType(String rtName) throws Exception {
        try {
            ResourceType rt = this.getResourceType(rtName);
            if (null != rt) {
                Subject overlord = this.getOverlord();
                ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
                ResourceCriteria c = new ResourceCriteria();
                c.setStrict(true);
                c.addFilterResourceTypeId(Integer.valueOf(rt.getId()));
                c.addFilterInventoryStatus(InventoryStatus.NEW);
                PageList doomedResources = resourceManager.findResourcesByCriteria(overlord, c);
                c.addFilterInventoryStatus(InventoryStatus.DELETED);
                doomedResources.addAll(resourceManager.findResourcesByCriteria(overlord, c));
                c.addFilterInventoryStatus(InventoryStatus.UNINVENTORIED);
                doomedResources.addAll(resourceManager.findResourcesByCriteria(overlord, c));
                for (Resource doomed : doomedResources) {
                    List deletedIds = resourceManager.uninventoryResource(overlord, doomed.getId());
                    for (Integer deletedResourceId : deletedIds) {
                        resourceManager.uninventoryResourceAsyncWork(overlord, deletedResourceId.intValue());
                    }
                }
                this.getTransactionManager().begin();
                rt = (ResourceType)this.em.find(ResourceType.class, (Object)rt.getId());
                ResourceType parent = rt.getParentResourceTypes().isEmpty() ? null : (ResourceType)rt.getParentResourceTypes().iterator().next();
                this.em.remove((Object)rt);
                if (null != parent) {
                    this.em.remove((Object)parent);
                }
            }
        }
        catch (Exception e) {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
            System.out.println("CANNOT CLEAN UP RESOURCE TYPE: " + rtName + ": " + e);
            throw e;
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().commit();
            }
        }
    }

    protected Subject getOverlord() {
        return LookupUtil.getSubjectManager().getOverlord();
    }

    protected Resource persistNewResource(final String resourceTypeName) throws Exception {
        return this.executeInTransaction(false, new TransactionCallbackReturnable<Resource>(){

            @Override
            public Resource execute() throws Exception {
                ResourceType resourceType = UpdatePluginMetadataTestBase.this.getResourceType(resourceTypeName);
                Resource resource = new Resource("reskey" + System.currentTimeMillis(), "resname", resourceType);
                resource.setUuid(UUID.randomUUID().toString());
                resource.setInventoryStatus(InventoryStatus.COMMITTED);
                UpdatePluginMetadataTestBase.this.setUpAgent(resource);
                UpdatePluginMetadataTestBase.this.em.persist((Object)resource);
                return resource;
            }
        });
    }

    protected void deleteNewResource(Resource resource) throws Exception {
        try {
            List deletedIds = resourceManager.uninventoryResource(this.getOverlord(), resource.getId());
            for (Integer deletedResourceId : deletedIds) {
                resourceManager.uninventoryResourceAsyncWork(this.getOverlord(), deletedResourceId.intValue());
            }
        }
        catch (Exception e) {
            System.out.println("CANNOT CLEAN UP RESOURCE: " + resource + ": " + e);
            throw e;
        }
    }

    public class MockMeasurementAgentService
    implements MeasurementAgentService {
        public Set<MeasurementData> getRealTimeMeasurementValue(int resourceId, Set<MeasurementScheduleRequest> requests) {
            return null;
        }

        public void scheduleCollection(Set<ResourceMeasurementScheduleRequest> resourceSchedules) {
        }

        public void unscheduleCollection(Set<Integer> resourceIds) {
        }

        public void updateCollection(Set<ResourceMeasurementScheduleRequest> resourceSchedules) {
        }

        public Map<String, Object> getMeasurementScheduleInfoForResource(int resourceId) {
            return null;
        }
    }
}

