/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata.test;

import java.util.List;
import java.util.Set;
import org.rhq.core.domain.resource.ResourceSubCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.resource.metadata.test.UpdatePluginMetadataTestBase;
import org.testng.annotations.Test;

public class UpdateResourceSubsystemTest
extends UpdatePluginMetadataTestBase {
    private static final boolean ENABLED = true;

    @Override
    protected String getSubsystemDirectory() {
        return "resource";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testSingleSubCategoryCreate() throws Exception {
        try {
            this.registerPlugin("one-subcat-v1_0.xml");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            ResourceSubCategory subCat = this.assertSubCategory(server1.getChildSubCategories(), 1, 0);
            this.assertAppsSubCategory(subCat);
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testSingleSubCategoryAddFromEmpty() throws Exception {
        try {
            this.registerPlugin("no-subcat.xml", "1.0");
            this.registerPlugin("one-subcat-v1_0.xml", "2.0");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            ResourceSubCategory subCat = this.assertSubCategory(server1.getChildSubCategories(), 1, 0);
            this.assertAppsSubCategory(subCat);
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testSingleSubCategoryAddSibling() throws Exception {
        try {
            this.registerPlugin("one-subcat-v1_0.xml", "1.0");
            this.registerPlugin("two-subcat.xml", "2.0");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            ResourceSubCategory subCat = this.assertSubCategory(server1.getChildSubCategories(), 2, 0);
            this.assertAppsSubCategory(subCat);
            subCat = this.assertSubCategory(server1.getChildSubCategories(), 2, 1);
            this.assertServicesSubCategory(subCat);
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testSingleSubCategoryReplace() throws Exception {
        try {
            this.registerPlugin("one-subcat-v1_0.xml");
            this.registerPlugin("one-subcat-v2_0.xml");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            ResourceSubCategory subCat = this.assertSubCategory(server1.getChildSubCategories(), 1, 0);
            this.assertServicesSubCategory(subCat);
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testSingleSubCategoryRemoveOneFromTwo() throws Exception {
        try {
            this.registerPlugin("two-subcat.xml", "1.0");
            this.registerPlugin("one-subcat-v2_0.xml");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            ResourceSubCategory subCat = this.assertSubCategory(server1.getChildSubCategories(), 1, 0);
            this.assertServicesSubCategory(subCat);
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testSingleSubCategoryUpdate() throws Exception {
        try {
            this.registerPlugin("one-subcat-v1_0.xml");
            this.registerPlugin("one-subcat-v1_1.xml");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            ResourceSubCategory subCat = this.assertSubCategory(server1.getChildSubCategories(), 1, 0);
            this.assertApps2SubCategory(subCat);
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testSingleSubCategoryRemove() throws Exception {
        try {
            this.registerPlugin("one-subcat-v1_0.xml");
            this.registerPlugin("no-subcat.xml", "2.0");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            this.assertSubCategory(server1.getChildSubCategories(), 0, null);
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testNestedSubCategoryReplace() throws Exception {
        try {
            this.registerPlugin("nested-subcat-v1_0.xml");
            this.registerPlugin("nested-subcat-v2_0.xml");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            ResourceSubCategory subCat = this.assertSubCategory(server1.getChildSubCategories(), 1, 0);
            ResourceSubCategory childSubCat = this.assertSubCategory(subCat.getChildSubCategories(), 1, 0);
            this.assertServicesSubCategory(childSubCat);
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testNestedSubCategoryAddFromEmpty() throws Exception {
        try {
            this.registerPlugin("no-subcat.xml", "0.0");
            this.registerPlugin("nested-subcat-v1_0.xml");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            ResourceSubCategory subCat = this.assertSubCategory(server1.getChildSubCategories(), 1, 0);
            ResourceSubCategory childSubCat = this.assertSubCategory(subCat.getChildSubCategories(), 1, 0);
            this.assertAppsSubCategory(childSubCat);
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testNestedSubCategoryRemoveOneFromTwo() throws Exception {
        try {
            this.registerPlugin("nested-subcat-2children.xml", "1.0");
            this.registerPlugin("nested-subcat-v2_0.xml");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            ResourceSubCategory subCat = this.assertSubCategory(server1.getChildSubCategories(), 1, 0);
            ResourceSubCategory childSubCat = this.assertSubCategory(subCat.getChildSubCategories(), 1, 0);
            this.assertServicesSubCategory(childSubCat);
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testNestedSubCategoryAddSibling() throws Exception {
        try {
            this.registerPlugin("nested-subcat-v2_0.xml");
            this.registerPlugin("nested-subcat-2children.xml", "3.0");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            ResourceSubCategory subCat = this.assertSubCategory(server1.getChildSubCategories(), 1, 0);
            ResourceSubCategory childSubCat = this.assertSubCategory(subCat.getChildSubCategories(), 2, 1);
            this.assertAppsSubCategory(childSubCat);
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testNestedSubCategoryRemoveChild() throws Exception {
        try {
            this.registerPlugin("nested-subcat-grandchild.xml", "1.0");
            this.registerPlugin("nested-subcat-v2_0.xml");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            ResourceSubCategory subCat = this.assertSubCategory(server1.getChildSubCategories(), 1, 0);
            ResourceSubCategory childSubCat = this.assertSubCategory(subCat.getChildSubCategories(), 1, 0);
            this.assertServicesSubCategory(childSubCat);
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testNestedSubCategoryAddChild() throws Exception {
        try {
            this.registerPlugin("nested-subcat-v2_0.xml");
            this.registerPlugin("nested-subcat-grandchild.xml", "3.0");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            ResourceSubCategory subCat = this.assertSubCategory(server1.getChildSubCategories(), 1, 0);
            ResourceSubCategory childSubCat = this.assertSubCategory(subCat.getChildSubCategories(), 1, 0);
            ResourceSubCategory grandChildSubCat = this.assertSubCategory(childSubCat.getChildSubCategories(), 1, 0);
            this.assertAppsSubCategory(grandChildSubCat);
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testNestedSubCategoryUpdate() throws Exception {
        try {
            this.registerPlugin("nested-subcat-v1_0.xml");
            this.registerPlugin("nested-subcat-v1_1.xml");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            ResourceSubCategory subCat = this.assertSubCategory(server1.getChildSubCategories(), 1, 0);
            ResourceSubCategory childSubCat = this.assertSubCategory(subCat.getChildSubCategories(), 1, 0);
            this.assertApps2SubCategory(childSubCat);
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testNestedSubCategoryAdd() throws Exception {
        try {
            this.registerPlugin("one-subcat-v3_0.xml");
            this.registerPlugin("nested-subcat-v1_1.xml", "4.0");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            ResourceSubCategory subCat = this.assertSubCategory(server1.getChildSubCategories(), 1, 0);
            ResourceSubCategory childSubCat = this.assertSubCategory(subCat.getChildSubCategories(), 1, 0);
            this.assertApps2SubCategory(childSubCat);
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testNestedSubCategoryCreate() throws Exception {
        try {
            this.registerPlugin("nested-subcat-v1_1.xml");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            ResourceSubCategory subCat = this.assertSubCategory(server1.getChildSubCategories(), 1, 0);
            ResourceSubCategory childSubCat = this.assertSubCategory(subCat.getChildSubCategories(), 1, 0);
            this.assertApps2SubCategory(childSubCat);
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testNestedSubCategoryRemoveAll() throws Exception {
        try {
            this.registerPlugin("nested-subcat-v1_0.xml");
            this.registerPlugin("no-subcat.xml", "2.0");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            this.assertSubCategory(server1.getChildSubCategories(), 0, null);
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testNestedSubCategoryCreateWithServices() throws Exception {
        try {
            this.registerPlugin("nested-subcat-services-v1_0.xml");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            Set children = server1.getChildResourceTypes();
            assert (children.size() == 3);
            ResourceType services = this.getResourceType("testService1");
            this.assertServicesSubCategory(services.getSubCategory());
            ResourceType apps = this.getResourceType("testApp1");
            this.assertAppsSubCategory(apps.getSubCategory());
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testNestedSubCategoryCreateWithServices2() throws Exception {
        try {
            this.registerPlugin("nested-subcat-services-v2_0.xml");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            Set children = server1.getChildResourceTypes();
            assert (children.size() == 2);
            ResourceType services = this.getResourceType("testService2");
            assert (services.getSubCategory().getName().equals("applications2"));
            ResourceType apps = this.getResourceType("testApp1");
            assert (apps.getSubCategory().getName().equals("applications2"));
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testNestedSubCategoryUpdateWithServices() throws Exception {
        try {
            this.registerPlugin("nested-subcat-services-v1_0.xml");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            Set children = server1.getChildResourceTypes();
            assert (children.size() == 3);
            List subCategories = server1.getChildSubCategories();
            assert (subCategories != null);
            assert (subCategories.size() == 1);
            this.getTransactionManager().rollback();
            this.registerPlugin("nested-subcat-services-v2_0.xml");
            server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            children = server1.getChildResourceTypes();
            assert (children.size() == 2) : "Expected 2 children, but got " + children.size();
            subCategories = server1.getChildSubCategories();
            assert (subCategories != null);
            assert (subCategories.size() == 1);
            ResourceSubCategory parent = (ResourceSubCategory)subCategories.get(0);
            assert (parent != null);
            assert (parent.getName().equals("parent")) : "Name was not 'parent', but " + parent.getName();
            subCategories = parent.getChildSubCategories();
            assert (subCategories != null);
            assert (subCategories.size() == 1);
            ResourceSubCategory app2 = (ResourceSubCategory)subCategories.get(0);
            assert (app2 != null);
            assert (app2.getName().equals("applications2")) : "Name was not 'applications2', but " + app2.getName();
            ResourceType service2 = this.getResourceType("testService2");
            assert (service2 != null);
            assert (((ResourceType)service2.getParentResourceTypes().iterator().next()).equals((Object)server1));
            subCategories = service2.getChildSubCategories();
            assert (subCategories.isEmpty()) : "Expected subcategories to be empty, but was " + subCategories;
            ResourceSubCategory subCategory = service2.getSubCategory();
            subCategory = (ResourceSubCategory)this.em.find(ResourceSubCategory.class, (Object)subCategory.getId());
            String name = subCategory.getName();
            assert (name.equals("applications2")) : "Expected 'applictions2', but got " + name;
            ResourceType apps = this.getResourceType("testApp1");
            assert (apps.getSubCategory().getName().equals("applications2"));
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testRemoveService() throws Exception {
        try {
            this.registerPlugin("services-v1_0.xml");
            this.registerPlugin("services-v2_0.xml");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            Set children = server1.getChildResourceTypes();
            assert (children.size() == 2) : "Incorrect number of child resource types, should have been 2 but was [" + children.size() + "].";
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testSimpleSubCategoryCreate() throws Exception {
        try {
            this.registerPlugin("test-subcategories.xml");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            ResourceSubCategory subCat = this.assertSubCategory(server1.getChildSubCategories(), 1, 0);
            assert (subCat.getName().equals("applications"));
            ResourceType server2 = this.getResourceType("testServer2");
            server2 = (ResourceType)this.em.find(ResourceType.class, (Object)server2.getId());
            assert (server2.getChildSubCategories() != null);
            assert (server2.getChildSubCategories().size() == 2) : "Unexpected number of subcategories [" + server2.getChildSubCategories().size() + "]";
            subCat = (ResourceSubCategory)server2.getChildSubCategories().get(1);
            assert (subCat.getName().equals("resource"));
            List childSubCats = subCat.getChildSubCategories();
            assert (childSubCats.size() == 2);
            subCat = (ResourceSubCategory)childSubCats.get(1);
            assert (subCat.getName().equals("destinations"));
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testSimpleSubCategoryUpdate() throws Exception {
        try {
            this.registerPlugin("test-subcategories.xml", "1.0");
            this.registerPlugin("test-subcategories2.xml", "2.0");
            ResourceType server1 = this.getResourceType("testServer1");
            this.getTransactionManager().begin();
            server1 = (ResourceType)this.em.find(ResourceType.class, (Object)server1.getId());
            ResourceSubCategory subCat = this.assertSubCategory(server1.getChildSubCategories(), 1, 0);
            this.assertApps2SubCategory(subCat);
            ResourceType server2 = this.getResourceType("testServer2");
            server2 = (ResourceType)this.em.find(ResourceType.class, (Object)server2.getId());
            assert (server2.getChildSubCategories() != null);
            assert (server2.getChildSubCategories().size() == 2) : "Unexpected number of subcategories [" + server2.getChildSubCategories().size() + "]";
            int found = 0;
            ResourceSubCategory resourceSubCat = null;
            for (int i = 0; i <= 1; ++i) {
                ResourceSubCategory subCategory = (ResourceSubCategory)server2.getChildSubCategories().get(i);
                String name = subCategory.getName();
                if ("services2".equals(name) || "resource".equals(name)) {
                    ++found;
                }
                if (!"resource".equals(name)) continue;
                resourceSubCat = subCategory;
            }
            assert (found == 2);
            assert (resourceSubCat != null);
            List childSubCats = resourceSubCat.getChildSubCategories();
            assert (childSubCats.size() == 2);
            subCat = (ResourceSubCategory)childSubCats.get(1);
            assert (subCat.getName().equals("destinations"));
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testAddIllegalSubcategory1() throws Exception {
        try {
            this.registerPlugin("illegal-subcat-1.xml");
            this.fail("Exception was not thrown.");
        }
        catch (Throwable throwable) {
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testReferenceToUndefinedChildSubCategory() throws Exception {
        System.out.println("= testReferenceToUndefinedChildSubCategory");
        try {
            try {
                this.registerPlugin("undefined-child-subcat-1.xml");
                this.fail("Exception was not thrown.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    private ResourceSubCategory assertSubCategory(List<ResourceSubCategory> subCats, Integer size, Integer index) {
        assert (subCats != null);
        assert (subCats.size() == size.intValue()) : "Unexpected number of Sub categories. Expected [" + size + "] got [" + subCats.size() + "].";
        ResourceSubCategory subCat = null;
        if (index != null) {
            subCat = subCats.get(index);
        }
        return subCat;
    }

    private void assertServicesSubCategory(ResourceSubCategory subCat) {
        assert (subCat != null);
        assert (subCat.getName().equals("services"));
        assert (subCat.getDisplayName().equals("Services"));
        assert (subCat.getDescription().equals("Some services"));
    }

    private void assertAppsSubCategory(ResourceSubCategory subCat) {
        assert (subCat != null);
        assert (subCat.getName().equals("applications"));
        assert (subCat.getDisplayName().equals("Apps"));
        assert (subCat.getDescription().equals("The apps."));
    }

    private void assertApps2SubCategory(ResourceSubCategory subCat) {
        assert (subCat != null);
        assert (subCat.getName().equals("applications"));
        assert (subCat.getDisplayName().equals("Apps2"));
        assert (subCat.getDescription().equals("The apps2."));
    }
}

