/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata.test;

import java.util.Set;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.bundle.ResourceTypeBundleConfiguration;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.resource.metadata.test.UpdatePluginMetadataTestBase;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

public class UpdateResourceTypeSubsystemTest
extends UpdatePluginMetadataTestBase {
    @Override
    protected String getSubsystemDirectory() {
        return "resource-type";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResourceTypeBundleTarget() throws Exception {
        try {
            this.registerPlugin("updateResourceTypeBundleTarget-v1.xml");
            ResourceType platform1 = this.getResourceType("myPlatform1");
            this.getTransactionManager().begin();
            platform1 = (ResourceType)this.em.find(ResourceType.class, (Object)platform1.getId());
            assert (platform1.getResourceTypeBundleConfiguration() == null) : "platform should not be a bundle target";
            Set servers1 = platform1.getChildResourceTypes();
            assert (servers1.size() == 1) : "must only have one child server under the test platform";
            ResourceType server1 = (ResourceType)servers1.iterator().next();
            ResourceTypeBundleConfiguration bundleConfig1 = server1.getResourceTypeBundleConfiguration();
            assert (bundleConfig1 != null) : "server should have been a bundle target";
            Set baseDirs1 = bundleConfig1.getBundleDestinationBaseDirectories();
            assert (baseDirs1.size() == 2) : "should have been 2 bundle dest base dirs: " + baseDirs1;
            for (ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory baseDir : baseDirs1) {
                if (baseDir.getName().equals("firstDestBaseDir")) {
                    assert (baseDir.getValueContext() == ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context.pluginConfiguration) : "bad context: " + baseDir;
                    assert (baseDir.getValueName().equals("prop1")) : "bad value" + baseDir;
                    continue;
                }
                if (baseDir.getName().equals("secondDestBaseDir")) {
                    assert (baseDir.getValueContext() == ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context.fileSystem) : "bad context: " + baseDir;
                    assert (baseDir.getValueName().equals("/")) : "bad value" + baseDir;
                    continue;
                }
                assert (false) : "wrong dest base dir was retrieved: " + baseDir;
            }
            this.getTransactionManager().rollback();
            this.registerPlugin("updateResourceTypeBundleTarget-v2.xml");
            ResourceType platform2 = this.getResourceType("myPlatform1");
            this.getTransactionManager().begin();
            platform2 = (ResourceType)this.em.find(ResourceType.class, (Object)platform2.getId());
            assert (platform1.getResourceTypeBundleConfiguration() == null) : "platform should not be a bundle target";
            Set servers2 = platform2.getChildResourceTypes();
            assert (servers2.size() == 1) : "Expected to find 1 server";
            ResourceType server2 = (ResourceType)servers2.iterator().next();
            ResourceTypeBundleConfiguration bundleConfig2 = server2.getResourceTypeBundleConfiguration();
            assert (bundleConfig2 != null) : "server should have been a bundle target";
            Set baseDirs2 = bundleConfig2.getBundleDestinationBaseDirectories();
            assert (baseDirs2.size() == 1) : "should have been 1 bundle dest base dir: " + baseDirs2;
            ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory baseDir = (ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory)baseDirs2.iterator().next();
            assert (baseDir.getName().equals("thirdDestBaseDir"));
            assert (baseDir.getValueContext() == ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context.resourceConfiguration) : "bad context: " + baseDir;
            assert (baseDir.getValueName().equals("resourceProp1")) : "bad value" + baseDir;
            assert (null == this.em.find(Configuration.class, (Object)bundleConfig1.getBundleConfiguration().getId())) : "The configuration " + bundleConfig1 + " should have been deleted";
            this.getTransactionManager().rollback();
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResourceTypeDeletion() throws Exception {
        try {
            this.registerPlugin("update4-v1_0.xml");
            ResourceType platform1 = this.getResourceType("myPlatform4");
            this.getTransactionManager().begin();
            platform1 = (ResourceType)this.em.find(ResourceType.class, (Object)platform1.getId());
            Set servers1 = platform1.getChildResourceTypes();
            assert (servers1.size() == 2) : "Expected to find 2 servers in v1";
            int found = 0;
            for (ResourceType server : servers1) {
                if (server.getName().equals("testServer1")) {
                    ++found;
                }
                if (!server.getName().equals("testServer2")) continue;
                ++found;
            }
            assert (found == 2) : "I did not find the expected servers in v1";
            this.getTransactionManager().rollback();
            this.registerPlugin("update4-v2_0.xml");
            ResourceType platform2 = this.getResourceType("myPlatform4");
            this.getTransactionManager().begin();
            platform2 = (ResourceType)this.em.find(ResourceType.class, (Object)platform2.getId());
            Set servers2 = platform2.getChildResourceTypes();
            assert (servers2.size() == 1) : "Expected to find 1 servers in v2";
            ResourceType server2 = (ResourceType)servers2.iterator().next();
            assert (server2.getName().equals("testServer1"));
            Set mdef = server2.getMetricDefinitions();
            assert (mdef.size() == 2) : "Expected 2 MeasurementDefinition in v2";
            this.getTransactionManager().rollback();
            this.registerPlugin("update4-v1_0.xml", "3.0");
            ResourceType platform3 = this.getResourceType("myPlatform4");
            this.getTransactionManager().begin();
            platform3 = (ResourceType)this.em.find(ResourceType.class, (Object)platform3.getId());
            Set servers3 = platform3.getChildResourceTypes();
            assert (servers3.size() == 2) : "Expected to find 2 servers in v1/2";
            found = 0;
            for (ResourceType server : servers3) {
                if (server.getName().equals("testServer1")) {
                    ++found;
                }
                if (!server.getName().equals("testServer2")) continue;
                ++found;
            }
            assert (found == 2) : "I did not find the expected servers in v1/2";
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveResourceType() throws Exception {
        System.out.println("testMoveResourceType --- start");
        try {
            this.registerPlugin("update2-v1_0.xml");
            Subject overlord = LookupUtil.getSubjectManager().getOverlord();
            ResourceType platform1 = this.getResourceType("myPlatform");
            Resource platformResource = this.createResource("foo-myPlatform", "foo-myPlatform", platform1);
            resourceManager.createResource(overlord, platformResource, -1);
            ResourceType service1 = this.getResourceType("service1");
            Resource service1Resource = this.createResource("foo-service1", "foo-service1", service1);
            platformResource.addChildResource(service1Resource);
            resourceManager.createResource(overlord, service1Resource, -1);
            ResourceType nestedOne = this.getResourceType("nestedOne");
            Resource nestedOneResource = this.createResource("foo-nestedOne", "foo-nestedOne", nestedOne);
            service1Resource.addChildResource(nestedOneResource);
            resourceManager.createResource(overlord, nestedOneResource, -1);
            this.getTransactionManager().begin();
            platform1 = (ResourceType)this.em.find(ResourceType.class, (Object)platform1.getId());
            assert (platform1 != null) : "I did not find myPlatform";
            Set defs = platform1.getMetricDefinitions();
            assert (defs.size() == 1) : "I was expecting 1 metric definition at platform level in v1";
            assert (DisplayType.DETAIL == ((MeasurementDefinition)defs.iterator().next()).getDisplayType()) : "Display type should be DETAIL in v1";
            Set platformChildren = platform1.getChildResourceTypes();
            assert (platformChildren.size() == 1) : "Expected 1 direct child service of platform in v1";
            service1 = (ResourceType)platformChildren.iterator().next();
            assert (service1.getName().equals("service1")) : "Expected 'service1' as name of direct platform child in v1";
            assert (service1.getMetricDefinitions().size() == 2) : "Expected 2 metric for 'service1' in v1";
            Set nestedServices = service1.getChildResourceTypes();
            assert (nestedServices.size() == 1) : "Expected 1 nested service of 'service1' in v1";
            Set nestedDefs = ((ResourceType)nestedServices.iterator().next()).getMetricDefinitions();
            assert (nestedDefs.size() == 2) : "Expected 2 definition within 'nestedService' in v1";
            MeasurementDefinition defThree = (MeasurementDefinition)nestedDefs.iterator().next();
            int definitionId = defThree.getId();
            this.getTransactionManager().rollback();
            System.out.println("testMoveResourceType -- done with the first plugin version");
            this.registerPlugin("update2-v2_0.xml");
            ResourceType platform2 = this.getResourceType("myPlatform");
            this.getTransactionManager().begin();
            platform2 = (ResourceType)this.em.find(ResourceType.class, (Object)platform2.getId());
            assert (platform2 != null) : "I did not find myPlatform";
            Set defs2 = platform2.getMetricDefinitions();
            assert (defs2.size() == 1) : "I was expecting 1 definition at platform level in v2";
            assert (DisplayType.SUMMARY == ((MeasurementDefinition)defs2.iterator().next()).getDisplayType()) : "Display type should be SUMMARY in v2";
            ResourceCriteria resourceCriteria = new ResourceCriteria();
            resourceCriteria.setStrict(true);
            resourceCriteria.addFilterResourceKey("foo-myPlatform");
            resourceCriteria.fetchChildResources(true);
            Resource platform2Resource = this.getResource(resourceCriteria);
            assert (platform2Resource != null) : "Expected to find platform Resource in db.";
            Set platformChildren2 = platform2.getChildResourceTypes();
            assert (platformChildren2.size() == 2) : "Expected 2 direct child service types of platform in v2";
            Set platform2ChildResources = platform2Resource.getChildResources();
            assert (platform2ChildResources.size() == 2) : "Expected 2 direct child services of platform in v2";
            boolean foundMovedResource = false;
            for (Resource childResource : platform2ChildResources) {
                assert (childResource.getChildResources().isEmpty()) : "Expected child Resource " + childResource + " to have no children";
                if (!childResource.getResourceKey().equals("foo-nestedOne")) continue;
                foundMovedResource = true;
            }
            assert (foundMovedResource) : "Expected 'foo-nestedOne' Resource to have been moved directly under platform Resource";
            for (ResourceType type : platformChildren2) {
                String typeName = type.getName();
                assert (type.getMetricDefinitions().size() == 2) : "Expected two definition for " + typeName + " in v2";
                if (typeName.equals("nestedOne")) {
                    Set defs3 = type.getMetricDefinitions();
                    MeasurementDefinition three = (MeasurementDefinition)defs3.iterator().next();
                    assert (three.getDisplayName().equals("Three")) : "Expected the nestedOne to have a metric withDisplayName Three in v2, but it was " + three.getDisplayName();
                    assert (three.getDisplayType() == DisplayType.SUMMARY) : "Expected three to be SUMMARY in v2";
                    assert (three.getId() == definitionId) : "Expected the id of 'Three' to be " + definitionId + ", but it was " + three.getId() + " in v2";
                    continue;
                }
                if (typeName.equals("service1")) {
                    Set childrenOfService = type.getChildResourceTypes();
                    assert (childrenOfService.size() == 0) : "No children of 'service1' expected in v2, but found: " + childrenOfService.size();
                    continue;
                }
                assert (false) : "We found an unknown type with name " + typeName;
            }
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
        System.out.println("testMoveResourceType --- end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateResourceType() throws Exception {
        System.out.println("= testDuplicateResourceType");
        try {
            System.out.println("NOTE: A stack trace coming out of this is expected.");
            this.registerPlugin("duplicateResourceType.xml");
            this.getResourceType("ops");
            assert (false) : "We should not have hit this line";
        }
        catch (Exception exception) {
        }
        finally {
            if (6 != this.getTransactionManager().getStatus()) {
                this.getTransactionManager().rollback();
            }
        }
    }
}

