/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.test;

import java.util.Arrays;
import javax.ejb.EJBException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.Test;

public class GroupMemberCandidateResourcesTest
extends AbstractEJB3Test {
    private static final String GROUP_MEMBER_CANDIDATE_NAME_PREFIX = GroupMemberCandidateResourcesTest.class.getSimpleName() + "-";
    private Subject overlord;
    private ResourceManagerLocal resourceManager;

    @Override
    protected void beforeMethod() throws Exception {
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        this.overlord = subjectManager.getOverlord();
        this.resourceManager = LookupUtil.getResourceManager();
    }

    @Test
    public void testNoCandidates() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                ResourceCriteria criteria = new ResourceCriteria();
                criteria.setCaseSensitive(false);
                criteria.addFilterName(GROUP_MEMBER_CANDIDATE_NAME_PREFIX);
                PageList groupMemberCandidateResources = GroupMemberCandidateResourcesTest.this.resourceManager.findGroupMemberCandidateResources(GroupMemberCandidateResourcesTest.this.overlord, criteria, new int[0]);
                GroupMemberCandidateResourcesTest.this.assertEquals(0, groupMemberCandidateResources.getTotalSize());
                GroupMemberCandidateResourcesTest.this.assertEquals(0, groupMemberCandidateResources.size());
            }
        });
    }

    @Test
    public void testNoCandidatesWithExclusions() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                ResourceCriteria criteria = new ResourceCriteria();
                criteria.setCaseSensitive(false);
                criteria.addFilterName(GROUP_MEMBER_CANDIDATE_NAME_PREFIX);
                int[] alreadySelectedResourceIds = new int[100];
                for (int i = 0; i < alreadySelectedResourceIds.length; ++i) {
                    alreadySelectedResourceIds[i] = i;
                }
                PageList groupMemberCandidateResources = GroupMemberCandidateResourcesTest.this.resourceManager.findGroupMemberCandidateResources(GroupMemberCandidateResourcesTest.this.overlord, criteria, alreadySelectedResourceIds);
                GroupMemberCandidateResourcesTest.this.assertEquals(0, groupMemberCandidateResources.getTotalSize());
                GroupMemberCandidateResourcesTest.this.assertEquals(0, groupMemberCandidateResources.size());
            }
        });
    }

    @Test
    public void testUnlimitedPageControl() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                ResourceCriteria criteria = new ResourceCriteria();
                criteria.setPageControl(PageControl.getUnlimitedInstance());
                try {
                    PageList groupMemberCandidateResources = GroupMemberCandidateResourcesTest.this.resourceManager.findGroupMemberCandidateResources(GroupMemberCandidateResourcesTest.this.overlord, criteria, new int[0]);
                    GroupMemberCandidateResourcesTest.this.fail("findGroupMemberCandidateResources should throw UnsupportedOperationException");
                }
                catch (EJBException e) {
                    GroupMemberCandidateResourcesTest.this.assertTrue(e.getCausedByException() instanceof UnsupportedOperationException);
                }
            }
        });
    }

    @Test
    public void testPageControl() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                int resourcesCount = 100;
                GroupMemberCandidateResourcesTest.this.createTestResources(resourcesCount);
                ResourceCriteria criteria = new ResourceCriteria();
                criteria.setCaseSensitive(false);
                criteria.addFilterName(GROUP_MEMBER_CANDIDATE_NAME_PREFIX);
                criteria.addSortName(PageOrdering.ASC);
                int pageNumber = 5;
                int pageSize = 7;
                criteria.setPaging(pageNumber, pageSize);
                PageList groupMemberCandidateResources = GroupMemberCandidateResourcesTest.this.resourceManager.findGroupMemberCandidateResources(GroupMemberCandidateResourcesTest.this.overlord, criteria, new int[0]);
                GroupMemberCandidateResourcesTest.this.assertEquals(resourcesCount, groupMemberCandidateResources.getTotalSize());
                GroupMemberCandidateResourcesTest.this.assertEquals(pageSize, groupMemberCandidateResources.size());
                for (Resource groupMemberCandidateResource : groupMemberCandidateResources) {
                    GroupMemberCandidateResourcesTest.this.assertTrue(groupMemberCandidateResource.getName().startsWith(GROUP_MEMBER_CANDIDATE_NAME_PREFIX));
                }
                GroupMemberCandidateResourcesTest.this.assertEquals(pageNumber, groupMemberCandidateResources.getPageControl().getPageNumber());
                GroupMemberCandidateResourcesTest.this.assertEquals(pageSize, groupMemberCandidateResources.getPageControl().getPageSize());
            }
        });
    }

    @Test
    public void testPageControlWithExclusions() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                int resourcesCount = 100;
                int[] resourcesIds = GroupMemberCandidateResourcesTest.this.createTestResources(resourcesCount);
                ResourceCriteria criteria = new ResourceCriteria();
                criteria.setCaseSensitive(false);
                criteria.addFilterName(GROUP_MEMBER_CANDIDATE_NAME_PREFIX);
                criteria.addSortName(PageOrdering.ASC);
                int pageNumber = 5;
                int pageSize = 7;
                criteria.setPaging(pageNumber, pageSize);
                int[] alreadySelectedResourceIds = Arrays.copyOfRange(resourcesIds, 13, 59);
                PageList groupMemberCandidateResources = GroupMemberCandidateResourcesTest.this.resourceManager.findGroupMemberCandidateResources(GroupMemberCandidateResourcesTest.this.overlord, criteria, alreadySelectedResourceIds);
                GroupMemberCandidateResourcesTest.this.assertEquals(resourcesCount, groupMemberCandidateResources.getTotalSize());
                GroupMemberCandidateResourcesTest.this.assertEquals(pageSize, groupMemberCandidateResources.size());
                for (Resource groupMemberCandidateResource : groupMemberCandidateResources) {
                    GroupMemberCandidateResourcesTest.this.assertTrue(groupMemberCandidateResource.getName().startsWith(GROUP_MEMBER_CANDIDATE_NAME_PREFIX));
                }
                GroupMemberCandidateResourcesTest.this.assertEquals(pageNumber, groupMemberCandidateResources.getPageControl().getPageNumber());
                GroupMemberCandidateResourcesTest.this.assertEquals(pageSize, groupMemberCandidateResources.getPageControl().getPageSize());
            }
        });
    }

    private int[] createTestResources(int resourcesCount) {
        int[] resourcesIds = new int[resourcesCount];
        ResourceType testResourceType = SessionTestHelper.createNewResourceType(this.em);
        for (int i = 0; i < resourcesCount; ++i) {
            resourcesIds[i] = SessionTestHelper.createNewResource(this.em, GROUP_MEMBER_CANDIDATE_NAME_PREFIX + i, testResourceType).getId();
        }
        return resourcesIds;
    }
}

