/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.test;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.ejb.EJBException;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.inventory.CreateResourceRequest;
import org.rhq.core.clientapi.agent.inventory.CreateResourceResponse;
import org.rhq.core.clientapi.agent.inventory.DeleteResourceRequest;
import org.rhq.core.clientapi.agent.inventory.DeleteResourceResponse;
import org.rhq.core.clientapi.agent.inventory.ResourceFactoryAgentService;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageCategory;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.resource.CreateDeletePolicy;
import org.rhq.core.domain.resource.CreateResourceHistory;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.DeleteResourceHistory;
import org.rhq.core.domain.resource.DeleteResourceStatus;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceCreationDataType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.discovery.DiscoveryBossLocal;
import org.rhq.enterprise.server.resource.ResourceFactoryManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.StandardServerPluginService;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

public class ResourceFactoryManagerBeanTest
extends AbstractEJB3Test {
    private static final String TEST_PLUGIN_NAME = "TestPlugin";
    private ResourceFactoryManagerLocal resourceFactoryManager;
    private ResourceManagerLocal resourceManager;
    private DiscoveryBossLocal discoveryBoss;
    private Subject overlord;
    private MockResourceFactoryAgentService mockAgentService = new MockResourceFactoryAgentService();
    private Resource parentResource;
    private ResourceType parentResourceType;
    private ResourceType contentBackedChildResourceType;
    private ResourceType configBackedChildResourceType1;
    private ResourceType configBackedChildResourceType2;
    private PackageType packageType;

    @Override
    protected void beforeMethod() throws Exception {
        this.resourceFactoryManager = LookupUtil.getResourceFactoryManager();
        this.resourceManager = LookupUtil.getResourceManager();
        this.discoveryBoss = LookupUtil.getDiscoveryBoss();
        this.overlord = LookupUtil.getSubjectManager().getOverlord();
        this.prepareScheduler();
        TestServerCommunicationsService agentServiceContainer = this.prepareForTestAgents();
        agentServiceContainer.resourceFactoryService = this.mockAgentService;
        StandardServerPluginService serverPluginService = new StandardServerPluginService(this.getTempDir());
        this.prepareCustomServerPluginService(serverPluginService);
        serverPluginService.startMasterPluginContainer();
        this.setupResourceEnvironment();
    }

    @Override
    protected void afterMethod() throws Exception {
        this.unprepareForTestAgents();
        this.unprepareScheduler();
        this.unprepareServerPluginService();
        this.teardownResourceEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createResourceViaConfiguration() throws Exception {
        this.mockAgentService.setCreateReturnStatus(CreateResourceStatus.SUCCESS);
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Configuration resourceConfiguration = new Configuration();
        resourceConfiguration.put((Property)new PropertySimple("property1", (Object)"value1"));
        this.resourceFactoryManager.createResource(overlord, this.parentResource.getId(), this.configBackedChildResourceType1.getId(), "newResource", null, resourceConfiguration);
        try {
            this.getTransactionManager().begin();
            Resource parent = (Resource)this.em.find(Resource.class, (Object)this.parentResource.getId());
            List historyList = parent.getCreateChildResourceRequests();
            assert (historyList.size() == 1) : "Incorrect number of children found. Expected: 1, Found: " + historyList.size();
            CreateResourceHistory historyItem = (CreateResourceHistory)historyList.get(0);
            assert (historyItem.getStatus() == CreateResourceStatus.SUCCESS) : "Incorrect status for history item. Expected: Success, Found: " + historyItem.getStatus();
            assert (historyItem.getNewResourceKey().equals("mockResourceKey")) : "Incorrect resource key for history item. Expected: mockResourceKey, Found: " + historyItem.getNewResourceKey();
            assert (historyItem.getErrorMessage() == null) : "Error message found for successful call";
            assert (historyItem.getConfiguration() != null) : "Null configuration found for history item";
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createResourceViaConfigurationFailure() throws Exception {
        this.mockAgentService.setCreateReturnStatus(CreateResourceStatus.FAILURE);
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Configuration resourceConfiguration = new Configuration();
        resourceConfiguration.put((Property)new PropertySimple("property1", (Object)"value1"));
        this.resourceFactoryManager.createResource(overlord, this.parentResource.getId(), this.configBackedChildResourceType1.getId(), "newResource", null, resourceConfiguration);
        try {
            this.getTransactionManager().begin();
            Resource parent = (Resource)this.em.find(Resource.class, (Object)this.parentResource.getId());
            List historyList = parent.getCreateChildResourceRequests();
            assert (historyList.size() == 1) : "Incorrect number of children found. Expected: 1, Found: " + historyList.size();
            CreateResourceHistory historyItem = (CreateResourceHistory)historyList.get(0);
            assert (historyItem.getStatus() == CreateResourceStatus.FAILURE) : "Incorrect status for history item. Expected: Failure, Found: " + historyItem.getStatus();
            assert (historyItem.getErrorMessage().equals("errorMessage")) : "Incorrect error message for history item. Expected: errorMessage, Found: " + historyItem.getErrorMessage();
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createSingletonResourceViaConfiguration() throws Exception {
        this.mockAgentService.setCreateReturnStatus(CreateResourceStatus.SUCCESS);
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Configuration resourceConfiguration = new Configuration();
        resourceConfiguration.put((Property)new PropertySimple("property1", (Object)"value1"));
        CreateResourceHistory history1 = this.resourceFactoryManager.createResource(overlord, this.parentResource.getId(), this.configBackedChildResourceType2.getId(), "newResource", null, resourceConfiguration);
        try {
            this.getTransactionManager().begin();
            Resource parent = (Resource)this.em.find(Resource.class, (Object)this.parentResource.getId());
            List historyList = parent.getCreateChildResourceRequests();
            assert (historyList.size() == 1) : "Incorrect number of children found. Expected: 1, Found: " + historyList.size();
            CreateResourceHistory historyItem = (CreateResourceHistory)historyList.get(0);
            assert (historyItem.getStatus() == CreateResourceStatus.SUCCESS) : "Incorrect status for history item. Expected: Success, Found: " + historyItem.getStatus();
            assert (historyItem.getNewResourceKey().equals("mockResourceKey")) : "Incorrect resource key for history item. Expected: mockResourceKey, Found: " + historyItem.getNewResourceKey();
            assert (historyItem.getErrorMessage() == null) : "Error message found for successful call";
            assert (historyItem.getConfiguration() != null) : "Null configuration found for history item";
        }
        finally {
            this.getTransactionManager().rollback();
        }
        this.resourceFactoryManager.completeCreateResource(new CreateResourceResponse(history1.getId(), "newResource", "key", CreateResourceStatus.SUCCESS, null, new Configuration()));
        Resource resource = new Resource(1000000);
        resource.setUuid(UUID.randomUUID().toString());
        resource.setResourceType(this.configBackedChildResourceType2);
        long randomLong = UUID.randomUUID().getLeastSignificantBits();
        resource.setResourceKey(String.valueOf("key-" + randomLong));
        resource.setName("name-" + randomLong);
        resource.setParentResource(this.parentResource);
        this.discoveryBoss.addResource(resource, overlord.getId());
        try {
            CreateResourceHistory history2 = this.resourceFactoryManager.createResource(overlord, this.parentResource.getId(), this.configBackedChildResourceType2.getId(), "newResource2", null, resourceConfiguration);
            this.fail("Creating a singleton that already existed succeeded: " + history2);
        }
        catch (EJBException e) {
            this.assertEquals(String.valueOf(e.getCause()), RuntimeException.class, e.getCause().getClass());
            this.assertTrue(String.valueOf(e.getCause()), e.getCause().getMessage().contains("singleton"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createSingletonResourceViaPackage() throws Exception {
        this.mockAgentService.setCreateReturnStatus(CreateResourceStatus.SUCCESS);
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        String packageName = "testDataResourcePackage";
        String packageVersion = "1.0.0";
        int architectureId = 1;
        Configuration deploymentTimeConfiguration = new Configuration();
        deploymentTimeConfiguration.put((Property)new PropertySimple("testProperty", (Object)"testValue"));
        URL contentResource = ((Object)((Object)this)).getClass().getClassLoader().getResource("test-scheduler.properties");
        assert (contentResource != null) : "Could not load test-scheduler.properties as package content";
        InputStream packageInputStream = contentResource.openStream();
        CreateResourceHistory history1 = this.resourceFactoryManager.createResource(overlord, this.parentResource.getId(), this.contentBackedChildResourceType.getId(), "newResource", null, packageName, packageVersion, Integer.valueOf(architectureId), deploymentTimeConfiguration, packageInputStream);
        try {
            this.getTransactionManager().begin();
            Resource parent = (Resource)this.em.find(Resource.class, (Object)this.parentResource.getId());
            List historyList = parent.getCreateChildResourceRequests();
            assert (historyList.size() == 1) : "Incorrect number of children found. Expected: 1, Found: " + historyList.size();
            CreateResourceHistory historyItem = (CreateResourceHistory)historyList.get(0);
            assert (historyItem.getStatus() == CreateResourceStatus.SUCCESS) : "Incorrect status for history item. Expected: Success, Found: " + historyItem.getStatus();
            assert (historyItem.getNewResourceKey().equals("mockResourceKey")) : "Incorrect resource key for history item. Expected: mockResourceKey, Found: " + historyItem.getNewResourceKey();
            assert (historyItem.getErrorMessage() == null) : "Error message found for successful call";
        }
        finally {
            this.getTransactionManager().rollback();
        }
        this.resourceFactoryManager.completeCreateResource(new CreateResourceResponse(history1.getId(), "newResource", "key", CreateResourceStatus.SUCCESS, null, new Configuration()));
        Resource resource = new Resource(2000000);
        resource.setUuid(UUID.randomUUID().toString());
        resource.setResourceType(this.contentBackedChildResourceType);
        long randomLong = UUID.randomUUID().getLeastSignificantBits();
        resource.setResourceKey(String.valueOf("key-" + randomLong));
        resource.setName("name-" + randomLong);
        resource.setParentResource(this.parentResource);
        this.discoveryBoss.addResource(resource, overlord.getId());
        try {
            CreateResourceHistory history2 = this.resourceFactoryManager.createResource(overlord, this.parentResource.getId(), this.contentBackedChildResourceType.getId(), "newResource2", null, packageName, packageVersion, Integer.valueOf(architectureId), deploymentTimeConfiguration, packageInputStream);
            this.fail("Creating a singleton that already existed succeeded: " + history2);
        }
        catch (EJBException e) {
            this.assertEquals(String.valueOf(e.getCause()), RuntimeException.class, e.getCause().getClass());
            this.assertTrue(String.valueOf(e.getCause()), e.getCause().getMessage().contains("singleton"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deleteResource() throws Exception {
        this.mockAgentService.setDeleteReturnStatus(DeleteResourceStatus.SUCCESS);
        Resource deleteMe = this.addResourceToParent();
        assert (deleteMe != null) : "Child resource to be deleted was not correctly added in the first place";
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        this.resourceFactoryManager.deleteResource(overlord, deleteMe.getId());
        try {
            this.getTransactionManager().begin();
            Resource parent = (Resource)this.em.find(Resource.class, (Object)this.parentResource.getId());
            Set childResources = parent.getChildResources();
            assert (childResources.size() == 1) : "Child resource not found on the parent";
            Resource deletedResource = (Resource)childResources.iterator().next();
            assert (deletedResource.getInventoryStatus() == InventoryStatus.DELETED) : "Inventory status for deleted resource was incorrect. Expected: Deleted, Found: " + deletedResource.getInventoryStatus();
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deleteResourceFailure() throws Exception {
        this.mockAgentService.setDeleteReturnStatus(DeleteResourceStatus.FAILURE);
        Resource deleteMe = this.addResourceToParent();
        assert (deleteMe != null) : "Child resource to be deleted was not correctly added in the first place";
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        this.resourceFactoryManager.deleteResource(overlord, deleteMe.getId());
        try {
            this.getTransactionManager().begin();
            Resource parent = (Resource)this.em.find(Resource.class, (Object)this.parentResource.getId());
            Set childResources = parent.getChildResources();
            assert (childResources.size() == 1) : "Child resource not found on the parent";
            Resource deletedResource = (Resource)childResources.iterator().next();
            assert (deletedResource.getInventoryStatus() == InventoryStatus.COMMITTED) : "Inventory status for deleted resource was incorrect. Expected: Committed, Found: " + deletedResource.getInventoryStatus();
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    @Test
    public void createHistory() {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Configuration resourceConfiguration = new Configuration();
        resourceConfiguration.getMap();
        this.resourceFactoryManager.createResource(overlord, this.parentResource.getId(), this.configBackedChildResourceType1.getId(), "resource1", (Configuration)null, resourceConfiguration);
        resourceConfiguration = new Configuration();
        resourceConfiguration.getMap();
        this.resourceFactoryManager.createResource(overlord, this.parentResource.getId(), this.configBackedChildResourceType1.getId(), "resource2", (Configuration)null, resourceConfiguration);
        resourceConfiguration = new Configuration();
        resourceConfiguration.getMap();
        this.resourceFactoryManager.createResource(overlord, this.parentResource.getId(), this.configBackedChildResourceType1.getId(), "resource3", (Configuration)null, resourceConfiguration);
        int numRequestsInHistory = this.resourceFactoryManager.getCreateChildResourceHistoryCount(this.parentResource.getId(), null, null);
        assert (numRequestsInHistory == 3) : "Incorrect history count. Expected: 3, Found: " + numRequestsInHistory;
        PageControl pageControl = new PageControl(0, 10000);
        pageControl.initDefaultOrderingField("createdResourceName");
        PageList historyList = this.resourceFactoryManager.findCreateChildResourceHistory(overlord, this.parentResource.getId(), null, null, pageControl);
        assert (historyList.getTotalSize() == 3) : "Incorrect number of entries in page list. Expected: 3, Found: " + historyList.getTotalSize();
        assert (((CreateResourceHistory)historyList.get(0)).getCreatedResourceName().equals("resource1")) : "History entry 1 is invalid";
        assert (((CreateResourceHistory)historyList.get(1)).getCreatedResourceName().equals("resource2")) : "History entry 2 is invalid";
        assert (((CreateResourceHistory)historyList.get(2)).getCreatedResourceName().equals("resource3")) : "History entry 3 is invalid";
    }

    @Test
    public void deleteHistory() throws Exception {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Resource resource1 = this.addResourceToParent();
        Resource resource2 = this.addResourceToParent();
        Resource resource3 = this.addResourceToParent();
        this.resourceFactoryManager.deleteResource(overlord, resource1.getId());
        this.resourceFactoryManager.deleteResource(overlord, resource2.getId());
        this.resourceFactoryManager.deleteResource(overlord, resource3.getId());
        int numRequestsInHistory = this.resourceFactoryManager.getDeleteChildResourceHistoryCount(this.parentResource.getId(), null, null);
        assert (numRequestsInHistory == 3) : "Incorrect history count. Expected: 3, Found: " + numRequestsInHistory;
        PageControl pageControl = new PageControl(0, 10000);
        pageControl.initDefaultOrderingField("drh.id");
        PageList historyList = this.resourceFactoryManager.findDeleteChildResourceHistory(overlord, this.parentResource.getId(), null, null, pageControl);
        assert (historyList.getTotalSize() == 3) : "Incorrect number of entries in page list. Expected: 3, Found: " + historyList.getTotalSize();
        assert (((DeleteResourceHistory)historyList.get(0)).getResource().getId() == resource1.getId()) : "History entry 1 is invalid";
        assert (((DeleteResourceHistory)historyList.get(1)).getResource().getId() == resource2.getId()) : "History entry 2 is invalid";
        assert (((DeleteResourceHistory)historyList.get(2)).getResource().getId() == resource3.getId()) : "History entry 3 is invalid";
    }

    @Test
    public void getHistoryItem() throws Exception {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        Configuration resourceConfiguration = new Configuration();
        resourceConfiguration.getMap();
        this.resourceFactoryManager.createResource(overlord, this.parentResource.getId(), this.configBackedChildResourceType1.getId(), "NewResource", null, resourceConfiguration);
        PageList historyList = this.resourceFactoryManager.findCreateChildResourceHistory(overlord, this.parentResource.getId(), null, null, new PageControl(0, 1000));
        int historyItemId = ((CreateResourceHistory)historyList.get(0)).getId();
        CreateResourceHistory historyItem = this.resourceFactoryManager.getCreateHistoryItem(historyItemId);
        assert (historyItem != null) : "Null history item returned from call";
        assert (historyItem.getCreatedResourceName().equals("NewResource"));
    }

    private void setupResourceEnvironment() throws Exception {
        this.getTransactionManager().begin();
        try {
            this.parentResourceType = new ResourceType("platform-" + System.currentTimeMillis(), TEST_PLUGIN_NAME, ResourceCategory.PLATFORM, null);
            this.em.persist((Object)this.parentResourceType);
            this.contentBackedChildResourceType = new ResourceType("service-" + System.currentTimeMillis(), TEST_PLUGIN_NAME, ResourceCategory.SERVICE, this.parentResourceType);
            this.contentBackedChildResourceType.setCreateDeletePolicy(CreateDeletePolicy.BOTH);
            this.contentBackedChildResourceType.setCreationDataType(ResourceCreationDataType.CONTENT);
            this.contentBackedChildResourceType.setSingleton(true);
            this.em.persist((Object)this.contentBackedChildResourceType);
            this.packageType = new PackageType();
            this.packageType.setName("artifact-" + System.currentTimeMillis());
            this.packageType.setDescription("");
            this.packageType.setCategory(PackageCategory.DEPLOYABLE);
            this.packageType.setDisplayName("TestResourceArtifact");
            this.packageType.setCreationData(true);
            this.packageType.setResourceType(this.contentBackedChildResourceType);
            this.em.persist((Object)this.packageType);
            this.contentBackedChildResourceType.addPackageType(this.packageType);
            this.configBackedChildResourceType1 = new ResourceType("service1-" + System.currentTimeMillis(), TEST_PLUGIN_NAME, ResourceCategory.SERVICE, this.parentResourceType);
            this.configBackedChildResourceType1.setCreateDeletePolicy(CreateDeletePolicy.BOTH);
            this.configBackedChildResourceType1.setCreationDataType(ResourceCreationDataType.CONFIGURATION);
            this.em.persist((Object)this.configBackedChildResourceType1);
            this.configBackedChildResourceType2 = new ResourceType("service2-" + System.currentTimeMillis(), TEST_PLUGIN_NAME, ResourceCategory.SERVICE, this.parentResourceType);
            this.configBackedChildResourceType2.setCreateDeletePolicy(CreateDeletePolicy.BOTH);
            this.configBackedChildResourceType2.setCreationDataType(ResourceCreationDataType.CONFIGURATION);
            this.configBackedChildResourceType2.setSingleton(true);
            this.em.persist((Object)this.configBackedChildResourceType2);
            this.parentResource = new Resource("parent" + System.currentTimeMillis(), "name", this.parentResourceType);
            this.parentResource.setUuid("" + new Random().nextInt());
            this.em.persist((Object)this.parentResource);
        }
        catch (Exception e) {
            System.out.println(e);
            this.getTransactionManager().rollback();
            throw e;
        }
        this.getTransactionManager().commit();
    }

    private void teardownResourceEnvironment() throws Exception {
        if (this.parentResource != null) {
            List deletedIds = this.resourceManager.uninventoryResource(this.overlord, this.parentResource.getId());
            for (Integer deletedResourceId : deletedIds) {
                this.resourceManager.uninventoryResourceAsyncWork(this.overlord, deletedResourceId.intValue());
            }
            this.getTransactionManager().begin();
            try {
                ResourceType deleteMeType = (ResourceType)this.em.find(ResourceType.class, (Object)this.contentBackedChildResourceType.getId());
                this.em.remove((Object)deleteMeType);
                deleteMeType = (ResourceType)this.em.find(ResourceType.class, (Object)this.configBackedChildResourceType1.getId());
                this.em.remove((Object)deleteMeType);
                deleteMeType = (ResourceType)this.em.find(ResourceType.class, (Object)this.configBackedChildResourceType2.getId());
                this.em.remove((Object)deleteMeType);
                deleteMeType = (ResourceType)this.em.find(ResourceType.class, (Object)this.parentResourceType.getId());
                this.em.remove((Object)deleteMeType);
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                try {
                    System.out.println(e);
                    this.getTransactionManager().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
        }
    }

    private Resource addResourceToParent() throws Exception {
        Resource resource = null;
        this.getTransactionManager().begin();
        try {
            resource = new Resource("child" + System.currentTimeMillis(), "name", this.parentResourceType);
            resource.setUuid("" + new Random().nextInt());
            resource.setParentResource(this.parentResource);
            resource.setInventoryStatus(InventoryStatus.COMMITTED);
            this.em.persist((Object)resource);
        }
        catch (Exception e) {
            System.out.println(e);
            this.getTransactionManager().rollback();
        }
        this.getTransactionManager().commit();
        return resource;
    }

    private class MockResourceFactoryAgentService
    implements ResourceFactoryAgentService {
        private CreateResourceStatus createReturnStatus = CreateResourceStatus.SUCCESS;
        private DeleteResourceStatus deleteReturnStatus = DeleteResourceStatus.SUCCESS;

        private MockResourceFactoryAgentService() {
        }

        public void setCreateReturnStatus(CreateResourceStatus createReturnStatus) {
            this.createReturnStatus = createReturnStatus;
        }

        public void setDeleteReturnStatus(DeleteResourceStatus deleteReturnStatus) {
            this.deleteReturnStatus = deleteReturnStatus;
        }

        public void createResource(CreateResourceRequest request) throws PluginContainerException {
            CreateResourceResponse response = null;
            switch (this.createReturnStatus) {
                case SUCCESS: {
                    response = new CreateResourceResponse(request.getRequestId(), "mockResourceName", "mockResourceKey", CreateResourceStatus.SUCCESS, null, request.getResourceConfiguration());
                    break;
                }
                case FAILURE: {
                    response = new CreateResourceResponse(request.getRequestId(), null, null, CreateResourceStatus.FAILURE, "errorMessage", request.getResourceConfiguration());
                }
            }
            ResourceFactoryManagerBeanTest.this.resourceFactoryManager.completeCreateResource(response);
        }

        public void deleteResource(DeleteResourceRequest request) throws PluginContainerException {
            DeleteResourceResponse response = null;
            switch (this.deleteReturnStatus) {
                case SUCCESS: {
                    response = new DeleteResourceResponse(request.getRequestId(), this.deleteReturnStatus, null);
                    break;
                }
                case FAILURE: {
                    response = new DeleteResourceResponse(request.getRequestId(), this.deleteReturnStatus, "errorMessage");
                }
            }
            ResourceFactoryManagerBeanTest.this.resourceFactoryManager.completeDeleteResourceRequest(response);
        }

        public CreateResourceResponse executeCreateResourceImmediately(CreateResourceRequest request) throws PluginContainerException {
            return null;
        }

        public DeleteResourceResponse executeDeleteResourceImmediately(DeleteResourceRequest request) throws PluginContainerException {
            return null;
        }
    }
}

