/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.test;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.rhq.core.clientapi.agent.discovery.DiscoveryAgentService;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertConditionOperator;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.alert.BooleanExpression;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceGroupCriteria;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceError;
import org.rhq.core.domain.resource.ResourceErrorType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.auth.SessionManager;
import org.rhq.enterprise.server.auth.SessionNotFoundException;
import org.rhq.enterprise.server.discovery.DiscoveryServerServiceImpl;
import org.rhq.enterprise.server.operation.OperationDefinitionNotFoundException;
import org.rhq.enterprise.server.resource.ResourceNotFoundException;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupNotFoundException;
import org.rhq.enterprise.server.resource.group.definition.exception.GroupDefinitionNotFoundException;
import org.rhq.enterprise.server.resource.metadata.test.UpdatePluginMetadataTestBase;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

@Test
public class ResourceManagerBeanTest
extends UpdatePluginMetadataTestBase {
    private Resource newResource;
    private ResourceGroup newGroup;
    private ResourceGroupManagerLocal groupManager;

    @Override
    protected void beforeMethod() throws Exception {
        super.beforeMethod();
        this.newResource = this.createNewResourceWithNewType();
        this.groupManager = LookupUtil.getResourceGroupManager();
        this.newGroup = this.createNewGroup();
    }

    public void testResourceErrors() {
        DiscoveryServerServiceImpl serverService = new DiscoveryServerServiceImpl();
        List errors = resourceManager.findResourceErrors(this.getOverlord(), this.newResource.getId(), ResourceErrorType.INVALID_PLUGIN_CONFIGURATION);
        assert (errors.size() == 0);
        ResourceError error = new ResourceError(this.newResource, ResourceErrorType.INVALID_PLUGIN_CONFIGURATION, "test summary", "test detail", 12345L);
        serverService.setResourceError(error);
        errors = resourceManager.findResourceErrors(this.getOverlord(), this.newResource.getId(), ResourceErrorType.INVALID_PLUGIN_CONFIGURATION);
        assert (errors.size() == 1);
        error = (ResourceError)errors.get(0);
        assert (error.getId() > 0);
        assert (error.getSummary().equals("test summary"));
        assert (error.getDetail().equals("test detail"));
        assert (error.getErrorType() == ResourceErrorType.INVALID_PLUGIN_CONFIGURATION);
        assert (error.getTimeOccurred() == 12345L);
        error.setId(0);
        error.setTimeOccurred(567890L);
        error.setSummary("another summary");
        error.setDetail("another detail");
        serverService.setResourceError(error);
        errors = resourceManager.findResourceErrors(this.getOverlord(), this.newResource.getId(), ResourceErrorType.INVALID_PLUGIN_CONFIGURATION);
        assert (errors.size() == 1);
        error = (ResourceError)errors.get(0);
        assert (error.getId() > 0);
        assert (error.getSummary().equals("another summary"));
        assert (error.getDetail().equals("another detail"));
        assert (error.getErrorType() == ResourceErrorType.INVALID_PLUGIN_CONFIGURATION);
        assert (error.getTimeOccurred() == 567890L);
        resourceManager.deleteResourceError(this.getOverlord(), error.getId());
        errors = resourceManager.findResourceErrors(this.getOverlord(), this.newResource.getId(), ResourceErrorType.INVALID_PLUGIN_CONFIGURATION);
        assert (errors.size() == 0);
    }

    @Override
    protected void afterMethod() throws Exception {
        if (this.newGroup != null) {
            this.groupManager.deleteResourceGroup(this.getOverlord(), this.newGroup.getId());
        }
        this.deleteNewResourceAgentResourceType(this.newResource);
        super.afterMethod();
    }

    public void testResourceLineage() throws Exception {
        int leafResourceId = this.givenASampleResourceHierarchy();
        List resourceLineage = resourceManager.getResourceLineage(leafResourceId);
        this.assertEquals(resourceLineage.size(), 4);
        StringBuilder stringBuilder = new StringBuilder();
        for (Resource resource : resourceLineage) {
            stringBuilder.append(resource.getName());
            if (resourceLineage.indexOf(resource) == resourceLineage.size() - 1) continue;
            stringBuilder.append("::");
        }
        System.err.println(stringBuilder.toString());
        for (int i = resourceLineage.size() - 1; i >= 0; --i) {
            this.deleteNewResourceAgentResourceType((Resource)resourceLineage.get(i));
        }
    }

    public void bz886850Test() {
        block17: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                try {
                                    resourceManager.getResourceById(this.getOverlord(), 2637426);
                                    this.fail("Should have thrown a ResourceNotFoundException");
                                }
                                catch (Throwable t) {
                                    if (t instanceof ResourceNotFoundException) break block12;
                                    this.fail("Should have thrown a ResourceNotFoundException but got: " + t);
                                }
                            }
                            try {
                                LookupUtil.getGroupDefinitionManager().getById(3456347);
                                this.fail("Should have thrown a GroupDefinitionNotFoundException");
                            }
                            catch (Throwable t) {
                                if (t instanceof GroupDefinitionNotFoundException) break block13;
                                this.fail("Should have thrown a GroupDefinitionNotFoundException but got: " + t);
                            }
                        }
                        try {
                            LookupUtil.getOperationManager().getOperationDefinition(this.getOverlord(), 3456347);
                            this.fail("Should have thrown a OperationDefinitionNotFoundException");
                        }
                        catch (Throwable t) {
                            if (t instanceof OperationDefinitionNotFoundException) break block14;
                            this.fail("Should have thrown a OperationDefinitionNotFoundException but got: " + t);
                        }
                    }
                    try {
                        LookupUtil.getResourceTypeManager().getResourceTypeById(this.getOverlord(), 3456347);
                        this.fail("Should have thrown a ResourceTypeNotFoundException");
                    }
                    catch (Throwable t) {
                        if (t instanceof ResourceTypeNotFoundException) break block15;
                        this.fail("Should have thrown a ResourceTypeNotFoundException but got: " + t);
                    }
                }
                try {
                    LookupUtil.getResourceGroupManager().getResourceGroup(this.getOverlord(), 3456347);
                    this.fail("Should have thrown a ResourceGroupNotFoundException");
                }
                catch (Throwable t) {
                    if (t instanceof ResourceGroupNotFoundException) break block16;
                    this.fail("Should have thrown a ResourceGroupNotFoundException but got: " + t);
                }
            }
            try {
                SessionManager.getInstance().getSubject(3456347);
                this.fail("Should have thrown a SessionNotFoundException");
            }
            catch (Throwable t) {
                if (t instanceof SessionNotFoundException) break block17;
                this.fail("Should have thrown a SessionNotFoundException but got: " + t);
            }
        }
    }

    public void testAddResorceToGroup() {
        ResourceGroupCriteria criteria = new ResourceGroupCriteria();
        criteria.addFilterId(Integer.valueOf(this.newGroup.getId()));
        criteria.fetchExplicitResources(true);
        PageList persistedGroups = this.groupManager.findResourceGroupsByCriteria(this.getOverlord(), criteria);
        this.assertEquals("There should be just one group with id " + this.newGroup.getId(), 1, persistedGroups.size());
        this.assertEquals("Persisted group should be the same as the group created in before method.", this.newGroup, persistedGroups.get(0));
        this.assertEquals("There should be no explicit members in the newly created group.", 0, ((ResourceGroup)persistedGroups.get(0)).getExplicitResources().size());
        this.groupManager.addResourcesToGroup(this.getOverlord(), this.newGroup.getId(), new int[]{this.newResource.getId()});
        persistedGroups = this.groupManager.findResourceGroupsByCriteria(this.getOverlord(), criteria);
        this.assertEquals("There should be one member in the newly created group.", 1, ((ResourceGroup)persistedGroups.get(0)).getExplicitResources().size());
    }

    public void testResourceUninventorization() {
        ResourceGroupCriteria criteria = new ResourceGroupCriteria();
        criteria.addFilterId(Integer.valueOf(this.newGroup.getId()));
        criteria.fetchExplicitResources(true);
        PageList persistedGroups = this.groupManager.findResourceGroupsByCriteria(this.getOverlord(), criteria);
        this.assertEquals("There should be just one group with id " + this.newGroup.getId(), 1, persistedGroups.size());
        this.assertEquals("An empty group is considered as MIXED.", GroupCategory.MIXED, ((ResourceGroup)persistedGroups.get(0)).getGroupCategory());
        this.groupManager.addResourcesToGroup(this.getOverlord(), ((ResourceGroup)persistedGroups.get(0)).getId(), new int[]{this.newResource.getId()});
        persistedGroups = this.groupManager.findResourceGroupsByCriteria(this.getOverlord(), criteria);
        this.assertEquals("A group with just one explicit member is considered as COMPATIBLE.", GroupCategory.COMPATIBLE, ((ResourceGroup)persistedGroups.get(0)).getGroupCategory());
        resourceManager.uninventoryResource(this.getOverlord(), this.newResource.getId());
        persistedGroups = this.groupManager.findResourceGroupsByCriteria(this.getOverlord(), criteria);
        this.assertEquals("An empty group is considered as MIXED.", GroupCategory.MIXED, ((ResourceGroup)persistedGroups.get(0)).getGroupCategory());
    }

    public void testResourceRemovalFromGroup() {
        ResourceGroup persistedGroup = this.groupManager.getResourceGroup(this.getOverlord(), this.newGroup.getId());
        this.assertEquals("An empty group is considered as MIXED.", GroupCategory.MIXED, persistedGroup.getGroupCategory());
        this.groupManager.addResourcesToGroup(this.getOverlord(), persistedGroup.getId(), new int[]{this.newResource.getId()});
        persistedGroup = this.groupManager.getResourceGroup(this.getOverlord(), this.newGroup.getId());
        this.assertEquals("A group with just one explicit member is considered as COMPATIBLE.", GroupCategory.COMPATIBLE, persistedGroup.getGroupCategory());
        this.groupManager.removeResourcesFromGroup(this.getOverlord(), persistedGroup.getId(), new int[]{this.newResource.getId()});
        persistedGroup = this.groupManager.getResourceGroup(this.getOverlord(), this.newGroup.getId());
        this.assertEquals("An empty group is considered as MIXED.", GroupCategory.MIXED, persistedGroup.getGroupCategory());
    }

    public void testLiveAvailability() throws Exception {
        this.agentServiceContainer.discoveryService = (DiscoveryAgentService)Mockito.mock(DiscoveryAgentService.class);
        Mockito.when((Object)this.agentServiceContainer.discoveryService.getCurrentAvailability((Resource)Mockito.any(Resource.class), Mockito.anyBoolean())).then((Answer)new Answer<AvailabilityReport>(){
            int count = 0;

            public AvailabilityReport answer(InvocationOnMock invocation) throws Throwable {
                Resource res = (Resource)invocation.getArguments()[0];
                AvailabilityType avail = this.count++ == 0 ? AvailabilityType.DOWN : AvailabilityType.UP;
                AvailabilityReport ret = new AvailabilityReport("-dummy agent-");
                ret.addAvailability(new AvailabilityReport.Datum(res.getId(), avail, System.currentTimeMillis()));
                return ret;
            }
        });
        AlertDefinition alertDef = new AlertDefinition();
        AlertCondition cond = new AlertCondition(alertDef, AlertConditionCategory.AVAILABILITY);
        cond.setName(AlertConditionOperator.AVAIL_GOES_UP.name());
        alertDef.setName("liveAvailabilityTestAlert");
        alertDef.setResource(this.newResource);
        alertDef.setPriority(AlertPriority.MEDIUM);
        alertDef.setRecoveryId(Integer.valueOf(0));
        alertDef.setAlertDampening(new AlertDampening(AlertDampening.Category.NONE));
        alertDef.setConditions(Collections.singleton(cond));
        alertDef.setEnabled(true);
        alertDef.setConditionExpression(BooleanExpression.ALL);
        AlertDefinitionManagerLocal alertDefinitionManager = LookupUtil.getAlertDefinitionManager();
        alertDefinitionManager.createAlertDefinitionInNewTransaction(this.getOverlord(), alertDef, Integer.valueOf(this.newResource.getId()), true);
        LookupUtil.getAlertConditionCacheManager().reloadAllCaches();
        ResourceCriteria crit = new ResourceCriteria();
        crit.addFilterId(Integer.valueOf(this.newResource.getId()));
        crit.fetchCurrentAvailability(true);
        Resource fromDb = (Resource)resourceManager.findResourcesByCriteria(this.getOverlord(), crit).get(0);
        this.assertEquals(AvailabilityType.UNKNOWN, fromDb.getCurrentAvailability().getAvailabilityType());
        resourceManager.getLiveResourceAvailability(this.getOverlord(), this.newResource.getId());
        fromDb = resourceManager.getResource(this.getOverlord(), this.newResource.getId());
        this.assertEquals(AvailabilityType.DOWN, fromDb.getCurrentAvailability().getAvailabilityType());
        resourceManager.getLiveResourceAvailability(this.getOverlord(), this.newResource.getId());
        Thread.sleep(3000L);
        fromDb = resourceManager.getResource(this.getOverlord(), this.newResource.getId());
        this.assertEquals(AvailabilityType.UP, fromDb.getCurrentAvailability().getAvailabilityType());
        Thread.sleep(3000L);
        AlertCriteria aCrit = new AlertCriteria();
        aCrit.addFilterResourceIds(new Integer[]{this.newResource.getId()});
        PageList alerts = LookupUtil.getAlertManager().findAlertsByCriteria(this.getOverlord(), aCrit);
        this.assertEquals("Unexpected number of alerts on the resource.", 1, alerts.size());
    }

    private int givenASampleResourceHierarchy() throws NotSupportedException, SystemException {
        this.getTransactionManager().begin();
        int leafResourceId = 0;
        try {
            ResourceType platformType = this.createResourceType("platform" + System.currentTimeMillis(), "test", null, ResourceCategory.PLATFORM);
            ResourceType appserverType = this.createResourceType("jboss AS 5" + System.currentTimeMillis(), "jbossas5", platformType, ResourceCategory.SERVER);
            ResourceType jvmType = this.createResourceType("JVM" + System.currentTimeMillis(), "jbossas5", appserverType, ResourceCategory.SERVICE);
            ResourceType memType = this.createResourceType("Memory Subsystem" + System.currentTimeMillis(), "jbossas5", jvmType, ResourceCategory.SERVICE);
            Agent agent = new Agent("agent" + System.currentTimeMillis(), "host" + System.currentTimeMillis(), 1, "", "token" + System.currentTimeMillis());
            this.em.persist((Object)agent);
            this.em.flush();
            Resource platform = this.createResource(platformType, agent, "platformKey" + System.currentTimeMillis(), "host.dev.corp", null);
            Resource appserver = this.createResource(appserverType, agent, "JEAP" + System.currentTimeMillis(), "JBOSS EAP 5.1.1", platform);
            Resource jvm = this.createResource(jvmType, agent, "jvm" + System.currentTimeMillis(), "JBoss AS JVM", appserver);
            Resource memSubystem = this.createResource(memType, agent, "mem" + System.currentTimeMillis(), "Memory Subsystem", jvm);
            leafResourceId = memSubystem.getId();
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            try {
                System.out.println("CANNOT Prepare TEST: Cause: " + e);
                this.getTransactionManager().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return leafResourceId;
    }

    private Resource createResource(ResourceType platformType, Agent agent, String resourceKey, String resourceName, Resource parent) {
        Resource resource = new Resource(resourceKey, resourceName, platformType);
        resource.setUuid(UUID.randomUUID().toString());
        resource.setAgent(agent);
        resource.setParentResource(parent);
        this.em.persist((Object)resource);
        return resource;
    }

    private ResourceType createResourceType(String name, String pluginName, ResourceType parentResourceType, ResourceCategory resourceCategory) {
        ResourceType platformType;
        ResourceType resourceType = platformType = new ResourceType(name, pluginName, resourceCategory, parentResourceType);
        this.em.persist((Object)resourceType);
        return resourceType;
    }

    private Resource createNewResourceWithNewType() throws Exception {
        Resource resource;
        this.getTransactionManager().begin();
        try {
            ResourceType resourceType = new ResourceType("plat" + System.currentTimeMillis(), "test", ResourceCategory.PLATFORM, null);
            this.em.persist((Object)resourceType);
            resource = new Resource("reskey" + System.currentTimeMillis(), "resname", resourceType);
            this.setUpAgent(resource);
            resource.setUuid("" + new Random().nextInt());
            resource.setInventoryStatus(InventoryStatus.COMMITTED);
            this.em.persist((Object)resource);
            this.createServerIdentity();
        }
        catch (Exception e) {
            System.out.println("CANNOT PREPARE TEST: " + e);
            this.getTransactionManager().rollback();
            throw e;
        }
        this.getTransactionManager().commit();
        return resource;
    }

    private ResourceGroup createNewGroup() {
        ResourceGroup group = new ResourceGroup("testGroup");
        this.groupManager.createResourceGroup(this.getOverlord(), group);
        return group;
    }

    private void deleteNewResourceAgentResourceType(Resource resource) throws Exception {
        if (resource != null) {
            this.getTransactionManager().begin();
            try {
                Resource res = (Resource)this.em.find(Resource.class, (Object)resource.getId());
                System.out.println("Removing " + res + "...");
                List deletedIds = resourceManager.uninventoryResource(this.getOverlord(), res.getId());
                for (Integer deletedResourceId : deletedIds) {
                    resourceManager.uninventoryResourceAsyncWork(this.getOverlord(), deletedResourceId.intValue());
                }
                this.em.flush();
                ResourceType type = (ResourceType)this.em.find(ResourceType.class, (Object)resource.getResourceType().getId());
                System.out.println("Removing " + type + "...");
                this.em.remove((Object)type);
                this.em.flush();
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                try {
                    System.out.println("CANNOT CLEAN UP TEST: Cause: " + e);
                    this.getTransactionManager().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

