/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.criteria.BaseCriteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.ResourceComposite;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.resource.group.composite.ResourceGroupComposite;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.discovery.DiscoveryBossLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.test.ResourceWithStatus;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.CriteriaQuery;
import org.rhq.enterprise.server.util.CriteriaQueryExecutor;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.Test;

public class ResourceStorageTest
extends AbstractEJB3Test {
    private Log log = LogFactory.getLog(ResourceStorageTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFindResourceComposite() throws Exception {
        this.getTransactionManager().begin();
        try {
            ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
            SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
            PageControl pc = new PageControl(1, 5, new OrderingField[]{new OrderingField("res.name", PageOrdering.ASC)});
            Subject subject = subjectManager.loginUnauthenticated("ghinkle");
            subject = this.createSession(subject);
            ResourceType t = (ResourceType)this.em.getReference(ResourceType.class, (Object)new Integer(501064));
            String typeNameFilter = t == null ? null : t.getName();
            PageList resources = resourceManager.findResourceComposites(subject, ResourceCategory.SERVER, typeNameFilter, null, null, "g", false, pc);
            System.out.println("Found resource composites: " + resources.size());
            for (ResourceComposite resourceComposite : resources) {
                System.out.println("\t" + resourceComposite);
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBindOrderBy() throws Exception {
        this.getTransactionManager().begin();
        try {
            this.log.error((Object)"QUERY TEST!!");
            Query q = this.em.createQuery("SELECT r FROM Resource r ORDER BY :col");
            q.setParameter("col", (Object)"r.name desc");
            List resources = q.getResultList();
            System.out.println("Sorted resources: ");
            for (Resource r : resources) {
                System.out.println("\t" + r);
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.ejb3"})
    public void testMixedGroupCompositeQuery() throws Exception {
        this.getTransactionManager().begin();
        try {
            ResourceGroupManagerLocal groupManager = LookupUtil.getResourceGroupManager();
            SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
            PageControl pc = new PageControl(1, 5, new OrderingField[]{new OrderingField("rg.name", PageOrdering.ASC)});
            Subject subject = subjectManager.getOverlord();
            subject = this.createSession(subject);
            PageList groups = groupManager.findResourceGroupComposites(subject, GroupCategory.MIXED, null, null, null, null, null, null, pc);
            System.out.println("Found mixed groups: " + groups.size());
            for (ResourceGroupComposite group : groups) {
                System.out.println("\t" + group);
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.ejb3"})
    public void testCompatibleGroupCompositeQuery() throws Exception {
        this.getTransactionManager().begin();
        try {
            ResourceGroupManagerLocal groupManager = LookupUtil.getResourceGroupManager();
            SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
            PageControl pc = new PageControl(0, 5, new OrderingField[]{new OrderingField("rg.name", PageOrdering.ASC)});
            PageList groups = groupManager.findResourceGroupComposites(subjectManager.getOverlord(), GroupCategory.COMPATIBLE, null, null, null, null, null, null, pc);
            System.out.println("Found compatible groups: " + groups.getTotalSize());
            for (ResourceGroupComposite group : groups) {
                System.out.println("\t" + group);
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.ejb3"})
    public void testConstructorQuery() throws Exception {
        this.getTransactionManager().begin();
        try {
            Query q = this.em.createQuery("SELECT new org.rhq.enterprise.server.resource.test.ResourceWithStatus(a.availabilityType,r) FROM Resource r, Availability a WHERE r.id = a.resource.id AND  a.startTime = (SELECT MAX(aa.startTime) FROM Availability aa WHERE aa.resource.id = r.id)");
            List resourceWithStatuses = q.getResultList();
            for (ResourceWithStatus r : resourceWithStatuses) {
                System.out.println(r.getAvailabilityType() + " - " + r.getResource().getName());
                System.out.println("\tchildren: " + r.getResource().getChildResources().size());
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.ejb3"})
    public void getDeadResources() throws Exception {
        this.getTransactionManager().begin();
        try {
            Query q = this.em.createQuery("SELECT new org.rhq.enterprise.server.resource.test.ResourceWithStatus(a.availabilityType,r) FROM Resource r, Availability a WHERE r.id = a.resource.id AND a.availabilityType = 1 AND  a.startTime = (SELECT MAX(aa.startTime) FROM Availability aa WHERE aa.resource.id = r.id)");
            List resourceWithStatuses = q.getResultList();
            System.out.println("Resource currently down");
            for (ResourceWithStatus r : resourceWithStatuses) {
                System.out.println(r.getAvailabilityType() + " - " + r.getResource().getName());
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.ejb3"})
    public void discoveryQueueTest() throws Exception {
        this.getTransactionManager().begin();
        try {
            DiscoveryBossLocal discoveryBoss = LookupUtil.getDiscoveryBoss();
            SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
            Subject rhqadmin = subjectManager.loginUnauthenticated("rhqadmin");
            rhqadmin = this.createSession(rhqadmin);
            Map queue = discoveryBoss.getQueuedPlatformsAndServers(rhqadmin, PageControl.getUnlimitedInstance());
            for (Resource root : queue.keySet()) {
                System.out.println("Queue root resource: " + root);
            }
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    @Test(groups={"integration.ejb3"})
    public void resourceTest() throws Exception {
        ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        AuthorizationManagerLocal authorizationManager = LookupUtil.getAuthorizationManager();
        Subject rhqadmin = subjectManager.loginUnauthenticated("rhqadmin");
        System.out.println(rhqadmin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.ejb3"})
    public void testParsingCriteriaQueryResults() throws Exception {
        this.getTransactionManager().begin();
        EntityManager entityMgr = this.getEntityManager();
        final ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
        HashMap<String, String> resourceNames = new HashMap<String, String>();
        int resourceCount = 700;
        try {
            final Subject subject = SessionTestHelper.createNewSubject(entityMgr, "testSubject");
            Role roleWithSubject = SessionTestHelper.createNewRoleForSubject(entityMgr, subject, "role with subject");
            roleWithSubject.addPermission(Permission.VIEW_RESOURCE);
            ResourceGroup group = SessionTestHelper.createNewCompatibleGroupForRole(entityMgr, roleWithSubject, "accessible group");
            String tuid = "" + new Random().nextInt();
            String prefix = "largeResultSet-" + tuid + "-";
            System.out.println("-------- Creating " + resourceCount + " resource(s). This may take a while ....");
            long start = System.currentTimeMillis();
            for (int i = 0; i < resourceCount; ++i) {
                String name = prefix + i;
                Resource r = SessionTestHelper.createNewResourceForGroup(entityMgr, group, name);
                resourceNames.put(String.valueOf(r.getId()), name);
            }
            entityMgr.flush();
            System.out.println("----------- Created " + resourceCount + " resource(s) in " + (System.currentTimeMillis() - start) + " ms.");
            assert (resourceNames.size() == resourceCount);
            ResourceCriteria criteria = new ResourceCriteria();
            criteria.addFilterName(prefix);
            criteria.addSortName(PageOrdering.DESC);
            criteria.setPaging(0, 47);
            CriteriaQueryExecutor<Resource, ResourceCriteria> queryExecutor = new CriteriaQueryExecutor<Resource, ResourceCriteria>(){

                public PageList<Resource> execute(ResourceCriteria criteria) {
                    return resourceManager.findResourcesByCriteria(subject, criteria);
                }
            };
            CriteriaQuery resources = new CriteriaQuery((BaseCriteria)criteria, (CriteriaQueryExecutor)queryExecutor);
            start = System.currentTimeMillis();
            String prevName = null;
            ArrayList alreadySeen = new ArrayList();
            int actualCount = 0;
            for (Resource r : resources) {
                assert (null == prevName || r.getName().compareTo(prevName) < 0) : "Results should be sorted by name DESC, something is out of order";
                prevName = r.getName();
                ++actualCount;
                resourceNames.remove(String.valueOf(r.getId()));
            }
            System.out.println("----------- Parsed " + actualCount + " resource(s) in " + (System.currentTimeMillis() - start) + " ms.");
            assert (resourceNames.size() == 0) : "Expected resourceNames to be empty. Still " + resourceNames.size() + " name(s).";
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.ejb3"})
    public void testParsingCriteriaQueryResults_2() throws Exception {
        this.getTransactionManager().begin();
        EntityManager entityMgr = this.getEntityManager();
        final ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
        HashMap<String, String> resourceNames = new HashMap<String, String>();
        int resourceCount = 344;
        try {
            final Subject subject = SessionTestHelper.createNewSubject(entityMgr, "testSubject");
            Role roleWithSubject = SessionTestHelper.createNewRoleForSubject(entityMgr, subject, "role with subject");
            roleWithSubject.addPermission(Permission.VIEW_RESOURCE);
            ResourceGroup group = SessionTestHelper.createNewCompatibleGroupForRole(entityMgr, roleWithSubject, "accessible group");
            String tuid = "" + new Random().nextInt();
            String prefix = "largeResultSet-" + tuid + "-";
            System.out.println("-------- Creating " + resourceCount + " resource(s). This may take a while ....");
            long start = System.currentTimeMillis();
            for (int i = 0; i < resourceCount; ++i) {
                String name = prefix + i;
                Resource r = SessionTestHelper.createNewResourceForGroup(entityMgr, group, name);
                resourceNames.put(String.valueOf(r.getId()), name);
            }
            entityMgr.flush();
            System.out.println("----------- Created " + resourceCount + " resource(s) in " + (System.currentTimeMillis() - start) + " ms.");
            assert (resourceNames.size() == resourceCount);
            ResourceCriteria criteria = new ResourceCriteria();
            criteria.addFilterName(prefix);
            criteria.setPaging(0, 25);
            CriteriaQueryExecutor<Resource, ResourceCriteria> queryExecutor = new CriteriaQueryExecutor<Resource, ResourceCriteria>(){

                public PageList<Resource> execute(ResourceCriteria criteria) {
                    return resourceManager.findResourcesByCriteria(subject, criteria);
                }
            };
            CriteriaQuery resources = new CriteriaQuery((BaseCriteria)criteria, (CriteriaQueryExecutor)queryExecutor);
            start = System.currentTimeMillis();
            int prevId = 0;
            ArrayList alreadySeen = new ArrayList();
            int actualCount = 0;
            for (Resource r : resources) {
                assert (r.getId() > prevId) : "Results should be sorted by ID ASC, something is out of order";
                prevId = r.getId();
                ++actualCount;
                resourceNames.remove(String.valueOf(r.getId()));
            }
            System.out.println("----------- Parsed " + actualCount + " resource(s) in " + (System.currentTimeMillis() - start) + " ms.");
            assert (resourceNames.size() == 0) : "Expected resourceNames to be empty. Still " + resourceNames.size() + " name(s).";
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration.ejb3"})
    public void testParsingCriteriaQueryResults_3() throws Exception {
        this.getTransactionManager().begin();
        EntityManager entityMgr = this.getEntityManager();
        final ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
        HashMap<String, String> resourceNames = new HashMap<String, String>();
        int resourceCount = 423;
        try {
            final Subject subject = SessionTestHelper.createNewSubject(entityMgr, "testSubject");
            Role roleWithSubject = SessionTestHelper.createNewRoleForSubject(entityMgr, subject, "role with subject");
            roleWithSubject.addPermission(Permission.VIEW_RESOURCE);
            ResourceGroup group = SessionTestHelper.createNewCompatibleGroupForRole(entityMgr, roleWithSubject, "accessible group");
            String tuid = "" + new Random().nextInt();
            String prefix = "largeResultSet-" + tuid + "-";
            System.out.println("-------- Creating " + resourceCount + " resource(s). This may take a while ....");
            long start = System.currentTimeMillis();
            for (int i = 0; i < resourceCount; ++i) {
                String name = prefix + i;
                Resource r = SessionTestHelper.createNewResourceForGroup(entityMgr, group, name);
                resourceNames.put(String.valueOf(r.getId()), name);
            }
            entityMgr.flush();
            System.out.println("----------- Created " + resourceCount + " resource(s) in " + (System.currentTimeMillis() - start) + " ms.");
            assert (resourceNames.size() == resourceCount);
            ResourceCriteria criteria = new ResourceCriteria();
            criteria.addFilterName(prefix);
            PageControl pc = new PageControl(0, 73);
            criteria.setPageControl(pc);
            assert (pc.getOrderingFields().isEmpty()) : "Should not have had any sorting defined";
            CriteriaQueryExecutor<Resource, ResourceCriteria> queryExecutor = new CriteriaQueryExecutor<Resource, ResourceCriteria>(){

                public PageList<Resource> execute(ResourceCriteria criteria) {
                    return resourceManager.findResourcesByCriteria(subject, criteria);
                }
            };
            CriteriaQuery resources = new CriteriaQuery((BaseCriteria)criteria, (CriteriaQueryExecutor)queryExecutor);
            start = System.currentTimeMillis();
            int prevId = 0;
            ArrayList alreadySeen = new ArrayList();
            int actualCount = 0;
            for (Resource r : resources) {
                assert (r.getId() > prevId) : "Results should be sorted by ID ASC, something is out of order";
                prevId = r.getId();
                ++actualCount;
                resourceNames.remove(String.valueOf(r.getId()));
            }
            System.out.println("----------- Parsed " + actualCount + " resource(s) in " + (System.currentTimeMillis() - start) + " ms.");
            assert (resourceNames.size() == 0) : "Expected resourceNames to be empty. Still " + resourceNames.size() + " name(s).";
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }
}

