/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.test;

import java.util.HashMap;
import java.util.Random;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.resource.ResourceNotFoundException;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.metadata.test.UpdatePluginMetadataTestBase;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

@Test
public class UninventoryAndDeleteAgentTest
extends UpdatePluginMetadataTestBase {
    private AgentManagerLocal agentManager;
    private ResourceGroupManagerLocal groupManager;
    private ResourceGroup newGroup;
    private ResourceType platformType;

    @Override
    protected void beforeMethod() throws Exception {
        super.beforeMethod();
        this.platformType = this.createPlatformResourceType();
        this.groupManager = LookupUtil.getResourceGroupManager();
        this.newGroup = this.createNewGroup();
        this.agentManager = LookupUtil.getAgentManager();
    }

    @Override
    protected void afterMethod() throws Exception {
        if (this.newGroup != null) {
            this.groupManager.deleteResourceGroup(this.getOverlord(), this.newGroup.getId());
        }
        this.cleanupResourceType(this.platformType.getName());
        super.afterMethod();
    }

    public void testDeletingAgents() throws Exception {
        Agent agentRegistered = this.createOnlyAgent(1);
        HashMap<Agent, Resource> agentPlatNew = this.createAgentWithResource(2, InventoryStatus.NEW);
        HashMap<Agent, Resource> agentPlatCommitted = this.createAgentWithResource(3, InventoryStatus.COMMITTED);
        Agent agentNew = agentPlatNew.keySet().iterator().next();
        Agent agentCommitted = agentPlatCommitted.keySet().iterator().next();
        Resource committedResource = agentPlatCommitted.values().iterator().next();
        this.groupManager.addResourcesToGroup(this.getOverlord(), this.newGroup.getId(), new int[]{committedResource.getId()});
        resourceManager.uninventoryAllResourcesByAgent(this.getOverlord(), agentRegistered);
        resourceManager.uninventoryAllResourcesByAgent(this.getOverlord(), agentNew);
        resourceManager.uninventoryAllResourcesByAgent(this.getOverlord(), agentCommitted);
        assert (null == this.agentManager.getAgentByID(agentRegistered.getId()));
        assert (null == this.agentManager.getAgentByID(agentNew.getId()));
        assert (null == this.agentManager.getAgentByID(agentCommitted.getId()));
        try {
            Resource doomed = resourceManager.getResourceById(this.getOverlord(), committedResource.getId());
            assert (doomed.getAgent() == null) : "Resource should not have an agent attached, it should have been uninventoried";
            assert (doomed.getInventoryStatus() == InventoryStatus.UNINVENTORIED) : "Should have been uninventoried";
        }
        catch (ResourceNotFoundException rnfe) {
            // empty catch block
        }
    }

    private ResourceType createPlatformResourceType() throws Exception {
        ResourceType resourceType;
        this.getTransactionManager().begin();
        try {
            resourceType = new ResourceType("DeleteAgentTest-PlatType" + System.currentTimeMillis(), "UpdatePluginMetadataTestBasePlugin", ResourceCategory.PLATFORM, null);
            this.em.persist((Object)resourceType);
        }
        catch (Exception e) {
            System.out.println("CANNOT PREPARE TEST: " + e);
            this.getTransactionManager().rollback();
            throw e;
        }
        this.getTransactionManager().commit();
        return resourceType;
    }

    private Agent createOnlyAgent(int index) throws Exception {
        Agent agent;
        this.getTransactionManager().begin();
        try {
            agent = new Agent("DeleteAgentTest-Agent" + index, "testaddr", 16163 + index, "", "testtoken" + index);
            this.em.persist((Object)agent);
            this.em.flush();
        }
        catch (Exception e) {
            System.out.println("CANNOT PREPARE TEST: " + e);
            this.getTransactionManager().rollback();
            throw e;
        }
        this.getTransactionManager().commit();
        return agent;
    }

    private HashMap<Agent, Resource> createAgentWithResource(int index, InventoryStatus invStatus) throws Exception {
        Resource resource;
        HashMap<Agent, Resource> ret = new HashMap<Agent, Resource>(1);
        Agent agent = this.createOnlyAgent(index);
        this.getTransactionManager().begin();
        try {
            resource = new Resource("DeleteAgentTest-Res" + index, "DeleteAgentTest-Res" + index, this.platformType);
            resource.setUuid("" + new Random().nextInt());
            resource.setAgent(agent);
            resource.setInventoryStatus(invStatus);
            this.em.persist((Object)resource);
        }
        catch (Exception e) {
            System.out.println("CANNOT PREPARE TEST: " + e);
            this.getTransactionManager().rollback();
            throw e;
        }
        this.getTransactionManager().commit();
        ret.put(agent, resource);
        return ret;
    }

    private ResourceGroup createNewGroup() {
        ResourceGroup group = new ResourceGroup("DeleteAgentTest-Group");
        this.groupManager.createResourceGroup(this.getOverlord(), group);
        return group;
    }
}

