/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertConditionLog;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.alert.BooleanExpression;
import org.rhq.core.domain.alert.notification.AlertNotificationLog;
import org.rhq.core.domain.alert.notification.ResultState;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventDefinition;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.event.EventSource;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementCategory;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.domain.measurement.calltime.CallTimeDataComposite;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.event.EventManagerLocal;
import org.rhq.enterprise.server.measurement.CallTimeDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.scheduler.jobs.DataPurgeJob;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.test.TestServerPluginService;
import org.rhq.enterprise.server.util.LookupUtil;
import org.testng.annotations.Test;

@Test
public class DataPurgeJobTest
extends AbstractEJB3Test {
    private Resource newResource;
    private int agentId;
    private int resourceTypeId;
    private TestServerPluginService testServerPluginService;

    @Override
    protected void beforeMethod() throws Exception {
        try {
            this.testServerPluginService = new TestServerPluginService(this.getTempDir());
            this.prepareCustomServerPluginService(this.testServerPluginService);
            this.testServerPluginService.startMasterPluginContainer();
            this.prepareScheduler();
            TestServerCommunicationsService agentContainer = this.prepareForTestAgents();
            this.newResource = this.createNewResource();
        }
        catch (Throwable t) {
            System.err.println("Cannot prepare test: " + t);
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    @Override
    protected void afterMethod() throws Exception {
        try {
            this.deleteNewResource(this.newResource);
            this.unprepareForTestAgents();
            this.unprepareScheduler();
            this.unprepareServerPluginService();
        }
        catch (Throwable t) {
            System.err.println("Cannot unprepare test: " + t);
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    public void testPurge() throws Throwable {
        this.addDataToBePurged();
        this.triggerDataPurgeJobNow();
        this.makeSureDataIsPurged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPurgeWhenDeleting() throws Throwable {
        this.addDataToBePurged();
        try {
            Subject overlord = LookupUtil.getSubjectManager().getOverlord();
            ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
            List deletedIds = resourceManager.uninventoryResource(overlord, this.newResource.getId());
            resourceManager.uninventoryResourceAsyncWork(overlord, this.newResource.getId());
            assert (deletedIds.size() == 1) : "didn't delete resource: " + deletedIds;
            assert (((Integer)deletedIds.get(0)).intValue() == this.newResource.getId()) : "what was deleted? : " + deletedIds;
        }
        finally {
            this.newResource = null;
        }
        this.getTransactionManager().begin();
        try {
            Set mDefs;
            ResourceType rt = (ResourceType)this.em.find(ResourceType.class, (Object)this.resourceTypeId);
            Set evDs = rt.getEventDefinitions();
            if (evDs != null) {
                Iterator evdIter = evDs.iterator();
                while (evdIter.hasNext()) {
                    EventDefinition evd = (EventDefinition)evdIter.next();
                    this.em.remove((Object)evd);
                    evdIter.remove();
                }
            }
            if ((mDefs = rt.getMetricDefinitions()) != null) {
                Iterator mdIter = mDefs.iterator();
                while (mdIter.hasNext()) {
                    MeasurementDefinition def = (MeasurementDefinition)mdIter.next();
                    this.em.remove((Object)def);
                    mdIter.remove();
                }
            }
            this.em.remove((Object)rt);
            this.getTransactionManager().commit();
        }
        catch (Exception e) {
            this.getTransactionManager().rollback();
            throw e;
        }
    }

    private void addDataToBePurged() throws NotSupportedException, SystemException, Throwable {
        this.getTransactionManager().begin();
        try {
            try {
                long timestamp;
                AlertDefinition ad = (AlertDefinition)this.newResource.getAlertDefinitions().iterator().next();
                for (timestamp = 0L; timestamp < 200L; ++timestamp) {
                    Alert newAlert = this.createNewAlert(ad, timestamp);
                    assert (newAlert.getCtime() == timestamp) : "bad alert persisted:" + newAlert;
                    assert (newAlert.getId() > 0) : "alert not persisted:" + newAlert;
                    if (timestamp % 50L != 0L) continue;
                    this.em.flush();
                    this.em.clear();
                }
                this.em.flush();
                this.em.clear();
                for (timestamp = 0L; timestamp < 2000L; timestamp += 2L) {
                    Availability newAvail = this.createNewAvailability(this.newResource, timestamp, timestamp + 1L);
                    assert (newAvail.getStartTime() == timestamp) : "bad avail persisted:" + newAvail;
                    assert (newAvail.getEndTime() == timestamp + 1L) : "bad avail persisted:" + newAvail;
                    assert (newAvail.getId() > 0) : "avail not persisted:" + newAvail;
                    if (timestamp % 50L != 0L) continue;
                    this.em.flush();
                    this.em.clear();
                }
                this.em.flush();
                this.em.clear();
                this.createNewEvents(this.newResource, 0L, 1000);
                this.createNewCalltimeData(this.newResource, 0L, 1000);
                this.createNewTraitData(this.newResource, 0L, 100);
                this.getTransactionManager().commit();
            }
            catch (Throwable t) {
                this.getTransactionManager().rollback();
                throw t;
            }
        }
        catch (Throwable t) {
            System.err.println("!!!!! DataPurgeJobTest.testPurge failed: " + ThrowableUtil.getAllMessages((Throwable)t));
            t.printStackTrace();
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeSureDataIsPurged() throws NotSupportedException, SystemException {
        this.getTransactionManager().begin();
        try {
            Subject overlord = LookupUtil.getSubjectManager().getOverlord();
            Resource res = (Resource)this.em.find(Resource.class, (Object)this.newResource.getId());
            Set alertDefinitions = res.getAlertDefinitions();
            assert (alertDefinitions.size() == 1) : "why are we missing our alert definitions?: " + alertDefinitions;
            AlertDefinition ad = (AlertDefinition)alertDefinitions.iterator().next();
            assert (ad.getAlerts().size() == 0) : "didn't purge alerts";
            Set clogs = ((AlertCondition)ad.getConditions().iterator().next()).getConditionLogs();
            assert (clogs.size() == 0) : "didn't purge condition logs: " + clogs.size();
            List avails = res.getAvailability();
            assert (avails.size() == 1) : "didn't purge availabilities";
            EventSource es = (EventSource)res.getEventSources().iterator().next();
            assert (es.getEvents().size() == 0) : "didn't purge all events";
            int calltimeScheduleId = 0;
            for (MeasurementSchedule sched : res.getSchedules()) {
                if (sched.getDefinition().getDataType() != DataType.CALLTIME) continue;
                calltimeScheduleId = sched.getId();
                break;
            }
            assert (calltimeScheduleId > 0) : "why don't we have a calltime schedule?";
            PageList calltimeData = LookupUtil.getCallTimeDataManager().findCallTimeDataForResource(overlord, calltimeScheduleId, 0L, Long.MAX_VALUE, new PageControl());
            assert (calltimeData.getTotalSize() == 0) : "didn't purge all calltime data";
            MeasurementSchedule traitSchedule = null;
            for (MeasurementSchedule sched : res.getSchedules()) {
                if (sched.getDefinition().getDataType() != DataType.TRAIT) continue;
                traitSchedule = sched;
                break;
            }
            assert (traitSchedule != null) : "why don't we have a trait schedule?";
            List persistedTraits = LookupUtil.getMeasurementDataManager().findTraits(overlord, res.getId(), traitSchedule.getDefinition().getId());
            assert (persistedTraits.size() == 1) : "bad purge of trait data: " + persistedTraits.size();
        }
        finally {
            this.getTransactionManager().rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerDataPurgeJobNow() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        SchedulerLocal schedulerBean = LookupUtil.getSchedulerBean();
        schedulerBean.scheduleSimpleCronJob(DataPurgeJob.class, true, false, "0 0 0 1 1 ? 2099");
        schedulerBean.addGlobalJobListener(new JobListener(){

            public String getName() {
                return "DataPurgeJobTestListener";
            }

            public void jobExecutionVetoed(JobExecutionContext arg0) {
            }

            public void jobToBeExecuted(JobExecutionContext arg0) {
            }

            public void jobWasExecuted(JobExecutionContext c, JobExecutionException e) {
                if (c.getJobDetail().getJobClass().getName().equals(DataPurgeJob.class.getName())) {
                    latch.countDown();
                }
            }
        });
        try {
            DataPurgeJob.purgeNow();
            assert (latch.await(60L, TimeUnit.SECONDS)) : "Data purge job didn't complete in a timely fashion";
        }
        finally {
            schedulerBean.deleteJob(DataPurgeJob.class.getName(), DataPurgeJob.class.getName());
        }
    }

    private void createNewTraitData(Resource res, long timestamp, int count) {
        MeasurementSchedule traitSchedule = null;
        for (MeasurementSchedule sched : res.getSchedules()) {
            if (sched.getDefinition().getDataType() != DataType.TRAIT) continue;
            traitSchedule = sched;
            break;
        }
        assert (traitSchedule != null) : "why don't we have a trait schedule?";
        MeasurementDataManagerLocal mgr = LookupUtil.getMeasurementDataManager();
        MeasurementScheduleRequest msr = new MeasurementScheduleRequest(traitSchedule);
        HashSet<MeasurementDataTrait> dataset = new HashSet<MeasurementDataTrait>();
        for (int i = 0; i < count; ++i) {
            dataset.add(new MeasurementDataTrait(timestamp + (long)i, msr, "DataPurgeJobTestTraitValue" + i));
        }
        mgr.addTraitData(dataset);
        List persistedTraits = mgr.findTraits(LookupUtil.getSubjectManager().getOverlord(), res.getId(), traitSchedule.getDefinition().getId());
        assert (persistedTraits.size() == count) : "did not persist trait data:" + persistedTraits.size() + ":" + persistedTraits;
    }

    private void createNewCalltimeData(Resource res, long timestamp, int count) {
        MeasurementSchedule calltimeSchedule = null;
        for (MeasurementSchedule sched : res.getSchedules()) {
            if (sched.getDefinition().getDataType() != DataType.CALLTIME) continue;
            calltimeSchedule = sched;
            break;
        }
        assert (calltimeSchedule != null) : "why don't we have a calltime schedule?";
        MeasurementScheduleRequest msr = new MeasurementScheduleRequest(calltimeSchedule);
        HashSet<CallTimeData> dataset = new HashSet<CallTimeData>();
        CallTimeData data = new CallTimeData(msr);
        for (int i = 0; i < count; ++i) {
            for (int j = 0; j < count; ++j) {
                data.addCallData("DataPurgeJobTestCalltimeData" + j, new Date(timestamp), 777L);
            }
        }
        dataset.add(data);
        CallTimeDataManagerLocal mgr = LookupUtil.getCallTimeDataManager();
        mgr.addCallTimeData(dataset);
        PageList persistedData = mgr.findCallTimeDataForResource(LookupUtil.getSubjectManager().getOverlord(), calltimeSchedule.getId(), timestamp - 1L, timestamp + (long)count + 1L, new PageControl());
        assert (persistedData.getTotalSize() == count) : "did not persist all calltime data, only persisted: " + persistedData.getTotalSize();
        assert (((CallTimeDataComposite)persistedData.get(0)).getCount() == (long)count) : "did not persist all endpoint calltime data, only persisted: " + ((CallTimeDataComposite)persistedData.get(0)).getCount();
    }

    private void createNewEvents(Resource res, long timestamp, int count) {
        EventDefinition ed = (EventDefinition)res.getResourceType().getEventDefinitions().iterator().next();
        EventSource source = new EventSource("datapurgejobtest", ed, res);
        HashMap eventMap = new HashMap();
        HashSet<Event> events = new HashSet<Event>();
        for (int i = 0; i < count; ++i) {
            events.add(new Event(ed.getName(), source.getLocation(), timestamp + (long)i, EventSeverity.DEBUG, "details"));
        }
        eventMap.put(source, events);
        EventManagerLocal mgr = LookupUtil.getEventManager();
        mgr.addEventData(eventMap);
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        PageList persistedEvents = mgr.findEventComposites(overlord, EntityContext.forResource((int)res.getId()), timestamp - 1L, timestamp + (long)count + 1L, new EventSeverity[]{EventSeverity.DEBUG}, null, null, new PageControl());
        assert (persistedEvents.getTotalSize() == count) : "did not persist all events, only persisted: " + persistedEvents.getTotalSize();
    }

    private Availability createNewAvailability(Resource res, long start, long end) {
        Availability a = new Availability(res, Long.valueOf(start), AvailabilityType.UP);
        if (end > 0L) {
            a.setEndTime(Long.valueOf(end));
        }
        this.em.persist((Object)a);
        return a;
    }

    private Alert createNewAlert(AlertDefinition ad, long timestamp) {
        Alert a = new Alert(ad, timestamp);
        this.em.persist((Object)a);
        AlertNotificationLog anl = new AlertNotificationLog(a, "dummy", ResultState.SUCCESS, "message");
        this.em.persist((Object)anl);
        AlertCondition ac = (AlertCondition)ad.getConditions().iterator().next();
        AlertConditionLog acl = new AlertConditionLog(ac, timestamp);
        acl.setAlert(a);
        acl.setValue("dummy value");
        this.em.persist((Object)acl);
        return a;
    }

    private Resource createNewResource() throws Exception {
        Resource resource;
        this.getTransactionManager().begin();
        try {
            long now = System.currentTimeMillis();
            ResourceType resourceType = new ResourceType("plat" + now, "test", ResourceCategory.PLATFORM, null);
            this.em.persist((Object)resourceType);
            this.resourceTypeId = resourceType.getId();
            Agent agent = new Agent("testagent" + now, "testaddress" + now, 1, "", "testtoken" + now);
            this.em.persist((Object)agent);
            this.agentId = agent.getId();
            this.em.flush();
            resource = new Resource("reskey" + now, "resname", resourceType);
            resource.setUuid("" + new Random().nextInt());
            resource.setAgent(agent);
            this.em.persist((Object)resource);
            AlertDefinition ad = new AlertDefinition();
            ad.setName("alertTest");
            ad.setEnabled(true);
            ad.setPriority(AlertPriority.HIGH);
            ad.setResource(resource);
            ad.setAlertDampening(new AlertDampening(AlertDampening.Category.NONE));
            ad.setConditionExpression(BooleanExpression.ALL);
            ad.setRecoveryId(Integer.valueOf(0));
            this.em.persist((Object)ad);
            AlertCondition ac = new AlertCondition(ad, AlertConditionCategory.AVAILABILITY);
            ac.setComparator("==");
            this.em.persist((Object)ac);
            ad.addCondition(ac);
            EventDefinition ed = new EventDefinition(resourceType, "DataPurgeJobTestEventDefinition");
            this.em.persist((Object)ed);
            resourceType.addEventDefinition(ed);
            MeasurementDefinition def = new MeasurementDefinition(resourceType, "DataPurgeJobTestCalltimeMeasDef");
            def.setCategory(MeasurementCategory.PERFORMANCE);
            def.setDataType(DataType.CALLTIME);
            def.setDefaultInterval(12345L);
            def.setDefaultOn(true);
            def.setDestinationType("DataPurgeJobTestDestType");
            def.setDisplayName(def.getName());
            def.setDisplayType(DisplayType.SUMMARY);
            this.em.persist((Object)def);
            MeasurementSchedule schedule = new MeasurementSchedule(def, resource);
            this.em.persist((Object)schedule);
            def.addSchedule(schedule);
            resource.addSchedule(schedule);
            def = new MeasurementDefinition(resourceType, "DataPurgeJobTestTraitMeasDef");
            def.setCategory(MeasurementCategory.PERFORMANCE);
            def.setDataType(DataType.TRAIT);
            def.setDefaultInterval(12345L);
            def.setDefaultOn(true);
            def.setDisplayName(def.getName());
            def.setDisplayType(DisplayType.SUMMARY);
            this.em.persist((Object)def);
            schedule = new MeasurementSchedule(def, resource);
            this.em.persist((Object)schedule);
            def.addSchedule(schedule);
            resource.addSchedule(schedule);
            def = new MeasurementDefinition(resourceType, "DataPurgeJobTestNormalMeasDef");
            def.setCategory(MeasurementCategory.PERFORMANCE);
            def.setDataType(DataType.MEASUREMENT);
            def.setDefaultInterval(12345L);
            def.setDefaultOn(true);
            def.setDisplayName(def.getName());
            def.setDisplayType(DisplayType.SUMMARY);
            this.em.persist((Object)def);
            schedule = new MeasurementSchedule(def, resource);
            this.em.persist((Object)schedule);
            def.addSchedule(schedule);
            resource.addSchedule(schedule);
        }
        catch (Exception e) {
            System.out.println("CANNOT PREPARE TEST: " + e);
            this.getTransactionManager().rollback();
            throw e;
        }
        this.getTransactionManager().commit();
        return resource;
    }

    private void deleteNewResource(Resource doomedResource) throws Exception {
        if (doomedResource != null) {
            ResourceType doomedResourceType = doomedResource.getResourceType();
            Agent doomedAgent = doomedResource.getAgent();
            Subject overlord = LookupUtil.getSubjectManager().getOverlord();
            ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
            List deletedIds = resourceManager.uninventoryResource(overlord, doomedResource.getId());
            for (Integer deletedResourceId : deletedIds) {
                resourceManager.uninventoryResourceAsyncWork(overlord, deletedResourceId.intValue());
            }
            this.getTransactionManager().begin();
            try {
                ResourceType type;
                Agent agent = (Agent)this.em.find(Agent.class, (Object)doomedAgent.getId());
                if (agent != null) {
                    this.em.remove((Object)agent);
                }
                if ((type = (ResourceType)this.em.find(ResourceType.class, (Object)doomedResourceType.getId())) != null) {
                    this.em.remove((Object)type);
                }
                this.getTransactionManager().commit();
            }
            catch (Exception e) {
                try {
                    System.out.println("CANNOT CLEAN UP TEST: Cause: " + e);
                    this.getTransactionManager().rollback();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
        }
    }
}

