/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.criteria.SavedSearchCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.search.SavedSearch;
import org.rhq.core.domain.search.SearchSubsystem;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.scheduler.jobs.SavedSearchResultCountRecalculationJob;
import org.rhq.enterprise.server.search.SavedSearchManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.test.TransactionCallbackReturnable;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.ResourceTreeHelper;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.Test;

public class SavedSearchResultCountRecalculationJobTest
extends AbstractEJB3Test {
    private SavedSearchManagerLocal savedSearchManager;
    private SubjectManagerLocal subjectManager;
    private RoleManagerLocal roleManager;
    private ResourceGroupManagerLocal resourceGroupManager;
    private SchedulerLocal scheduler;
    private TestData testData;

    @Override
    protected void beforeMethod() throws Exception {
        this.savedSearchManager = LookupUtil.getSavedSearchManager();
        this.subjectManager = LookupUtil.getSubjectManager();
        this.roleManager = LookupUtil.getRoleManager();
        this.resourceGroupManager = LookupUtil.getResourceGroupManager();
        this.scheduler = LookupUtil.getSchedulerBean();
        this.createTestData();
        this.prepareScheduler();
    }

    private void createTestData() {
        this.testData = this.executeInTransaction(false, new TransactionCallbackReturnable<TestData>(){

            @Override
            public TestData execute() throws Exception {
                Subject searchesOwner = SessionTestHelper.createNewSubject(SavedSearchResultCountRecalculationJobTest.this.em, "fake subject");
                Role searchesOwnerRole = SessionTestHelper.createNewRoleForSubject(SavedSearchResultCountRecalculationJobTest.this.em, searchesOwner, "fake role");
                ResourceType resourceType = SessionTestHelper.createNewResourceType(SavedSearchResultCountRecalculationJobTest.this.em);
                HashSet<Resource> resources = new HashSet<Resource>();
                HashSet<ResourceGroup> resourceGroups = new HashSet<ResourceGroup>();
                HashSet<SavedSearch> savedSearches = new HashSet<SavedSearch>();
                for (int i = 0; i < 50; ++i) {
                    SavedSearch savedSearch;
                    String iStr;
                    String string = iStr = i > 9 ? String.valueOf(i) : "0" + String.valueOf(i);
                    if (i < 25) {
                        resources.add(SessionTestHelper.createNewResource(SavedSearchResultCountRecalculationJobTest.this.em, "resource-" + iStr, resourceType));
                        savedSearch = new SavedSearch(SearchSubsystem.RESOURCE, "search-" + iStr, "resource-" + iStr, searchesOwner);
                        SavedSearchResultCountRecalculationJobTest.this.savedSearchManager.createSavedSearch(searchesOwner, savedSearch);
                        savedSearches.add(savedSearch);
                        continue;
                    }
                    resourceGroups.add(SessionTestHelper.createNewCompatibleGroupForRole(SavedSearchResultCountRecalculationJobTest.this.em, searchesOwnerRole, "group-" + iStr, resourceType));
                    savedSearch = new SavedSearch(SearchSubsystem.GROUP, "search-" + iStr, "group-" + iStr, searchesOwner);
                    SavedSearchResultCountRecalculationJobTest.this.savedSearchManager.createSavedSearch(searchesOwner, savedSearch);
                    savedSearches.add(savedSearch);
                }
                return new TestData(searchesOwner, searchesOwnerRole, resourceType, resources, resourceGroups, savedSearches);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterMethod() throws Exception {
        try {
            this.deleteTestData();
        }
        finally {
            this.unprepareScheduler();
        }
    }

    private void deleteTestData() {
        if (this.testData != null) {
            final TestData testDataToDelete = this.testData;
            this.testData = null;
            this.executeInTransaction(false, new TransactionCallback(){

                @Override
                public void execute() throws Exception {
                    for (SavedSearch savedSearch : testDataToDelete.getSavedSearches()) {
                        SavedSearchResultCountRecalculationJobTest.this.savedSearchManager.deleteSavedSearch(savedSearch.getSubject(), savedSearch.getId().intValue());
                    }
                    for (ResourceGroup resourceGroup : testDataToDelete.getResourceGroups()) {
                        SavedSearchResultCountRecalculationJobTest.this.resourceGroupManager.deleteResourceGroup(SavedSearchResultCountRecalculationJobTest.this.subjectManager.getOverlord(), resourceGroup.getId());
                    }
                    for (Resource resource : testDataToDelete.getResources()) {
                        ResourceTreeHelper.deleteResource(SavedSearchResultCountRecalculationJobTest.this.em, (Resource)SavedSearchResultCountRecalculationJobTest.this.em.find(Resource.class, (Object)resource.getId()));
                    }
                    SavedSearchResultCountRecalculationJobTest.this.em.remove(SavedSearchResultCountRecalculationJobTest.this.em.find(ResourceType.class, (Object)testDataToDelete.getResourceType().getId()));
                    SavedSearchResultCountRecalculationJobTest.this.subjectManager.deleteSubjects(SavedSearchResultCountRecalculationJobTest.this.subjectManager.getOverlord(), new int[]{testDataToDelete.getSearchesOwner().getId()});
                    SavedSearchResultCountRecalculationJobTest.this.roleManager.deleteRoles(SavedSearchResultCountRecalculationJobTest.this.subjectManager.getOverlord(), new int[]{testDataToDelete.getSearchesOwnerRole().getId()});
                }
            });
        }
    }

    @Test
    public void testSavedSearchResultCountRecalculation() throws Exception {
        this.runJobSynchronously();
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                SavedSearchCriteria criteria = new SavedSearchCriteria();
                criteria.clearPaging();
                criteria.addFilterSubjectId(Integer.valueOf(SavedSearchResultCountRecalculationJobTest.this.testData.getSearchesOwner().getId()));
                PageList foundSavedSearches = SavedSearchResultCountRecalculationJobTest.this.savedSearchManager.findSavedSearchesByCriteria(SavedSearchResultCountRecalculationJobTest.this.testData.getSearchesOwner(), criteria);
                SavedSearchResultCountRecalculationJobTest.this.assertEquals(SavedSearchResultCountRecalculationJobTest.this.testData.getSavedSearches().size(), foundSavedSearches.size());
                for (SavedSearch savedSearch : foundSavedSearches) {
                    SavedSearchResultCountRecalculationJobTest.this.assertTrue(savedSearch.toString() + " should have been computed", savedSearch.getLastComputeTime() > 0L);
                    SavedSearchResultCountRecalculationJobTest.this.assertEquals(1L, savedSearch.getResultCount());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runJobSynchronously() throws Exception {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        String jobName = SavedSearchResultCountRecalculationJob.class.getSimpleName();
        final String jobGroup = SavedSearchResultCountRecalculationJobTest.class.getSimpleName();
        this.scheduler.addGlobalJobListener(new JobListener(){

            public String getName() {
                return SavedSearchResultCountRecalculationJobTest.class.getSimpleName();
            }

            public void jobToBeExecuted(JobExecutionContext context) {
            }

            public void jobExecutionVetoed(JobExecutionContext context) {
            }

            public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
                if (context.getJobDetail().getGroup().equals(jobGroup)) {
                    countDownLatch.countDown();
                }
            }
        });
        this.scheduler.addJob(new JobDetail(jobName, jobGroup, SavedSearchResultCountRecalculationJob.class), true);
        this.scheduler.triggerJob(jobName, jobGroup);
        try {
            countDownLatch.await(60L, TimeUnit.SECONDS);
        }
        finally {
            this.scheduler.deleteJob(jobName, jobGroup);
        }
    }

    private static final class TestData {
        private final Subject searchesOwner;
        private final Role searchesOwnerRole;
        private final ResourceType resourceType;
        private final Set<Resource> resources;
        private final Set<ResourceGroup> resourceGroups;
        private final Set<SavedSearch> savedSearches;

        private TestData(Subject searchesOwner, Role searchesOwnerRole, ResourceType resourceType, Set<Resource> resources, Set<ResourceGroup> resourceGroups, Set<SavedSearch> savedSearches) {
            this.searchesOwner = searchesOwner;
            this.searchesOwnerRole = searchesOwnerRole;
            this.resourceType = resourceType;
            this.resources = resources;
            this.resourceGroups = resourceGroups;
            this.savedSearches = savedSearches;
        }

        public Subject getSearchesOwner() {
            return this.searchesOwner;
        }

        public Role getSearchesOwnerRole() {
            return this.searchesOwnerRole;
        }

        public ResourceType getResourceType() {
            return this.resourceType;
        }

        public Set<Resource> getResources() {
            return this.resources;
        }

        public Set<ResourceGroup> getResourceGroups() {
            return this.resourceGroups;
        }

        public Set<SavedSearch> getSavedSearches() {
            return this.savedSearches;
        }
    }
}

