/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search;

import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.criteria.SavedSearchCriteria;
import org.rhq.core.domain.search.SavedSearch;
import org.rhq.core.domain.search.SearchSubsystem;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.search.SavedSearchManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.Test;

public class SavedSearchManagerBeanTest
extends AbstractEJB3Test {
    private SavedSearchManagerLocal savedSearchManager;

    @Override
    protected void beforeMethod() throws Exception {
        this.savedSearchManager = LookupUtil.getSavedSearchManager();
    }

    @Test
    public void testCRUD() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Subject subject = SessionTestHelper.createNewSubject(SavedSearchManagerBeanTest.this.em, "fake subject");
                int entityId = SavedSearchManagerBeanTest.this.savedSearchManager.createSavedSearch(subject, new SavedSearch(SearchSubsystem.GROUP, "fake saved search", "pipo", subject));
                SavedSearch entity = SavedSearchManagerBeanTest.this.savedSearchManager.getSavedSearchById(subject, entityId);
                SavedSearchManagerBeanTest.this.assertNotNull(entity);
                SavedSearch modifiedEntity = new SavedSearch(SearchSubsystem.RESOURCE, "fake saved search modified", "molo", subject);
                modifiedEntity.setId(Integer.valueOf(entityId));
                boolean updateSuccess = SavedSearchManagerBeanTest.this.savedSearchManager.updateSavedSearch(subject, modifiedEntity);
                SavedSearchManagerBeanTest.this.assertTrue("Update save searched failed", updateSuccess);
                SavedSearchManagerBeanTest.this.savedSearchManager.deleteSavedSearch(subject, entityId);
                SavedSearchManagerBeanTest.this.assertNull(SavedSearchManagerBeanTest.this.em.find(SavedSearch.class, (Object)entityId));
            }
        });
    }

    @Test
    public void testgetSavedSearchByIdPermission() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Subject subject1 = SessionTestHelper.createNewSubject(SavedSearchManagerBeanTest.this.em, "fake subject 1");
                SavedSearch savedSearch = new SavedSearch(SearchSubsystem.GROUP, "fake saved search", "pipo", subject1);
                int entityId = SavedSearchManagerBeanTest.this.savedSearchManager.createSavedSearch(subject1, savedSearch);
                Subject subject2 = SessionTestHelper.createNewSubject(SavedSearchManagerBeanTest.this.em, "fake subject 2");
                try {
                    SavedSearchManagerBeanTest.this.savedSearchManager.getSavedSearchById(subject2, entityId);
                    SavedSearchManagerBeanTest.this.fail("Expected " + PermissionException.class.getSimpleName());
                }
                catch (PermissionException e) {
                    SavedSearchManagerBeanTest.this.assertTrue(e.getMessage().contains("view"));
                }
            }
        });
    }

    @Test
    public void testCreateSavedSearchPermission() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                final Subject subject1 = SessionTestHelper.createNewSubject(SavedSearchManagerBeanTest.this.em, "fake subject 1");
                final Subject subject2 = SessionTestHelper.createNewSubject(SavedSearchManagerBeanTest.this.em, "fake subject 2");
                SavedSearchManagerBeanTest.this.assertManipulatePermissionExceptionThrown(new Runnable(){

                    @Override
                    public void run() {
                        SavedSearchManagerBeanTest.this.savedSearchManager.createSavedSearch(subject2, new SavedSearch(SearchSubsystem.GROUP, "fake saved search 2", "molo", subject1));
                    }
                });
            }
        });
    }

    @Test
    public void testDeleteSavedSearchPermission() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Subject subject1 = SessionTestHelper.createNewSubject(SavedSearchManagerBeanTest.this.em, "fake subject 1");
                final int entityId = SavedSearchManagerBeanTest.this.savedSearchManager.createSavedSearch(subject1, new SavedSearch(SearchSubsystem.GROUP, "fake saved search", "pipo", subject1));
                final Subject subject2 = SessionTestHelper.createNewSubject(SavedSearchManagerBeanTest.this.em, "fake subject 2");
                SavedSearchManagerBeanTest.this.assertManipulatePermissionExceptionThrown(new Runnable(){

                    @Override
                    public void run() {
                        SavedSearchManagerBeanTest.this.savedSearchManager.deleteSavedSearch(subject2, entityId);
                    }
                });
            }
        });
    }

    @Test
    public void testUpdateSavedSearchPermission() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                final Subject subject1 = SessionTestHelper.createNewSubject(SavedSearchManagerBeanTest.this.em, "fake subject 1");
                final int entityId = SavedSearchManagerBeanTest.this.savedSearchManager.createSavedSearch(subject1, new SavedSearch(SearchSubsystem.GROUP, "fake saved search", "pipo", subject1));
                final Subject subject2 = SessionTestHelper.createNewSubject(SavedSearchManagerBeanTest.this.em, "fake subject 2");
                SavedSearchManagerBeanTest.this.assertManipulatePermissionExceptionThrown(new Runnable(){

                    @Override
                    public void run() {
                        SavedSearch modifiedEntity = new SavedSearch(SearchSubsystem.GROUP, "fake saved search 2", "molo", subject1);
                        modifiedEntity.setId(Integer.valueOf(entityId));
                        SavedSearchManagerBeanTest.this.savedSearchManager.updateSavedSearch(subject2, modifiedEntity);
                    }
                });
            }
        });
    }

    private void assertManipulatePermissionExceptionThrown(Runnable runnable) {
        try {
            runnable.run();
            this.fail("Expected " + PermissionException.class.getSimpleName());
        }
        catch (PermissionException e) {
            this.assertTrue(e.getMessage().contains("manipulate"));
        }
    }

    @Test
    public void testFindSavedSearchesByCriteria() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Subject subject1 = SessionTestHelper.createNewSubject(SavedSearchManagerBeanTest.this.em, "fake subject 1");
                Subject subject2 = SessionTestHelper.createNewSubject(SavedSearchManagerBeanTest.this.em, "fake subject 2");
                Role inventoryManagerRole = SessionTestHelper.createNewRoleForSubject(SavedSearchManagerBeanTest.this.em, subject2, "inventory manager role", Permission.MANAGE_INVENTORY);
                for (int i = 0; i < 1000; ++i) {
                    String iStr = String.valueOf(i);
                    SavedSearchManagerBeanTest.this.savedSearchManager.createSavedSearch(subject1, new SavedSearch(SearchSubsystem.GROUP, "fake saved search " + iStr, "pipo " + iStr, subject1));
                    SavedSearchManagerBeanTest.this.savedSearchManager.createSavedSearch(subject2, new SavedSearch(SearchSubsystem.GROUP, "fake saved search " + iStr, "molo " + iStr, subject2));
                }
                SavedSearchCriteria criteria = new SavedSearchCriteria();
                criteria.addFilterName("fake saved search");
                criteria.clearPaging();
                PageList foundEntities = SavedSearchManagerBeanTest.this.savedSearchManager.findSavedSearchesByCriteria(subject2, criteria);
                SavedSearchManagerBeanTest.this.assertTrue("User with manage inventory should see all saved searches", 2000 == foundEntities.size());
                foundEntities = SavedSearchManagerBeanTest.this.savedSearchManager.findSavedSearchesByCriteria(subject1, criteria);
                SavedSearchManagerBeanTest.this.assertTrue("User without manage inventory should see only its own saved searches", 1000 == foundEntities.size());
            }
        });
    }
}

