/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.search;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.search.SearchSubsystem;
import org.rhq.enterprise.server.search.assist.AbstractSearchAssistant;
import org.rhq.enterprise.server.search.assist.SearchAssistant;
import org.rhq.enterprise.server.search.execution.SearchAssistManager;
import org.rhq.enterprise.server.util.LookupUtil;

public class TestAutoCompletionManager
extends SearchAssistManager {
    public TestAutoCompletionManager() {
        super(LookupUtil.getSubjectManager().getOverlord(), null);
    }

    protected AbstractSearchAssistant getSearchAssistant() {
        return new TestAutoCompletor(LookupUtil.getSubjectManager().getOverlord());
    }

    protected SearchAssistant getTabAwareSearchAssistant(String tab) {
        return new TestAutoCompletor(LookupUtil.getSubjectManager().getOverlord());
    }

    public static class TestAutoCompletor
    extends AbstractSearchAssistant {
        private static Map<String, List<String>> suggestionMap = new HashMap<String, List<String>>();

        private static List<String> build(String ... items) {
            return Collections.unmodifiableList(Arrays.asList(items));
        }

        public TestAutoCompletor(Subject subject) {
            super(subject);
        }

        public SearchSubsystem getSearchSubsystem() {
            return null;
        }

        public List<String> getSimpleContexts() {
            return Arrays.asList("number");
        }

        public List<String> getParameterizedContexts() {
            return Arrays.asList("color");
        }

        public List<String> getParameters(String context, String filter) {
            super.getParameters(context, filter);
            return this.filter(suggestionMap.get("color:params"), filter);
        }

        public List<String> getValues(String context, String param, String filter) {
            super.getValues(context, param, filter);
            String lookup = context + ":" + (param == null ? "" : param);
            return this.filter(suggestionMap.get(lookup), filter);
        }

        static {
            suggestionMap.put("color:params", TestAutoCompletor.build("primary", "other"));
            suggestionMap.put("color:primary", TestAutoCompletor.build("red", "green", "blue"));
            suggestionMap.put("color:other", TestAutoCompletor.build("red-green", "green-blue", "blue-red"));
            suggestionMap.put("number:", TestAutoCompletor.build("two", "four", "twenty-two", "twenty-four", "forty-two"));
        }
    }
}

