/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.tagging;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.bundle.Bundle;
import org.rhq.core.domain.bundle.BundleDeployment;
import org.rhq.core.domain.bundle.BundleDestination;
import org.rhq.core.domain.bundle.BundleType;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.bundle.ResourceTypeBundleConfiguration;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.criteria.TagCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.tagging.Tag;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.bundle.BundleManagerLocal;
import org.rhq.enterprise.server.bundle.TestBundlePluginComponent;
import org.rhq.enterprise.server.bundle.TestBundleServerPluginService;
import org.rhq.enterprise.server.tagging.TagManagerLocal;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.SessionTestHelper;
import org.testng.annotations.Test;

@Test
public class TagManagerBeanTest
extends AbstractEJB3Test {
    private TagManagerLocal tagManager;
    private BundleManagerLocal bundleManager;
    private Subject overlord;
    private Random random = new Random();
    private String testNamespace = this.getRandomString();
    private String testSemantic = this.getRandomString();

    @Override
    protected void beforeMethod() throws Exception {
        this.tagManager = LookupUtil.getTagManager();
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        this.bundleManager = LookupUtil.getBundleManager();
        this.overlord = subjectManager.getOverlord();
        TestBundleServerPluginService bundleServerPluginService = new TestBundleServerPluginService(this.getTempDir(), new TestBundlePluginComponent());
        this.prepareCustomServerPluginService(bundleServerPluginService);
        bundleServerPluginService.startMasterPluginContainer();
    }

    @Override
    protected void afterMethod() throws Exception {
        this.unprepareServerPluginService();
    }

    public void testAddTags() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Set tags = TagManagerBeanTest.this.generateTagSet(1000);
                tags = TagManagerBeanTest.this.tagManager.addTags(TagManagerBeanTest.this.overlord, tags);
                TagManagerBeanTest.this.assertEquals(1000, tags.size());
                PageList foundTags = TagManagerBeanTest.this.tagManager.findTagsByCriteria(TagManagerBeanTest.this.overlord, TagManagerBeanTest.this.getTestCriteria());
                TagManagerBeanTest.this.assertTrue("Default paging should find less tags than created", foundTags.size() < tags.size());
                TagCriteria tagCriteria = TagManagerBeanTest.this.getTestCriteria();
                tagCriteria.clearPaging();
                foundTags = TagManagerBeanTest.this.tagManager.findTagsByCriteria(TagManagerBeanTest.this.overlord, tagCriteria);
                TagManagerBeanTest.this.assertTrue("Cleared paging should find as much tags as created", foundTags.size() == tags.size());
            }
        });
    }

    public void addTagsShouldSilentlyHandleTagDuplicates() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Set tags = TagManagerBeanTest.this.generateTagSet(5);
                tags = TagManagerBeanTest.this.tagManager.addTags(TagManagerBeanTest.this.overlord, tags);
                while (tags.size() < 7) {
                    tags.add(TagManagerBeanTest.this.generateTag());
                }
                Set allTags = TagManagerBeanTest.this.tagManager.addTags(TagManagerBeanTest.this.overlord, tags);
                TagManagerBeanTest.this.assertTrue("#addTags should silently handle tag duplicates", tags.equals(allTags));
            }
        });
    }

    public void testRemoveTags() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Set tags = TagManagerBeanTest.this.generateTagSet(11);
                tags = TagManagerBeanTest.this.tagManager.addTags(TagManagerBeanTest.this.overlord, tags);
                Set tagsToRemove = TagManagerBeanTest.this.emptyTagSet();
                for (Tag tag : tags) {
                    tagsToRemove.add(tag);
                    if (tagsToRemove.size() <= tags.size() / 2) continue;
                    break;
                }
                TagManagerBeanTest.this.tagManager.removeTags(TagManagerBeanTest.this.overlord, tagsToRemove);
                TagCriteria tagCriteria = TagManagerBeanTest.this.getTestCriteria();
                tagCriteria.clearPaging();
                PageList remainingTags = TagManagerBeanTest.this.tagManager.findTagsByCriteria(TagManagerBeanTest.this.overlord, tagCriteria);
                TagManagerBeanTest.this.assertEquals(tags.size() - tagsToRemove.size(), remainingTags.size());
            }
        });
    }

    public void testUpdateResourceTags() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Resource resource = SessionTestHelper.createNewResource(TagManagerBeanTest.this.em, TagManagerBeanTest.this.getRandomString());
                resource.setTags(TagManagerBeanTest.this.emptyTagSet());
                Set tags = TagManagerBeanTest.this.generateTagSet(7);
                TagManagerBeanTest.this.tagManager.updateResourceTags(TagManagerBeanTest.this.overlord, resource.getId(), tags);
                TagManagerBeanTest.this.assertEquals(tags, resource.getTags());
            }
        });
    }

    public void testUpdateResourceGroupTags() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                ResourceGroup resourceGroup = TagManagerBeanTest.this.createResourceGroup();
                resourceGroup.setTags(TagManagerBeanTest.this.emptyTagSet());
                Set tags = TagManagerBeanTest.this.generateTagSet(7);
                TagManagerBeanTest.this.tagManager.updateResourceGroupTags(TagManagerBeanTest.this.overlord, resourceGroup.getId(), tags);
                TagManagerBeanTest.this.assertEquals(tags, resourceGroup.getTags());
            }
        });
    }

    public void testUpdateBundleTags() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Set tags = TagManagerBeanTest.this.generateTagSet(7);
                Bundle bundle = TagManagerBeanTest.this.createBundle();
                bundle.setTags(TagManagerBeanTest.this.emptyTagSet());
                TagManagerBeanTest.this.tagManager.updateBundleTags(TagManagerBeanTest.this.overlord, bundle.getId(), tags);
                TagManagerBeanTest.this.assertEquals(tags, bundle.getTags());
            }
        });
    }

    public void testUpdateBundleVersionTags() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Set tags = TagManagerBeanTest.this.generateTagSet(7);
                BundleVersion bundleVersion = TagManagerBeanTest.this.createBundleVersion();
                bundleVersion.setTags(TagManagerBeanTest.this.emptyTagSet());
                TagManagerBeanTest.this.tagManager.updateBundleVersionTags(TagManagerBeanTest.this.overlord, bundleVersion.getId(), tags);
                TagManagerBeanTest.this.assertEquals(tags, bundleVersion.getTags());
            }
        });
    }

    public void testUpdateBundleDeploymentTags() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Set tags = TagManagerBeanTest.this.generateTagSet(7);
                BundleDeployment bundleDeployment = TagManagerBeanTest.this.createBundleDeployment();
                bundleDeployment.setTags(TagManagerBeanTest.this.emptyTagSet());
                TagManagerBeanTest.this.tagManager.updateBundleDeploymentTags(TagManagerBeanTest.this.overlord, bundleDeployment.getId(), tags);
                TagManagerBeanTest.this.assertEquals(tags, bundleDeployment.getTags());
            }
        });
    }

    public void testUpdateBundleDestinationTags() {
        this.executeInTransaction(new TransactionCallback(){

            @Override
            public void execute() throws Exception {
                Set tags = TagManagerBeanTest.this.generateTagSet(7);
                BundleDestination bundleDestination = TagManagerBeanTest.this.createBundleDestination();
                bundleDestination.setTags(TagManagerBeanTest.this.emptyTagSet());
                TagManagerBeanTest.this.tagManager.updateBundleDestinationTags(TagManagerBeanTest.this.overlord, bundleDestination.getId(), tags);
                TagManagerBeanTest.this.assertEquals(tags, bundleDestination.getTags());
            }
        });
    }

    private Set<Tag> emptyTagSet() {
        return new HashSet<Tag>();
    }

    private Set<Tag> generateTagSet(int size) {
        Set<Tag> generatedTags = this.emptyTagSet();
        while (generatedTags.size() < size) {
            generatedTags.add(this.generateTag());
        }
        return generatedTags;
    }

    private Tag generateTag() {
        return new Tag(this.testNamespace, this.testSemantic, this.getRandomString());
    }

    private String getRandomString() {
        return new BigInteger(50, this.random).toString(32);
    }

    private TagCriteria getTestCriteria() {
        TagCriteria criteria = new TagCriteria();
        criteria.addFilterNamespace(this.testNamespace);
        criteria.addFilterSemantic(this.testSemantic);
        return criteria;
    }

    private ResourceGroup createResourceGroup() {
        Subject subject = SessionTestHelper.createNewSubject(this.em, this.getRandomString());
        Role role = SessionTestHelper.createNewRoleForSubject(this.em, subject, this.getRandomString());
        return SessionTestHelper.createNewCompatibleGroupForRole(this.em, role, this.getRandomString());
    }

    private Bundle createBundle() throws Exception {
        ResourceType resourceType = SessionTestHelper.createNewResourceType(this.em);
        BundleType bundleType = this.bundleManager.createBundleType(this.overlord, this.getRandomString(), resourceType.getId());
        return this.bundleManager.createBundle(this.overlord, this.getRandomString(), this.getRandomString(), bundleType.getId(), null);
    }

    private BundleVersion createBundleVersion() throws Exception {
        return this.createBundleVersion(this.createBundle());
    }

    private BundleVersion createBundleVersion(Bundle bundle) throws Exception {
        return this.bundleManager.createBundleVersion(this.overlord, bundle.getId(), this.getRandomString(), this.getRandomString(), this.getRandomString(), this.getRandomString());
    }

    private BundleDestination createBundleDestination() throws Exception {
        Bundle bundle = this.createBundle();
        ResourceGroup resourceGroup = this.createResourceGroupForBundleDeployments();
        return this.bundleManager.createBundleDestination(this.overlord, bundle.getId(), this.getRandomString(), this.getRandomString(), this.getRandomString(), this.getRandomString(), Integer.valueOf(resourceGroup.getId()));
    }

    private BundleDeployment createBundleDeployment() throws Exception {
        BundleDestination bundleDestination = this.createBundleDestination();
        Configuration configuration = new Configuration();
        configuration.put((Property)new PropertySimple("bundletest.property", (Object)"bundletest.property value"));
        BundleVersion bundleVersion = this.createBundleVersion(bundleDestination.getBundle());
        return this.bundleManager.createBundleDeployment(this.overlord, bundleVersion.getId(), bundleDestination.getId(), this.getRandomString(), configuration);
    }

    private ResourceGroup createResourceGroupForBundleDeployments() {
        ResourceType resourceType = SessionTestHelper.createNewResourceType(this.em);
        ResourceTypeBundleConfiguration resourceTypeBundleConfiguration = new ResourceTypeBundleConfiguration(new Configuration());
        resourceTypeBundleConfiguration.addBundleDestinationBaseDirectory(this.getRandomString(), ResourceTypeBundleConfiguration.BundleDestinationBaseDirectory.Context.pluginConfiguration.name(), this.getRandomString(), this.getRandomString());
        resourceType.setResourceTypeBundleConfiguration(resourceTypeBundleConfiguration);
        Resource resource = SessionTestHelper.createNewResource(this.em, this.getRandomString(), resourceType);
        ResourceGroup resourceGroup = this.createResourceGroup();
        resourceGroup.addExplicitResource(resource);
        resourceGroup.setResourceType(resourceType);
        return resourceGroup;
    }
}

