/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.ejb.EJB;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.transaction.TransactionManager;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.asset.ClassAsset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.exporter.zip.ZipExporterImpl;
import org.jboss.shrinkwrap.resolver.api.Resolvers;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.criteria.ServerCriteria;
import org.rhq.core.domain.shared.BuilderException;
import org.rhq.core.domain.shared.ResourceBuilder;
import org.rhq.core.domain.shared.ResourceTypeBuilder;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.auth.SessionManager;
import org.rhq.enterprise.server.core.comm.ServerCommunicationsServiceMBean;
import org.rhq.enterprise.server.core.plugin.PluginDeploymentScanner;
import org.rhq.enterprise.server.core.plugin.PluginDeploymentScannerMBean;
import org.rhq.enterprise.server.plugin.pc.ServerPluginService;
import org.rhq.enterprise.server.plugin.pc.ServerPluginServiceMBean;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.enterprise.server.scheduler.SchedulerService;
import org.rhq.enterprise.server.scheduler.SchedulerServiceMBean;
import org.rhq.enterprise.server.storage.FakeStorageClusterSettingsManagerBean;
import org.rhq.enterprise.server.storage.StorageClientManager;
import org.rhq.enterprise.server.test.StrippedDownStartupBean;
import org.rhq.enterprise.server.test.StrippedDownStartupBeanPreparation;
import org.rhq.enterprise.server.test.TestServerCommunicationsService;
import org.rhq.enterprise.server.test.TestServerCommunicationsServiceMBean;
import org.rhq.enterprise.server.test.TransactionCallback;
import org.rhq.enterprise.server.test.TransactionCallbackReturnable;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.test.AssertUtils;
import org.rhq.test.MatchResult;
import org.rhq.test.PropertyMatchException;
import org.rhq.test.PropertyMatcher;
import org.testng.AssertJUnit;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class AbstractEJB3Test
extends Arquillian {
    public static final int DEFAULT_CRITERIA_PAGE_SIZE = 200;
    protected static final String JNDI_RHQDS = "java:jboss/datasources/RHQDS";
    protected static File tmpdirRoot = new File("./target/test-tmpdir");
    private TestServerCommunicationsService agentService;
    private SchedulerService schedulerService;
    private ServerPluginService serverPluginService;
    private PluginDeploymentScannerMBean pluginScannerService;
    private String originalServerIdentity;
    @PersistenceContext(unitName="rhqpu")
    protected EntityManager em;
    @ArquillianResource
    protected InitialContext initialContext;
    @EJB
    private StorageClientManager storageClientManager;

    @Deployment
    protected static EnterpriseArchive getBaseDeployment() {
        tmpdirRoot.mkdirs();
        JavaArchive testClassesJar = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test-classes.jar");
        testClassesJar = AbstractEJB3Test.addClasses(testClassesJar, new File("target/test-classes/org"), null);
        testClassesJar.addClass(ThrowableUtil.class);
        testClassesJar.addClass(MessageDigestGenerator.class);
        testClassesJar.addClass(StreamUtil.class);
        testClassesJar.addClass(AssertUtils.class);
        testClassesJar.addClass(ResourceBuilder.class);
        testClassesJar.addClass(ResourceTypeBuilder.class);
        testClassesJar.addClass(BuilderException.class);
        testClassesJar.addClasses(new Class[]{PropertyMatcher.class, MatchResult.class, PropertyMatchException.class});
        testClassesJar.addAsManifestResource((Asset)EmptyAsset.INSTANCE, ArchivePaths.create((String)"beans.xml"));
        testClassesJar.addAsResource("binary-blob-sample.jar");
        testClassesJar.addAsResource("test-alert-sender-serverplugin.xml");
        testClassesJar.addAsResource("test-assist-color-number.txt");
        testClassesJar.addAsResource("test-ldap.properties");
        testClassesJar.addAsResource("test-scheduler.properties");
        testClassesJar.addAsResource("cassandra-test.properties");
        testClassesJar.addAsResource("org/rhq/enterprise/server/configuration/metadata/configuration_metadata_manager_bean_test_v1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/configuration/metadata/configuration_metadata_manager_bean_test_v2.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/discovery/DiscoveryBossBeanTest.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/inventory/InventoryManagerBeanTest.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/MetadataTest.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/AlertMetadataManagerBeanTest/plugin_v1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/AlertMetadataManagerBeanTest/plugin_v2.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/ContentMetadataManagerBeanTest/plugin_v1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/ContentMetadataManagerBeanTest/plugin_v2.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/EventMetadataManagerBeanTest/plugin_v1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/EventMetadataManagerBeanTest/plugin_v2.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/MeasurementMetadataManagerBeanTest/plugin_v1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/MeasurementMetadataManagerBeanTest/plugin_v2.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/MultiplePluginExtensionMetadataTest/child1_plugin_v1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/MultiplePluginExtensionMetadataTest/child2_plugin_v1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/MultiplePluginExtensionMetadataTest/parent_plugin_v1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/MultiplePluginExtensionMetadataTest/parent_plugin_v2.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/MultiplePluginExtensionSinglePluginDescriptorMetadataTest/child_plugin_v1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/MultiplePluginExtensionSinglePluginDescriptorMetadataTest/parent_plugin_v1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/MultiplePluginExtensionSinglePluginDescriptorMetadataTest/parent_plugin_v2.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/OperationMetadataManagerBeanTest/plugin_v1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/OperationMetadataManagerBeanTest/plugin_v2.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/PluginExtensionMetadataTest/child_plugin_v1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/PluginExtensionMetadataTest/parent_plugin_v1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/PluginExtensionMetadataTest/parent_plugin_v2.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/PluginManagerBeanTest/plugin_1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/PluginManagerBeanTest/plugin_2.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/PluginManagerBeanTest/plugin_3.1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/PluginManagerBeanTest/plugin_3.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/PluginScanningExtensionMetadataTest/child1_plugin_v1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/PluginScanningExtensionMetadataTest/child2_plugin_v1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/PluginScanningExtensionMetadataTest/parent_plugin_v1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/PluginScanningExtensionMetadataTest/parent_plugin_v2.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/ResourceMetadataManagerBeanTest/dup_drift.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/ResourceMetadataManagerBeanTest/parent_resource_type-plugin.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/ResourceMetadataManagerBeanTest/plugin_v1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/ResourceMetadataManagerBeanTest/plugin_v2.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/ResourceMetadataManagerBeanTest/remove_bundle_drift_config_v1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/ResourceMetadataManagerBeanTest/remove_bundle_drift_config_v2.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/ResourceMetadataManagerBeanTest/remove_types_v1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/ResourceMetadataManagerBeanTest/remove_types_v2.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/MetadataUpdateWithIgnoredTypesTest/remove_types_v1.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/resource/metadata/MetadataUpdateWithIgnoredTypesTest/remove_types_v2.xml");
        testClassesJar.addAsResource("perftest/AvailabilityInsertPurgeTest-testOne-data.xml.zip");
        testClassesJar.addAsResource("serverplugins/simple-generic-serverplugin.xml");
        testClassesJar.addAsResource("test/deployment/1.0-feb-2.xml");
        testClassesJar.addAsResource("test/deployment/1.0-feb.xml");
        testClassesJar.addAsResource("test/deployment/1.0-june.xml");
        testClassesJar.addAsResource("test/deployment/1.1-feb.xml");
        testClassesJar.addAsResource("test/deployment/1.1-june.xml");
        testClassesJar.addAsResource("test/metadata/content-source-update-v1.xml");
        testClassesJar.addAsResource("test/metadata/content-source-update-v2.xml");
        testClassesJar.addAsResource("test/metadata/noTypes.xml");
        testClassesJar.addAsResource("test/metadata/alerts/type-with-metric.xml");
        testClassesJar.addAsResource("test/metadata/alerts/type-with-trait.xml");
        testClassesJar.addAsResource("test/metadata/configuration/addDeleteTemplate1.xml");
        testClassesJar.addAsResource("test/metadata/configuration/addDeleteTemplate2.xml");
        testClassesJar.addAsResource("test/metadata/configuration/addDeleteTemplate3.xml");
        testClassesJar.addAsResource("test/metadata/configuration/constraint.xml");
        testClassesJar.addAsResource("test/metadata/configuration/constraintMinMax.xml");
        testClassesJar.addAsResource("test/metadata/configuration/propertyChanging-v1.xml");
        testClassesJar.addAsResource("test/metadata/configuration/propertyChanging-v2.xml");
        testClassesJar.addAsResource("test/metadata/configuration/propertyList-v1.xml");
        testClassesJar.addAsResource("test/metadata/configuration/propertyList-v2.xml");
        testClassesJar.addAsResource("test/metadata/configuration/propertyList-simple.xml");
        testClassesJar.addAsResource("test/metadata/configuration/propertyMap-v1.xml");
        testClassesJar.addAsResource("test/metadata/configuration/propertyMap-v2.xml");
        testClassesJar.addAsResource("test/metadata/configuration/groupDeleted-v1.xml");
        testClassesJar.addAsResource("test/metadata/configuration/groupDeleted-v2.xml");
        testClassesJar.addAsResource("test/metadata/configuration/groupPropDeleted-v1.xml");
        testClassesJar.addAsResource("test/metadata/configuration/groupPropDeleted-v2.xml");
        testClassesJar.addAsResource("test/metadata/configuration/groupPropDeleted-v3.xml");
        testClassesJar.addAsResource("test/metadata/configuration/groupPropDeleted-v4.xml");
        testClassesJar.addAsResource("test/metadata/configuration/groupPropMoved-v1.xml");
        testClassesJar.addAsResource("test/metadata/configuration/groupPropMoved-v2.xml");
        testClassesJar.addAsResource("test/metadata/configuration/update5-v1_0.xml");
        testClassesJar.addAsResource("test/metadata/configuration/update5-v2_0.xml");
        testClassesJar.addAsResource("test/metadata/configuration/updateDefaultTemplate1.xml");
        testClassesJar.addAsResource("test/metadata/configuration/updateDefaultTemplate2.xml");
        testClassesJar.addAsResource("test/metadata/events/event1-1.xml");
        testClassesJar.addAsResource("test/metadata/events/event1-2.xml");
        testClassesJar.addAsResource("test/metadata/measurement/measurementDeletion-v1_0.xml");
        testClassesJar.addAsResource("test/metadata/measurement/measurementDeletion-v2_0.xml");
        testClassesJar.addAsResource("test/metadata/measurement/update-v1_0.xml");
        testClassesJar.addAsResource("test/metadata/measurement/update-v2_0.xml");
        testClassesJar.addAsResource("test/metadata/measurement/update6-1.xml");
        testClassesJar.addAsResource("test/metadata/measurement/update6-2.xml");
        testClassesJar.addAsResource("test/metadata/measurement/update7-1.xml");
        testClassesJar.addAsResource("test/metadata/measurement/update7-2.xml");
        testClassesJar.addAsResource("test/metadata/natives/update5-v1_0.xml");
        testClassesJar.addAsResource("test/metadata/natives/update5-v2_0.xml");
        testClassesJar.addAsResource("test/metadata/operation/operation1-1.xml");
        testClassesJar.addAsResource("test/metadata/operation/operation1-2.xml");
        testClassesJar.addAsResource("test/metadata/operation/operation2-1.xml");
        testClassesJar.addAsResource("test/metadata/operation/operation2-2.xml");
        testClassesJar.addAsResource("test/metadata/operation/operation3-1.xml");
        testClassesJar.addAsResource("test/metadata/operation/operation3-2.xml");
        testClassesJar.addAsResource("test/metadata/operation/update3-v1_0.xml");
        testClassesJar.addAsResource("test/metadata/operation/update3-v2_0.xml");
        testClassesJar.addAsResource("test/metadata/resource/illegal-subcat-1.xml");
        testClassesJar.addAsResource("test/metadata/resource/nested-subcat-2children.xml");
        testClassesJar.addAsResource("test/metadata/resource/nested-subcat-grandchild.xml");
        testClassesJar.addAsResource("test/metadata/resource/nested-subcat-services-v1_0.xml");
        testClassesJar.addAsResource("test/metadata/resource/nested-subcat-services-v2_0.xml");
        testClassesJar.addAsResource("test/metadata/resource/nested-subcat-v1_0.xml");
        testClassesJar.addAsResource("test/metadata/resource/nested-subcat-v1_1.xml");
        testClassesJar.addAsResource("test/metadata/resource/nested-subcat-v2_0.xml");
        testClassesJar.addAsResource("test/metadata/resource/no-subcat.xml");
        testClassesJar.addAsResource("test/metadata/resource/one-subcat-v1_0.xml");
        testClassesJar.addAsResource("test/metadata/resource/one-subcat-v1_1.xml");
        testClassesJar.addAsResource("test/metadata/resource/one-subcat-v2_0.xml");
        testClassesJar.addAsResource("test/metadata/resource/one-subcat-v3_0.xml");
        testClassesJar.addAsResource("test/metadata/resource/services-v1_0.xml");
        testClassesJar.addAsResource("test/metadata/resource/services-v2_0.xml");
        testClassesJar.addAsResource("test/metadata/resource/test-subcategories.xml");
        testClassesJar.addAsResource("test/metadata/resource/test-subcategories2.xml");
        testClassesJar.addAsResource("test/metadata/resource/test-subcategories3.xml");
        testClassesJar.addAsResource("test/metadata/resource/two-subcat.xml");
        testClassesJar.addAsResource("test/metadata/resource/undefined-child-subcat-1.xml");
        testClassesJar.addAsResource("test/metadata/resource-type/duplicateResourceType.xml");
        testClassesJar.addAsResource("test/metadata/resource-type/update2-v1_0.xml");
        testClassesJar.addAsResource("test/metadata/resource-type/update2-v2_0.xml");
        testClassesJar.addAsResource("test/metadata/resource-type/update4-v1_0.xml");
        testClassesJar.addAsResource("test/metadata/resource-type/update4-v2_0.xml");
        testClassesJar.addAsResource("test/metadata/resource-type/updateResourceTypeBundleTarget-v1.xml");
        testClassesJar.addAsResource("test/metadata/resource-type/updateResourceTypeBundleTarget-v2.xml");
        testClassesJar.addAsResource("org/rhq/enterprise/server/plugins/ant/recipe-no-manageRootDir.xml");
        String projectVersion = System.getProperty("project.version");
        MavenResolverSystem earResolver = (MavenResolverSystem)Resolvers.use(MavenResolverSystem.class);
        earResolver.offline();
        EnterpriseArchive testEar = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"rhq.ear");
        EnterpriseArchive rhqEar = (EnterpriseArchive)((MavenFormatStage)((MavenStrategyStage)earResolver.resolve("org.rhq:rhq-enterprise-server-ear:ear:" + projectVersion)).withoutTransitivity()).asSingle(EnterpriseArchive.class);
        testEar = (EnterpriseArchive)testEar.merge((Archive)rhqEar, Filters.include((String)"/lib.*|/rhq.*ejb3\\.jar.*|/rhq-server.jar.*"));
        testEar.delete(ArchivePaths.create((String)"/rhq-server.jar/org/rhq/enterprise/server/core/StartupBean.class"));
        testEar.delete(ArchivePaths.create((String)"/rhq-server.jar/org/rhq/enterprise/server/core/StartupBean$1.class"));
        testEar.delete(ArchivePaths.create((String)"/rhq-server.jar/org/rhq/enterprise/server/core/ShutdownListener.class"));
        testEar.delete(ArchivePaths.create((String)"/rhq-server.jar/org/rhq/enterprise/server/storage/StorageClusterSettingsManagerBean.class"));
        testEar.add((Asset)new ClassAsset(StrippedDownStartupBean.class), ArchivePaths.create((String)"/rhq-server.jar/org/rhq/enterprise/server/test/StrippedDownStartupBean.class"));
        testEar.add((Asset)new ClassAsset(StrippedDownStartupBeanPreparation.class), ArchivePaths.create((String)"/rhq-server.jar/org/rhq/enterprise/server/test/StrippedDownStartupBeanPreparation.class"));
        testEar.add((Asset)new ClassAsset(FakeStorageClusterSettingsManagerBean.class), ArchivePaths.create((String)"/rhq-server.jar/org/rhq/enterprise/server/storage/FakeStorageClusterSettingsManagerBean.class"));
        testEar.addAsManifestResource((Asset)new ByteArrayAsset("<beans/>".getBytes()), ArchivePaths.create((String)"beans.xml"));
        testEar.addAsLibrary((Archive)testClassesJar);
        testEar.addAsManifestResource("jboss-deployment-structure.xml");
        testEar.setApplicationXML("application.xml");
        ArrayList<String> thirdPartyDeps = new ArrayList<String>();
        thirdPartyDeps.add("joda-time:joda-time");
        thirdPartyDeps.add("org.jboss.shrinkwrap:shrinkwrap-impl-base");
        thirdPartyDeps.add("org.liquibase:liquibase-core");
        thirdPartyDeps.add("org.powermock:powermock-api-mockito");
        thirdPartyDeps.add("org.rhq.helpers:perftest-support:" + projectVersion);
        thirdPartyDeps.add("org.rhq:rhq-core-client-api:jar:tests:" + projectVersion);
        thirdPartyDeps.add("org.rhq:test-utils:" + projectVersion);
        MavenResolverSystem resolver = Maven.resolver();
        Collection<JavaArchive> dependencies = new HashSet<JavaArchive>();
        dependencies.addAll(Arrays.asList(((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)resolver.loadPomFromFile("pom.xml")).resolve(thirdPartyDeps)).withTransitivity()).as(JavaArchive.class)));
        if (!Boolean.valueOf(System.getProperty("rhq.skip.oracle")).booleanValue()) {
            resolver.offline();
            dependencies.addAll(Arrays.asList(((MavenFormatStage)((MavenStrategyStage)resolver.resolve("com.oracle:ojdbc6:jar:" + System.getProperty("rhq.ojdbc.version"))).withTransitivity()).as(JavaArchive.class)));
        }
        dependencies.addAll(Arrays.asList(((MavenFormatStage)((MavenStrategyStage)resolver.resolve("commons-jxpath:commons-jxpath:1.3")).withTransitivity()).as(JavaArchive.class)));
        String[] excludeFilters = new String[]{"testng.*jdk", "rhq-core-domain.*jar"};
        dependencies = AbstractEJB3Test.exclude(dependencies, excludeFilters);
        testEar.addAsLibraries(dependencies);
        return testEar;
    }

    private static void exportZip(Archive<?> zipArchive, File outFile) {
        try {
            ZipExporterImpl exporter = new ZipExporterImpl(zipArchive);
            exporter.exportTo(outFile, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Collection<JavaArchive> exclude(Collection<JavaArchive> dependencies, String ... filters) {
        for (String filter : filters) {
            Pattern p = Pattern.compile(filter);
            Iterator<JavaArchive> i = dependencies.iterator();
            while (i.hasNext()) {
                JavaArchive dependency = i.next();
                if (!p.matcher(dependency.getName()).find()) continue;
                i.remove();
            }
        }
        return dependencies;
    }

    public static Collection<JavaArchive> include(Collection<JavaArchive> dependencies, String ... filters) {
        HashSet<JavaArchive> result = new HashSet<JavaArchive>();
        for (String filter : filters) {
            Pattern p = Pattern.compile(filter);
            for (JavaArchive dependency : dependencies) {
                if (!p.matcher(dependency.getName()).find()) continue;
                result.add(dependency);
            }
        }
        return result;
    }

    public static JavaArchive addClasses(JavaArchive archive, File dir, String packageName) {
        packageName = null == packageName ? "" + dir.getName() : packageName + "." + dir.getName();
        for (File file : dir.listFiles()) {
            String fileName = file.getName();
            if (file.isDirectory()) {
                archive = AbstractEJB3Test.addClasses(archive, file, packageName);
                continue;
            }
            if (!fileName.endsWith(".class")) continue;
            int dot = fileName.indexOf(46);
            try {
                archive.addClass(packageName + "." + fileName.substring(0, dot));
            }
            catch (Exception e) {
                System.out.println("WARN: Could not add class:" + e);
            }
        }
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeMethod
    protected void __beforeMethod(Method method) throws Throwable {
        if (this.inContainer()) {
            try {
                if (null == DatabaseTypeFactory.getDefaultDatabaseType()) {
                    Connection conn = null;
                    try {
                        conn = AbstractEJB3Test.getConnection();
                        DatabaseTypeFactory.setDefaultDatabaseType((DatabaseType)DatabaseTypeFactory.getDatabaseType((Connection)conn));
                    }
                    catch (Exception e) {
                        System.err.println("!!! WARNING !!! cannot set default database type, some tests may fail");
                        e.printStackTrace();
                    }
                    finally {
                        if (null != conn) {
                            conn.close();
                        }
                    }
                }
                this.originalServerIdentity = System.getProperty("rhq.server.high-availability.name");
                this.storageClientManager.init();
                this.beforeMethod();
                this.beforeMethod(method);
            }
            catch (Throwable t) {
                System.out.println("BEFORE METHOD FAILURE, TEST DID NOT RUN!!! [" + method.getName() + "]");
                t.printStackTrace();
                throw t;
            }
        }
    }

    @AfterMethod(alwaysRun=true)
    protected void __afterMethod(ITestResult result, Method method) throws Throwable {
        try {
            if (this.inContainer()) {
                if (this.originalServerIdentity != null) {
                    System.setProperty("rhq.server.high-availability.name", this.originalServerIdentity);
                }
                this.afterMethod();
                this.afterMethod(result, method);
            }
        }
        catch (Throwable t) {
            System.out.println("AFTER METHOD FAILURE, TEST CLEAN UP FAILED!!! MAY NEED TO CLEAN DB BEFORE RUNNING MORE TESTS! [" + method.getName() + "]");
            t.printStackTrace();
            throw t;
        }
    }

    protected boolean inContainer() {
        return null != this.initialContext;
    }

    protected void beforeMethod() throws Exception {
    }

    protected void beforeMethod(Method method) throws Exception {
    }

    protected void afterMethod() throws Exception {
    }

    protected void afterMethod(ITestResult result, Method meth) throws Exception {
    }

    protected void setServerIdentity(String name) {
        System.setProperty("rhq.server.high-availability.name", name);
    }

    protected String getServerIdentity() {
        return System.getProperty("rhq.server.high-availability.name");
    }

    protected void startTransaction() throws Exception {
        this.getTransactionManager().begin();
    }

    protected void commitTransaction() throws Exception {
        this.getTransactionManager().commit();
    }

    protected void rollbackTransaction() throws Exception {
        this.getTransactionManager().rollback();
    }

    protected InitialContext getInitialContext() {
        if (null != this.initialContext) {
            return this.initialContext;
        }
        InitialContext result = null;
        try {
            Properties jndiProperties = new Properties();
            jndiProperties.put("java.naming.factory.initial", "org.jboss.as.naming.InitialContextFactory");
            result = new InitialContext(jndiProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get InitialContext", e);
        }
        return result;
    }

    public TransactionManager getTransactionManager() {
        TransactionManager result = null;
        try {
            result = (TransactionManager)this.getInitialContext().lookup("java:jboss/TransactionManager");
            if (null == result) {
                result = (TransactionManager)this.getInitialContext().lookup("TransactionManager");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get TransactionManager", e);
        }
        return result;
    }

    protected EntityManager getEntityManager() {
        if (null != this.em) {
            return this.em;
        }
        EntityManager result = null;
        try {
            EntityManagerFactory emf = (EntityManagerFactory)this.getInitialContext().lookup("java:jboss/RHQEntityManagerFactory");
            result = emf.createEntityManager();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get EntityManagerFactory", e);
        }
        return result;
    }

    protected void executeInTransaction(TransactionCallback callback) {
        this.executeInTransaction(true, callback);
    }

    protected void executeInTransaction(boolean rollback, final TransactionCallback callback) {
        this.executeInTransaction(rollback, new TransactionCallbackReturnable<Void>(){

            @Override
            public Void execute() throws Exception {
                callback.execute();
                return null;
            }
        });
    }

    protected <T> T executeInTransaction(TransactionCallbackReturnable<T> callback) {
        return this.executeInTransaction(true, callback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T executeInTransaction(boolean rollback, TransactionCallbackReturnable<T> callback) {
        T t;
        try {
            T result;
            this.startTransaction();
            t = result = callback.execute();
        }
        catch (Throwable t2) {
            try {
                rollback = true;
                RuntimeException re = new RuntimeException(ThrowableUtil.getAllMessages((Throwable)t2), t2);
                throw re;
            }
            catch (Throwable throwable) {
                try {
                    if (!rollback) {
                        this.commitTransaction();
                        throw throwable;
                    }
                    this.rollbackTransaction();
                    throw throwable;
                }
                catch (Exception e) {
                    String string;
                    StringBuilder stringBuilder = new StringBuilder().append("Failed to ");
                    if (rollback) {
                        string = "rollback";
                        throw new RuntimeException(stringBuilder.append(string).append(" transaction").toString(), e);
                    }
                    string = "commit";
                    throw new RuntimeException(stringBuilder.append(string).append(" transaction").toString(), e);
                }
            }
        }
        try {
            if (!rollback) {
                this.commitTransaction();
                return t;
            }
            this.rollbackTransaction();
            return t;
        }
        catch (Exception e) {
            String string;
            StringBuilder stringBuilder = new StringBuilder().append("Failed to ");
            if (rollback) {
                string = "rollback";
                throw new RuntimeException(stringBuilder.append(string).append(" transaction").toString(), e);
            }
            string = "commit";
            throw new RuntimeException(stringBuilder.append(string).append(" transaction").toString(), e);
        }
    }

    protected void assertNotNull(Object o) {
        AssertJUnit.assertNotNull((Object)o);
    }

    protected void assertNotNull(String msg, Object o) {
        AssertJUnit.assertNotNull((String)msg, (Object)o);
    }

    protected void assertNull(Object o) {
        AssertJUnit.assertNull((Object)o);
    }

    protected void assertNull(String msg, Object o) {
        AssertJUnit.assertNull((String)msg, (Object)o);
    }

    protected void assertFalse(boolean b) {
        AssertJUnit.assertFalse((boolean)b);
    }

    protected void assertFalse(String msg, boolean b) {
        AssertJUnit.assertFalse((String)msg, (boolean)b);
    }

    protected void assertTrue(boolean b) {
        AssertJUnit.assertTrue((boolean)b);
    }

    protected void assertTrue(String msg, boolean b) {
        AssertJUnit.assertTrue((String)msg, (boolean)b);
    }

    protected void assertEquals(int expected, int actual) {
        AssertJUnit.assertEquals((int)expected, (int)actual);
    }

    protected void assertEquals(String msg, int expected, int actual) {
        AssertJUnit.assertEquals((String)msg, (int)expected, (int)actual);
    }

    protected void assertEquals(long expected, long actual) {
        AssertJUnit.assertEquals((long)expected, (long)actual);
    }

    protected void assertEquals(String msg, long expected, long actual) {
        AssertJUnit.assertEquals((String)msg, (long)expected, (long)actual);
    }

    protected void assertEquals(String expected, String actual) {
        AssertJUnit.assertEquals((String)expected, (String)actual);
    }

    protected void assertEquals(String msg, String expected, String actual) {
        AssertJUnit.assertEquals((String)msg, (String)expected, (String)actual);
    }

    protected void assertEquals(boolean expected, boolean actual) {
        AssertJUnit.assertEquals((boolean)expected, (boolean)actual);
    }

    protected void assertEquals(String msg, boolean expected, boolean actual) {
        AssertJUnit.assertEquals((String)msg, (boolean)expected, (boolean)actual);
    }

    protected void assertEquals(Object expected, Object actual) {
        AssertJUnit.assertEquals((Object)expected, (Object)actual);
    }

    protected void assertEquals(String msg, Object expected, Object actual) {
        AssertJUnit.assertEquals((String)msg, (Object)expected, (Object)actual);
    }

    protected void fail() {
        AssertJUnit.fail();
    }

    protected void fail(String message) {
        AssertJUnit.fail((String)message);
    }

    public void prepareCustomServerService(Object testServiceMBean, String objectNameStr) {
        try {
            ObjectName objectName = new ObjectName(objectNameStr);
            this.prepareCustomServerService(testServiceMBean, objectName);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public void prepareCustomServerService(Object testServiceMBean, ObjectName objectName) {
        try {
            MBeanServer mbs = this.getPlatformMBeanServer();
            if (mbs.isRegistered(objectName)) {
                mbs.unregisterMBean(objectName);
            }
            mbs.registerMBean(testServiceMBean, objectName);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void unprepareCustomServerService(String objectNameStr) throws Exception {
        ObjectName objectName = new ObjectName(objectNameStr);
        this.unprepareCustomServerService(objectName);
    }

    public void unprepareCustomServerService(ObjectName objectName) throws Exception {
        MBeanServer mbs = this.getPlatformMBeanServer();
        if (mbs.isRegistered(objectName)) {
            mbs.unregisterMBean(objectName);
        }
    }

    public void prepareCustomServerPluginService(ServerPluginService testServiceMBean) {
        try {
            MBeanServer mbs = this.getPlatformMBeanServer();
            if (mbs.isRegistered(ServerPluginService.OBJECT_NAME)) {
                mbs.unregisterMBean(ServerPluginService.OBJECT_NAME);
            }
            testServiceMBean.start();
            mbs.registerMBean(testServiceMBean, ServerPluginServiceMBean.OBJECT_NAME);
            this.serverPluginService = testServiceMBean;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void unprepareServerPluginService() throws Exception {
        MBeanServer mbs;
        if (this.serverPluginService != null) {
            this.serverPluginService.stopMasterPluginContainer();
            this.serverPluginService.stop();
            this.serverPluginService = null;
        }
        if ((mbs = this.getPlatformMBeanServer()).isRegistered(ServerPluginService.OBJECT_NAME)) {
            mbs.unregisterMBean(ServerPluginService.OBJECT_NAME);
        }
    }

    public SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    public void prepareScheduler() {
        try {
            if (this.schedulerService != null) {
                return;
            }
            MBeanServer mbs = this.getPlatformMBeanServer();
            if (mbs.isRegistered(SchedulerService.SCHEDULER_MBEAN_NAME)) {
                mbs.unregisterMBean(SchedulerService.SCHEDULER_MBEAN_NAME);
            }
            Properties quartzProps = new Properties();
            quartzProps.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("test-scheduler.properties"));
            this.schedulerService = new SchedulerService();
            this.schedulerService.setQuartzProperties(quartzProps);
            this.schedulerService.start();
            mbs.registerMBean(this.schedulerService, SchedulerServiceMBean.SCHEDULER_MBEAN_NAME);
            this.schedulerService.startQuartzScheduler();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void unprepareScheduler() throws Exception {
        MBeanServer mbs;
        if (this.schedulerService != null) {
            this.schedulerService.stop();
            this.schedulerService = null;
        }
        if ((mbs = this.getPlatformMBeanServer()).isRegistered(SchedulerService.SCHEDULER_MBEAN_NAME)) {
            mbs.unregisterMBean(SchedulerService.SCHEDULER_MBEAN_NAME);
        }
    }

    public TestServerCommunicationsService prepareForTestAgents() {
        if (this.agentService != null) {
            return this.agentService;
        }
        return this.prepareForTestAgents(new TestServerCommunicationsService());
    }

    public TestServerCommunicationsService prepareForTestAgents(TestServerCommunicationsServiceMBean customAgentService) {
        try {
            if (this.agentService != null) {
                return this.agentService;
            }
            MBeanServer mbs = this.getPlatformMBeanServer();
            if (mbs.isRegistered(ServerCommunicationsServiceMBean.OBJECT_NAME)) {
                mbs.unregisterMBean(ServerCommunicationsServiceMBean.OBJECT_NAME);
            }
            this.agentService = (TestServerCommunicationsService)customAgentService;
            mbs.registerMBean(this.agentService, ServerCommunicationsServiceMBean.OBJECT_NAME);
            return this.agentService;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void unprepareForTestAgents() {
        try {
            MBeanServer mbs;
            if (this.agentService != null) {
                this.agentService.stop();
                this.agentService = null;
            }
            if ((mbs = this.getPlatformMBeanServer()).isRegistered(ServerCommunicationsServiceMBean.OBJECT_NAME)) {
                mbs.unregisterMBean(ServerCommunicationsServiceMBean.OBJECT_NAME);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PluginDeploymentScannerMBean getPluginScannerService() {
        return this.pluginScannerService;
    }

    protected PluginDeploymentScannerMBean preparePluginScannerService() {
        if (null != this.pluginScannerService) {
            return this.pluginScannerService;
        }
        PluginDeploymentScanner scanner = new PluginDeploymentScanner();
        String pluginDirPath = this.getTempDir() + "/plugins";
        scanner.setAgentPluginDir(pluginDirPath);
        scanner.setServerPluginDir("ignore no plugins here");
        scanner.setUserPluginDir("ignore no plugins here");
        scanner.setScanPeriod("9999999");
        return this.preparePluginScannerService((PluginDeploymentScannerMBean)scanner);
    }

    public PluginDeploymentScannerMBean preparePluginScannerService(PluginDeploymentScannerMBean scannerService) {
        try {
            MBeanServer mbs = this.getPlatformMBeanServer();
            if (mbs.isRegistered(PluginDeploymentScannerMBean.OBJECT_NAME)) {
                mbs.unregisterMBean(PluginDeploymentScannerMBean.OBJECT_NAME);
            }
            mbs.registerMBean(scannerService, PluginDeploymentScannerMBean.OBJECT_NAME);
            this.pluginScannerService = scannerService;
            this.pluginScannerService.start();
            return this.pluginScannerService;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void unpreparePluginScannerService() throws Exception {
        MBeanServer mbs;
        if (this.pluginScannerService != null) {
            this.pluginScannerService.stop();
            this.pluginScannerService = null;
        }
        if ((mbs = this.getPlatformMBeanServer()).isRegistered(PluginDeploymentScannerMBean.OBJECT_NAME)) {
            mbs.unregisterMBean(PluginDeploymentScannerMBean.OBJECT_NAME);
        }
    }

    public MBeanServer getPlatformMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    public Subject createSession(Subject subject) {
        return SessionManager.getInstance().put(subject);
    }

    public static Connection getConnection() throws SQLException {
        return LookupUtil.getDataSource().getConnection();
    }

    protected void writeObjects(String filename, Object ... objects) throws Exception {
        File file = new File(this.getTempDir(), filename);
        file.delete();
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
        for (Object o : objects) {
            oos.writeObject(o);
        }
        oos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Object> readObjects(String filename, int numObjects) throws Exception {
        ArrayList<Object> result = new ArrayList<Object>();
        ObjectInputStream ois = null;
        try {
            File file = new File(this.getTempDir(), filename);
            ois = new ObjectInputStream(new FileInputStream(file));
            for (int i = 0; i < numObjects; ++i) {
                result.add(ois.readObject());
            }
        }
        finally {
            ois.close();
        }
        return result;
    }

    protected boolean deleteObjects(String filename) {
        File file = new File(this.getTempDir(), filename);
        return file.delete();
    }

    public File getTempDir() {
        return new File(tmpdirRoot, ((Object)((Object)this)).getClass().getSimpleName());
    }

    protected void ackDeletedPlugins() {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        PluginManagerLocal pluginMgr = LookupUtil.getPluginManager();
        for (Server server : LookupUtil.getTopologyManager().findServersByCriteria(overlord, new ServerCriteria())) {
            pluginMgr.acknowledgeDeletedPluginsBy(server.getId());
        }
    }
}

