/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.cloud.StorageNode;
import org.rhq.enterprise.server.cloud.instance.ServerManagerLocal;
import org.rhq.enterprise.server.test.StrippedDownStartupBean;

@Singleton
@Startup
public class StrippedDownStartupBeanPreparation {
    private Log log = LogFactory.getLog(this.getClass());
    @EJB
    private StrippedDownStartupBean startupBean;
    @EJB
    private ServerManagerLocal serverManager;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource
    private TimerService timerService;

    @PostConstruct
    public void initWithTransactionBecauseAS75530() throws RuntimeException {
        this.log.info((Object)"Scheduling the initialization of the testing RHQ deployment");
        this.timerService.createSingleActionTimer(1L, new TimerConfig(null, false));
        this.startupBean.purgeTestServerAndStorageNodes();
        this.createTestServer();
        this.loadCassandraConnectionProps();
        this.createStorageNodes();
    }

    private void createTestServer() {
        Server server = new Server();
        server.setName("rhq-test-server");
        server.setAddress("127.0.0.1");
        server.setOperationMode(Server.OperationMode.INSTALLED);
        server.setPort(7080);
        server.setSecurePort(7443);
        this.serverManager.create(server);
        System.setProperty("rhq.server.high-availability.name", "rhq-test-server");
    }

    private void createStorageNodes() {
        String[] nodes = System.getProperty("rhq.storage.nodes").split(",");
        String cqlPort = System.getProperty("rhq.storage.cql-port");
        for (String node : nodes) {
            StorageNode storageNode = new StorageNode();
            storageNode.setAddress(node);
            storageNode.setCqlPort(Integer.parseInt(cqlPort));
            storageNode.setOperationMode(StorageNode.OperationMode.NORMAL);
            this.entityManager.persist((Object)storageNode);
        }
    }

    public void loadCassandraConnectionProps() {
        InputStream stream = null;
        try {
            stream = this.getClass().getResourceAsStream("/cassandra-test.properties");
            Properties props = new Properties();
            props.load(stream);
            System.setProperty("rhq.storage.username", props.getProperty("rhq.storage.username"));
            System.setProperty("rhq.storage.password", props.getProperty("rhq.storage.password"));
            System.setProperty("rhq.storage.nodes", props.getProperty("rhq.storage.nodes"));
            System.setProperty("rhq.storage.cql-port", props.getProperty("rhq.storage.cql-port"));
            System.setProperty("rhq.storage.gossip-port", props.getProperty("rhq.storage.gossip-port"));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load cassandra-test.properties");
        }
        String cqlPort = System.getProperty("rhq.storage.cql-port");
        this.entityManager.createNativeQuery("update rhq_system_config set property_value = '" + cqlPort + "', default_property_value = '" + cqlPort + "' where property_key = 'STORAGE_CQL_PORT'").executeUpdate();
        String gossipPort = System.getProperty("rhq.storage.gossip-port");
        this.entityManager.createNativeQuery("update rhq_system_config set property_value = '" + gossipPort + "', default_property_value = '" + gossipPort + "' where property_key = 'STORAGE_GOSSIP_PORT'").executeUpdate();
        String storageUserName = System.getProperty("rhq.storage.username");
        this.entityManager.createNativeQuery("update rhq_system_config set property_value = '" + storageUserName + "', default_property_value = '" + storageUserName + "' where property_key = 'STORAGE_USERNAME'").executeUpdate();
        String storagePassword = System.getProperty("rhq.storage.password");
        this.entityManager.createNativeQuery("update rhq_system_config set property_value = '" + storagePassword + "', default_property_value = '" + storagePassword + "' where property_key = 'STORAGE_PASSWORD'").executeUpdate();
    }

    @Timeout
    public void initializeServer() throws RuntimeException {
        try {
            this.log.info((Object)"Initializing the testing RHQ deployment");
            this.startupBean.init();
            this.log.info((Object)"Initialization complete");
        }
        catch (Throwable t) {
            this.log.fatal((Object)"The server failed to start up properly", t);
        }
    }
}

