/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.exception.LiquibaseException;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.helper.ProjectHelper2;
import org.rhq.core.db.setup.DBSetup;
import org.rhq.enterprise.server.test.AbstractEJB3Test;
import org.rhq.enterprise.server.util.LoggerAntBuildListener;

public class DbSetupUtility {
    public static final String JON300_SCHEMA_VERSION = "2.116";
    private static final String BASE_RESOURCE_PATH = DbSetupUtility.class.getPackage().getName().replace('.', '/');
    private static TestDatasourceConfiguration testDsConfig;

    private static TestDatasourceConfiguration getTestDatasourceConfiguration() {
        if (testDsConfig == null) {
            Properties testDsProperties = new Properties();
            InputStream resourceAsStream = DbSetupUtility.class.getResourceAsStream("test-ds.properties");
            try {
                testDsProperties.load(resourceAsStream);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load test-ds.properties from classloader.", e);
            }
            testDsConfig = new TestDatasourceConfiguration(testDsProperties);
            System.out.println("Using test datasource with config " + testDsConfig + "...");
        }
        return testDsConfig;
    }

    public static void dbreset() throws Exception {
        TestDatasourceConfiguration testDs = DbSetupUtility.getTestDatasourceConfiguration();
        System.out.println("Resetting DB at " + testDs.connectionUrl + "...");
        String dbDriver = DatabaseFactory.getInstance().findDefaultDriver(testDs.connectionUrl);
        Database database = CommandLineUtils.createDatabaseObject((ClassLoader)DbSetupUtility.class.getClassLoader(), (String)testDs.connectionUrl, (String)testDs.userName, (String)testDs.password, (String)dbDriver, null, null, null);
        Liquibase liquibase = new Liquibase(null, (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
        liquibase.dropAll();
        DbSetupUtility.dropRhqCalltimeDataKeyTable(database);
    }

    public static void dbsetup() throws Exception {
        DbSetupUtility.dbsetup(null);
    }

    public static void dbsetup(String jonVersion) throws Exception {
        String dataFileResourcePath;
        String schemaFileResourcePath;
        if (jonVersion != null) {
            System.out.println("Installing new RHQ DB with schema from JON version [" + jonVersion + "]...");
            schemaFileResourcePath = BASE_RESOURCE_PATH + "/" + "db-schema-combined-" + jonVersion + ".xml";
            dataFileResourcePath = BASE_RESOURCE_PATH + "/" + "db-data-combined-" + jonVersion + ".xml";
        } else {
            System.out.println("Installing new RHQ DB with latest schema version...");
            schemaFileResourcePath = "db-schema-combined.xml";
            dataFileResourcePath = "db-data-combined.xml";
        }
        TestDatasourceConfiguration testDs = DbSetupUtility.getTestDatasourceConfiguration();
        DBSetup dbsetup = new DBSetup(testDs.connectionUrl, testDs.userName, testDs.password);
        dbsetup.setup(schemaFileResourcePath);
        dbsetup.setup(dataFileResourcePath);
    }

    public static void dbupgrade(String targetSchemaVersion) throws Exception {
        System.out.println("Upgrading RHQ DB to schema version [" + targetSchemaVersion + "]...");
        File logfile = File.createTempFile("rhq.test", "dbupgrade.log");
        TestDatasourceConfiguration testDs = DbSetupUtility.getTestDatasourceConfiguration();
        try {
            URL dbupgradeXmlFileUrl = DbSetupUtility.class.getClassLoader().getResource("db-upgrade.xml");
            Properties antProps = new Properties();
            antProps.setProperty("jdbc.url", testDs.connectionUrl);
            antProps.setProperty("jdbc.user", testDs.userName);
            antProps.setProperty("jdbc.password", testDs.password);
            antProps.setProperty("target.schema.version", targetSchemaVersion);
            DbSetupUtility.startAnt(dbupgradeXmlFileUrl, "db-ant-tasks.properties", antProps, logfile);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot upgrade the RHQ DB at [" + testDs.connectionUrl + "] to schema version [" + targetSchemaVersion + "].", e);
        }
    }

    private static void dropRhqCalltimeDataKeyTable(Database database) throws LiquibaseException {
        System.out.println("Dropping rhq_calltime_data_key table...");
        try {
            PreparedStatement statement = AbstractEJB3Test.getConnection().prepareStatement("DROP TABLE rhq_calltime_data_key");
            statement.execute();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startAnt(URL buildFile, String customTaskDefs, Properties properties, File logFile) {
        PrintWriter logFileOutput = null;
        try {
            logFileOutput = new PrintWriter(new FileOutputStream(logFile));
            ClassLoader classLoader = DbSetupUtility.class.getClassLoader();
            Properties taskDefs = new Properties();
            InputStream taskDefsStream = classLoader.getResourceAsStream(customTaskDefs);
            try {
                taskDefs.load(taskDefsStream);
            }
            finally {
                taskDefsStream.close();
            }
            Project project = new Project();
            project.setCoreLoader(classLoader);
            project.init();
            for (Map.Entry<Object, Object> property : properties.entrySet()) {
                project.setProperty(property.getKey().toString(), property.getValue().toString());
            }
            project.addBuildListener((BuildListener)new LoggerAntBuildListener(logFileOutput));
            for (Map.Entry<Object, Object> taskDef : taskDefs.entrySet()) {
                project.addTaskDefinition(taskDef.getKey().toString(), Class.forName(taskDef.getValue().toString(), true, classLoader));
            }
            new ProjectHelper2().parse(project, (Object)buildFile);
            project.executeTarget(project.getDefaultTarget());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot run Ant on script [" + buildFile + "] - cause: " + e, e);
        }
        finally {
            if (logFileOutput != null) {
                logFileOutput.close();
            }
        }
    }

    private static class TestDatasourceConfiguration {
        String connectionUrl;
        String serverName;
        String dbName;
        String userName;
        String password;

        private TestDatasourceConfiguration(Properties props) {
            this.connectionUrl = props.getProperty("rhq.test.ds.connection-url");
            this.serverName = props.getProperty("rhq.test.ds.server-name");
            this.dbName = props.getProperty("rhq.test.ds.db-name");
            this.userName = props.getProperty("rhq.test.ds.user-name");
            this.password = props.getProperty("rhq.test.ds.password");
        }

        public String toString() {
            return "{connectionUrl='" + this.connectionUrl + '\'' + ", serverName='" + this.serverName + '\'' + ", dbName='" + this.dbName + '\'' + ", userName='" + this.userName + '\'' + '}';
        }

        abstract class Property {
            public static final String DB_CONNECTION_URL = "rhq.test.ds.connection-url";
            public static final String DB_SERVER_NAME = "rhq.test.ds.server-name";
            public static final String DB_NAME = "rhq.test.ds.db-name";
            public static final String DB_USER_NAME = "rhq.test.ds.user-name";
            public static final String DB_PASSWORD = "rhq.test.ds.password";

            Property() {
            }
        }
    }
}

