/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.EntityManager;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.ResourceAvailability;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.server.auth.SessionManager;

public class SessionTestHelper {
    private static AtomicInteger idGenerator = new AtomicInteger(0);

    public static boolean samePermissions(Set<Permission> one, Set<Permission> two) {
        return one.containsAll(two) && two.containsAll(one);
    }

    public static Set<Permission> getAllGlobalPerms() {
        Permission[] allPermissions = Permission.values();
        EnumSet<Permission> globalPermissions = EnumSet.noneOf(Permission.class);
        for (Permission permission : allPermissions) {
            if (permission.getTarget() != Permission.Target.GLOBAL) continue;
            globalPermissions.add(permission);
        }
        return globalPermissions;
    }

    public static Set<Permission> getAllResourcePerms() {
        Permission[] allPermissions = Permission.values();
        EnumSet<Permission> globalPermissions = EnumSet.noneOf(Permission.class);
        for (Permission permission : allPermissions) {
            if (permission.getTarget() != Permission.Target.RESOURCE) continue;
            globalPermissions.add(permission);
        }
        return globalPermissions;
    }

    public static Subject createNewSubject(EntityManager em, String subjectName) {
        subjectName = SessionTestHelper.preprocess(subjectName);
        Subject newSubject = new Subject();
        newSubject.setName(subjectName);
        newSubject.setFactive(true);
        newSubject.setFsystem(false);
        em.persist((Object)newSubject);
        em.flush();
        Subject sessionSubject = SessionManager.getInstance().put(newSubject, 600000L);
        newSubject.setSessionId(sessionSubject.getSessionId());
        return newSubject;
    }

    public static void simulateLogin(Subject subject) {
        Subject sessionSubject = SessionManager.getInstance().put(subject, 600000L);
        subject.setSessionId(sessionSubject.getSessionId());
    }

    public static void simulateLogout(Subject subject) {
        Integer sessionId = subject.getSessionId();
        if (sessionId != null) {
            SessionManager.getInstance().invalidate(sessionId.intValue());
        }
    }

    public static Role createNewRoleForSubject(EntityManager em, Subject subject, String roleName) {
        return SessionTestHelper.createNewRoleForSubject(em, subject, roleName, new Permission[0]);
    }

    public static Role createNewRoleForSubject(EntityManager em, Subject subject, String roleName, Permission ... permissions) {
        roleName = SessionTestHelper.preprocess(roleName);
        Role newRole = new Role(roleName);
        newRole.setFsystem(Boolean.valueOf(false));
        for (Permission perm : permissions) {
            newRole.addPermission(perm);
        }
        subject.getRoles().add(newRole);
        newRole.getSubjects().add(subject);
        em.persist((Object)subject);
        em.persist((Object)newRole);
        em.flush();
        return newRole;
    }

    public static void addRolePermissions(EntityManager em, Role role, Permission ... permissions) {
        role.getPermissions().addAll(Arrays.asList(permissions));
        em.merge((Object)role);
        em.flush();
    }

    public static void removeRolePermissions(EntityManager em, Role role, Permission ... permissions) {
        role.getPermissions().removeAll(Arrays.asList(permissions));
        em.merge((Object)role);
        em.flush();
    }

    public static ResourceType createNewResourceType(EntityManager em) {
        ResourceType type = new ResourceType(SessionTestHelper.preprocess("testType"), "testPlugin", ResourceCategory.PLATFORM, null);
        ConfigurationDefinition resourceConfigDef = new ConfigurationDefinition("Fake resconfig def", "Resource config def for fake test resource");
        resourceConfigDef.put((PropertyDefinition)new PropertyDefinitionSimple("fake", "fake property", false, PropertySimpleType.BOOLEAN));
        resourceConfigDef.put((PropertyDefinition)new PropertyDefinitionSimple("fakeReadOnly", "fake readonly property", false, PropertySimpleType.BOOLEAN));
        ((PropertyDefinition)resourceConfigDef.getPropertyDefinitions().get("fakeReadOnly")).setReadOnly(true);
        type.setResourceConfigurationDefinition(resourceConfigDef);
        ConfigurationDefinition pluginConfigDef = new ConfigurationDefinition("Fake pluginconfig def", "Plugin config def for fake test resource");
        pluginConfigDef.put((PropertyDefinition)new PropertyDefinitionSimple("fake", "fake property", false, PropertySimpleType.BOOLEAN));
        pluginConfigDef.put((PropertyDefinition)new PropertyDefinitionSimple("fakeReadOnly", "fake readonly property", false, PropertySimpleType.BOOLEAN));
        ((PropertyDefinition)pluginConfigDef.getPropertyDefinitions().get("fakeReadOnly")).setReadOnly(true);
        type.setPluginConfigurationDefinition(pluginConfigDef);
        em.persist((Object)type);
        em.flush();
        return type;
    }

    public static ResourceGroup createNewCompatibleGroupForRole(EntityManager em, Role role, String groupName) {
        return SessionTestHelper.createNewCompatibleGroupForRole(em, role, groupName, null);
    }

    public static ResourceGroup createNewCompatibleGroupForRole(EntityManager em, Role role, String groupName, ResourceType type) {
        if (type == null) {
            type = SessionTestHelper.createNewResourceType(em);
        }
        return SessionTestHelper.createNewGroupForRoleHelper(em, role, groupName, type, false);
    }

    public static ResourceGroup createNewMixedGroupForRole(EntityManager em, Role role, String groupName, boolean recursive) {
        return SessionTestHelper.createNewGroupForRoleHelper(em, role, groupName, null, recursive);
    }

    private static ResourceGroup createNewGroupForRoleHelper(EntityManager em, Role role, String groupName, ResourceType type, boolean recursive) {
        ResourceGroup newGroup = null;
        groupName = SessionTestHelper.preprocess(groupName);
        if (type == null) {
            newGroup = new ResourceGroup(groupName);
            newGroup.setRecursive(recursive);
        } else {
            newGroup = new ResourceGroup(groupName, type);
        }
        if (role != null) {
            role.getResourceGroups().add(newGroup);
            newGroup.addRole(role);
            em.persist((Object)role);
        }
        em.persist((Object)newGroup);
        em.flush();
        return newGroup;
    }

    public static Resource createNewResourceForGroup(EntityManager em, ResourceGroup group, String resourceName) {
        ResourceType type = group.getResourceType();
        return SessionTestHelper.createNewResourceForGroup(em, group, resourceName, type, true);
    }

    public static Resource createNewResourceForGroup(EntityManager em, ResourceGroup group, String resourceName, ResourceType type, boolean doFlush) {
        return SessionTestHelper.createNewResourceForGroup(em, group, resourceName, type, AvailabilityType.UP, doFlush);
    }

    public static Resource createNewResourceForGroup(EntityManager em, ResourceGroup group, String resourceName, ResourceType type, AvailabilityType avail, boolean doFlush) {
        if (type == null) {
            type = SessionTestHelper.createNewResourceType(em);
        }
        resourceName = SessionTestHelper.preprocess(resourceName);
        Resource resource = new Resource(resourceName, resourceName, type);
        resource.setUuid("" + new Random().nextInt());
        resource.setInventoryStatus(InventoryStatus.COMMITTED);
        resource.initCurrentAvailability();
        resource.setCurrentAvailability(new ResourceAvailability(resource, avail));
        resource.getAvailability().clear();
        resource.getAvailability().add(new Availability(resource, Long.valueOf(0L), avail));
        group.addExplicitResource(resource);
        resource.getExplicitGroups().add(group);
        group.addImplicitResource(resource);
        resource.getImplicitGroups().add(group);
        em.persist((Object)resource);
        if (doFlush) {
            em.flush();
        }
        return resource;
    }

    public static Agent createNewAgent(EntityManager em, String agentName) {
        agentName = SessionTestHelper.preprocess(agentName);
        String address = SessionTestHelper.preprocess("localhost");
        int port = 16163;
        String endPoint = "socket://" + address + ":" + port + "/?rhq.communications.connector.rhqtype=agent";
        Agent agent = new Agent(agentName, address, port, endPoint, agentName);
        em.persist((Object)agent);
        em.flush();
        return agent;
    }

    public static Resource createNewResource(EntityManager em, String resourceName) {
        return SessionTestHelper.createNewResource(em, resourceName, null);
    }

    public static Resource createNewResource(EntityManager em, String resourceName, ResourceType type) {
        if (type == null) {
            type = new ResourceType(SessionTestHelper.preprocess("testType"), "testPlugin", ResourceCategory.PLATFORM, null);
            em.persist((Object)type);
        }
        resourceName = SessionTestHelper.preprocess(resourceName);
        Resource resource = new Resource(resourceName, resourceName, type);
        resource.setUuid("" + new Random().nextInt());
        resource.setInventoryStatus(InventoryStatus.COMMITTED);
        resource.setCurrentAvailability(new ResourceAvailability(resource, AvailabilityType.UP));
        em.persist((Object)resource);
        em.flush();
        return resource;
    }

    public static Collection<Integer> getResourceList(Resource ... resources) {
        ArrayList<Integer> resourceIdList = new ArrayList<Integer>(resources.length + 1);
        for (Resource resource : resources) {
            resourceIdList.add(resource.getId());
        }
        return resourceIdList;
    }

    private static String preprocess(String name) {
        name = name + System.currentTimeMillis() + "-" + idGenerator.getAndIncrement();
        return name;
    }
}

