/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.server.metrics.invalid;

import com.google.common.base.Objects;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.rhq.server.metrics.domain.AggregateNumericMetric;

class InvalidMetric
implements Delayed {
    public DateTime day;
    public AggregateNumericMetric metric;
    private long delay;
    private long ctime;

    private static int compareInts(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public InvalidMetric(DateTime day, AggregateNumericMetric metric, long delay) {
        this.day = day;
        this.metric = metric;
        this.delay = delay;
        this.ctime = System.currentTimeMillis();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.delay - (System.currentTimeMillis() - this.ctime), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed other) {
        long thatDelay;
        if (this == other) {
            return 0;
        }
        InvalidMetric that = (InvalidMetric)other;
        long thisDelay = this.getDelay(TimeUnit.MILLISECONDS);
        if (thisDelay < (thatDelay = that.getDelay(TimeUnit.MILLISECONDS))) {
            return -1;
        }
        if (thisDelay > thatDelay) {
            return 1;
        }
        if (this.day.compareTo((ReadableInstant)that.day) < 0) {
            return -1;
        }
        if (this.day.compareTo((ReadableInstant)that.day) > 0) {
            return 1;
        }
        return InvalidMetric.compareInts(this.metric.getScheduleId(), that.metric.getScheduleId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvalidMetric that = (InvalidMetric)o;
        if (this.metric.getScheduleId() != that.metric.getScheduleId()) {
            return false;
        }
        return this.day.equals((Object)that.day);
    }

    public int hashCode() {
        int result = this.day.hashCode();
        result = 31 * result + this.metric.getScheduleId();
        return result;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("type", (Object)this.getDisplayType()).add("scheduleId", this.metric.getScheduleId()).add("timestamp", this.metric.getTimestamp()).add("max", (Object)this.metric.getMax()).add("min", (Object)this.metric.getMin()).add("avg", (Object)this.metric.getAvg()).toString();
    }

    private String getDisplayType() {
        switch (this.metric.getBucket()) {
            case ONE_HOUR: {
                return "1 hour";
            }
            case SIX_HOUR: {
                return "6 hour";
            }
        }
        return "24 hour";
    }
}

