/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.ant;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bundle.ant.AntLauncher;
import org.rhq.bundle.ant.BundleAntProject;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.core.util.updater.DeploymentProperties;
import org.rhq.enterprise.server.bundle.RecipeParseResults;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginContext;
import org.rhq.enterprise.server.plugin.pc.bundle.BundleServerPluginFacet;

public class AntBundleServerPluginComponent
implements ServerPluginComponent,
BundleServerPluginFacet {
    private final Log log = LogFactory.getLog(AntBundleServerPluginComponent.class);
    private ServerPluginContext context;
    private File tmpDirectory;

    public void initialize(ServerPluginContext context) throws Exception {
        this.context = context;
        this.tmpDirectory = new File(this.context.getTemporaryDirectory(), "ant-bundle-server-plugin");
        this.tmpDirectory.mkdirs();
        if (!this.tmpDirectory.exists() || !this.tmpDirectory.isDirectory()) {
            throw new Exception("Failed to create tmp dir [" + this.tmpDirectory + "] - cannot process ant bundles");
        }
        this.log.debug((Object)("The ant bundle plugin has been initialized: " + this));
    }

    public void start() {
        this.log.debug((Object)("The ant bundle plugin has started: " + this));
    }

    public void stop() {
        this.log.debug((Object)("The ant bundle plugin has stopped: " + this));
    }

    public void shutdown() {
        this.log.debug((Object)("The ant bundle plugin has been shut down: " + this));
    }

    public RecipeParseResults parseRecipe(String recipe) throws Exception {
        ConfigurationDefinition configDef;
        Set bundleFiles;
        DeploymentProperties deploymentProps;
        File recipeFile = File.createTempFile("ant-bundle-recipe", ".xml", this.tmpDirectory);
        File logFile = File.createTempFile("ant-bundle-recipe", ".log", this.tmpDirectory);
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(recipe.getBytes());
            FileOutputStream out = new FileOutputStream(recipeFile);
            StreamUtil.copy((InputStream)in, (OutputStream)out);
            AntLauncher antLauncher = new AntLauncher();
            BundleAntProject project = antLauncher.startAnt(recipeFile, null, null, null, logFile, false, false);
            deploymentProps = new DeploymentProperties(0, project.getBundleName(), project.getBundleVersion(), project.getBundleDescription());
            bundleFiles = project.getBundleFileNames();
            configDef = project.getConfigurationDefinition();
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                try {
                    this.log.debug((Object)new String(StreamUtil.slurp((InputStream)new FileInputStream(logFile))));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw new Exception("Failed to parse the bundle Ant script.", t);
        }
        finally {
            recipeFile.delete();
            logFile.delete();
        }
        RecipeParseResults results = new RecipeParseResults(deploymentProps, configDef, bundleFiles);
        return results;
    }

    public String toString() {
        if (this.context == null) {
            return "<no context>";
        }
        StringBuilder str = new StringBuilder();
        str.append("plugin-key=").append(this.context.getPluginEnvironment().getPluginKey()).append(",");
        str.append("plugin-url=").append(this.context.getPluginEnvironment().getPluginUrl());
        return str.toString();
    }
}

