/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.ant;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bundle.ant.AntLauncher;
import org.rhq.bundle.ant.BundleAntProject;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.core.util.updater.DeploymentProperties;
import org.rhq.enterprise.server.bundle.BundleDistributionInfo;
import org.rhq.enterprise.server.bundle.RecipeParseResults;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginContext;
import org.rhq.enterprise.server.plugin.pc.bundle.BundleServerPluginFacet;
import org.rhq.enterprise.server.plugin.pc.bundle.UnknownRecipeException;

public class AntBundleServerPluginComponent
implements ServerPluginComponent,
BundleServerPluginFacet {
    private static final Log LOG = LogFactory.getLog(AntBundleServerPluginComponent.class);
    private ServerPluginContext context;
    private File tmpDirectory;

    public void initialize(ServerPluginContext context) throws Exception {
        this.context = context;
        this.tmpDirectory = new File(this.context.getTemporaryDirectory(), "ant-bundle-server-plugin");
        this.tmpDirectory.mkdirs();
        if (!this.tmpDirectory.exists() || !this.tmpDirectory.isDirectory()) {
            throw new Exception("Failed to create tmp dir [" + this.tmpDirectory + "] - cannot process Ant bundles");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The Ant bundle plugin has been initialized: " + this));
        }
    }

    public void start() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The Ant bundle plugin has started: " + this));
        }
    }

    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The Ant bundle plugin has stopped: " + this));
        }
    }

    public void shutdown() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The Ant bundle plugin has been shut down: " + this));
        }
    }

    public RecipeParseResults parseRecipe(String recipe) throws Exception {
        ConfigurationDefinition configDef;
        Set bundleFiles;
        DeploymentProperties deploymentProps;
        if (!recipe.contains("antlib:org.rhq.bundle")) {
            throw new UnknownRecipeException("Not a valid Ant recipe");
        }
        File recipeFile = File.createTempFile("ant-bundle-recipe", ".xml", this.tmpDirectory);
        File logFile = File.createTempFile("ant-bundle-recipe", ".log", this.tmpDirectory);
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(recipe.getBytes());
            FileOutputStream out = new FileOutputStream(recipeFile);
            StreamUtil.copy((InputStream)in, (OutputStream)out);
            AntLauncher antLauncher = new AntLauncher(true);
            BundleAntProject project = antLauncher.parseBundleDeployFile(recipeFile, null);
            deploymentProps = new DeploymentProperties(0, project.getBundleName(), project.getBundleVersion(), project.getBundleDescription(), project.getDestinationCompliance());
            bundleFiles = project.getBundleFileNames();
            configDef = project.getConfigurationDefinition();
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                try {
                    LOG.debug((Object)new String(StreamUtil.slurp((InputStream)new FileInputStream(logFile))));
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            throw new Exception("Failed to parse the bundle Ant script.", t);
        }
        finally {
            recipeFile.delete();
            logFile.delete();
        }
        RecipeParseResults results = new RecipeParseResults(deploymentProps, configDef, bundleFiles);
        return results;
    }

    public BundleDistributionInfo processBundleDistributionFile(File distributionFile) throws Exception {
        if (null == distributionFile) {
            throw new IllegalArgumentException("distributionFile == null");
        }
        RecipeVisitor recipeVisitor = new RecipeVisitor(this, "deploy.xml");
        ZipUtil.walkZipFile((File)distributionFile, (ZipUtil.ZipEntryVisitor)recipeVisitor);
        String recipe = recipeVisitor.getRecipe();
        RecipeParseResults recipeParseResults = recipeVisitor.getResults();
        if (null == recipeParseResults) {
            throw new UnknownRecipeException("Not an Ant Bundle");
        }
        BundleFileVisitor bundleFileVisitor = new BundleFileVisitor(recipeParseResults.getBundleFileNames());
        ZipUtil.walkZipFile((File)distributionFile, (ZipUtil.ZipEntryVisitor)bundleFileVisitor);
        return new BundleDistributionInfo(recipe, recipeParseResults, bundleFileVisitor.getBundleFiles());
    }

    public String toString() {
        if (this.context == null) {
            return "<no context>";
        }
        return "plugin-key=" + this.context.getPluginEnvironment().getPluginKey() + "," + "plugin-url=" + this.context.getPluginEnvironment().getPluginUrl();
    }

    private static class BundleFileVisitor
    implements ZipUtil.ZipEntryVisitor {
        private Set<String> bundleFileNames;
        private Map<String, File> bundleFiles;
        private File tmpDir;

        BundleFileVisitor(Set<String> bundleFileNames) throws IOException {
            this.bundleFileNames = bundleFileNames;
            this.bundleFiles = new HashMap<String, File>(bundleFileNames.size());
            this.tmpDir = FileUtil.createTempDirectory((String)"ant-bundle", (String)".dir", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean visit(ZipEntry entry, ZipInputStream stream) throws Exception {
            if (this.bundleFileNames.contains(entry.getName())) {
                File bundleFile = new File(this.tmpDir, entry.getName());
                bundleFile.getParentFile().mkdirs();
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(bundleFile);
                    StreamUtil.copy((InputStream)stream, (OutputStream)fos, (boolean)false);
                }
                finally {
                    if (null != fos) {
                        try {
                            fos.close();
                        }
                        catch (Exception e) {}
                    }
                }
                this.bundleFiles.put(entry.getName(), bundleFile);
            }
            return true;
        }

        public Map<String, File> getBundleFiles() {
            return this.bundleFiles;
        }
    }

    private static class RecipeVisitor
    implements ZipUtil.ZipEntryVisitor {
        private RecipeParseResults results = null;
        private String recipeName = null;
        private BundleServerPluginFacet facet = null;
        private String recipe = null;

        public RecipeVisitor(BundleServerPluginFacet facet, String recipeName) {
            this.facet = facet;
            this.recipeName = recipeName;
        }

        public boolean visit(ZipEntry entry, ZipInputStream stream) throws Exception {
            if (this.recipeName.equalsIgnoreCase(entry.getName())) {
                int contentSize = (int)entry.getSize();
                ByteArrayOutputStream out = new ByteArrayOutputStream(contentSize > 0 ? contentSize : 32768);
                StreamUtil.copy((InputStream)stream, (OutputStream)out, (boolean)false);
                this.recipe = new String(out.toByteArray());
                out = null;
                this.results = this.facet.parseRecipe(this.recipe);
                return false;
            }
            return true;
        }

        public RecipeParseResults getResults() {
            return this.results;
        }

        public String getRecipe() {
            return this.recipe;
        }
    }
}

