/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.cobbler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fedorahosted.cobbler.CobblerConnection;
import org.fedorahosted.cobbler.CobblerObject;
import org.fedorahosted.cobbler.Finder;
import org.fedorahosted.cobbler.ObjectType;
import org.fedorahosted.cobbler.autogen.Distro;
import org.fedorahosted.cobbler.autogen.Profile;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.Distribution;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.plugin.pc.ControlFacet;
import org.rhq.enterprise.server.plugin.pc.ControlResults;
import org.rhq.enterprise.server.plugin.pc.ScheduledJobInvocationContext;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginContext;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CobblerServerPluginComponent
implements ServerPluginComponent,
ControlFacet {
    private static Log log = LogFactory.getLog(CobblerServerPluginComponent.class);
    private static final String COMMENT_MARKER = "[rhq]";
    private ServerPluginContext context;
    private boolean syncInProgress;

    public void initialize(ServerPluginContext context) throws Exception {
        this.context = context;
        log.info((Object)("initialized: " + this));
    }

    public void start() {
        log.info((Object)("started: " + this));
    }

    public void stop() {
        log.info((Object)("stopped: " + this));
    }

    public void shutdown() {
        log.info((Object)("shutdown: " + this));
    }

    public ControlResults invoke(String name, Configuration parameters) {
        ControlResults controlResults = new ControlResults();
        try {
            if (name.equals("getCobblerDistros")) {
                String searchRegex = parameters.getSimpleValue("searchRegex", null);
                Pattern pattern = null;
                if (searchRegex != null) {
                    pattern = Pattern.compile(searchRegex);
                }
                Configuration results = controlResults.getComplexResults();
                PropertyList list = new PropertyList("distros");
                results.put((Property)list);
                Collection<Distro> distros = this.getAllCobblerDistros().values();
                for (Distro d : distros) {
                    if (pattern != null && !pattern.matcher(d.getName()).matches()) continue;
                    PropertyMap map = new PropertyMap("distro");
                    map.put((Property)new PropertySimple("name", (Object)d.getName()));
                    map.put((Property)new PropertySimple("breed", (Object)d.getBreed()));
                    map.put((Property)new PropertySimple("osversion", (Object)d.getOsVersion()));
                    map.put((Property)new PropertySimple("arch", (Object)d.getArch()));
                    map.put((Property)new PropertySimple("initrd", (Object)d.getInitrd()));
                    map.put((Property)new PropertySimple("kernel", (Object)d.getKernel()));
                    list.add((Property)map);
                }
            } else if (name.equals("getCobblerProfiles")) {
                String searchRegex = parameters.getSimpleValue("searchRegex", null);
                Pattern pattern = null;
                if (searchRegex != null) {
                    pattern = Pattern.compile(searchRegex);
                }
                Configuration results = controlResults.getComplexResults();
                PropertyList list = new PropertyList("profiles");
                results.put((Property)list);
                List<Profile> profiles = this.getAllCobblerProfiles();
                for (Profile p : profiles) {
                    if (pattern != null && !pattern.matcher(p.getName()).matches()) continue;
                    PropertyMap map = new PropertyMap("profile");
                    map.put((Property)new PropertySimple("name", (Object)p.getName()));
                    map.put((Property)new PropertySimple("distro", (Object)p.getDistro()));
                    map.put((Property)new PropertySimple("kickstart", (Object)p.getKickstart()));
                    list.add((Property)map);
                }
            } else if (name.equals("removeCobblerDistros")) {
                String searchRegex = parameters.getSimpleValue("searchRegex", null);
                Pattern pattern = null;
                if (searchRegex != null) {
                    pattern = Pattern.compile(searchRegex);
                }
                if (!this.syncInProgress) {
                    Collection<Distro> distros = this.getAllCobblerDistros().values();
                    for (Distro d : distros) {
                        if (pattern != null && !pattern.matcher(d.getName()).matches() || !d.getComment().startsWith(COMMENT_MARKER)) continue;
                        d.remove();
                    }
                } else {
                    controlResults.setError("A synchronize is currently in progress - please wait for it to finish");
                }
            } else {
                controlResults.setError("Unknown operation name: " + name);
            }
        }
        catch (Exception e) {
            controlResults.setError((Throwable)e);
        }
        return controlResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeContent(ScheduledJobInvocationContext invocation) throws Exception {
        log.info((Object)("Synchronizing content to the local Cobbler server: " + this));
        try {
            this.syncInProgress = true;
            Server server = LookupUtil.getServerManager().getServer();
            String rootUrl = "http://" + server.getAddress() + ":" + server.getPort() + "/content/";
            Map<String, Distro> cobblerDistros = this.getAllCobblerDistros();
            Map<Repo, Map<String, Distribution>> reposDistributions = this.getAllDistributions();
            CobblerConnection conn = this.getConnection();
            for (Map.Entry<Repo, Map<String, Distribution>> repoEntry : reposDistributions.entrySet()) {
                Repo repo = repoEntry.getKey();
                String repoName = repo.getName();
                for (Distribution distribution : repoEntry.getValue().values()) {
                    Distro existingCobblerDistro = cobblerDistros.get(distribution.getLabel());
                    Distro desiredCobblerDistro = this.instantiateCobblerDistro(conn, distribution, repoName, rootUrl);
                    if (existingCobblerDistro != null) {
                        cobblerDistros.remove(existingCobblerDistro.getName());
                        if (!this.compareCobblerDistros(existingCobblerDistro, desiredCobblerDistro)) {
                            this.updateCobblerDistro(existingCobblerDistro, desiredCobblerDistro);
                            existingCobblerDistro.commit();
                            log.info((Object)("Updated existing Cobbler distro [" + distribution.getLabel() + "]"));
                            continue;
                        }
                        log.debug((Object)("Cobbler already has distro [" + distribution.getLabel() + "]; keeping it"));
                        continue;
                    }
                    desiredCobblerDistro.commit();
                    log.info((Object)("Added new distro to Cobbler: [" + distribution.getLabel() + "]"));
                }
            }
            for (Distro doomed : cobblerDistros.values()) {
                if (!doomed.getComment().startsWith(COMMENT_MARKER)) continue;
                doomed.remove();
                log.info((Object)("Removed obsolete distro from Cobbler: [" + doomed.getName() + "]"));
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to synchronize distributions to Cobbler server", t);
        }
        finally {
            this.syncInProgress = false;
        }
    }

    private void updateCobblerDistro(Distro existingCobblerDistro, Distro desiredCobblerDistro) {
        existingCobblerDistro.setName(desiredCobblerDistro.getName());
        existingCobblerDistro.setComment(desiredCobblerDistro.getComment());
        existingCobblerDistro.setKernel(desiredCobblerDistro.getKernel());
        existingCobblerDistro.setInitrd(desiredCobblerDistro.getInitrd());
        Map ksMetaDesired = desiredCobblerDistro.getKsMeta();
        if (ksMetaDesired != null) {
            HashMap ksMetaExisting = existingCobblerDistro.getKsMeta();
            if (ksMetaExisting == null) {
                ksMetaExisting = new HashMap(ksMetaDesired.size());
                existingCobblerDistro.setKsMeta(ksMetaExisting);
            }
            ksMetaExisting.clear();
            ksMetaExisting.putAll(ksMetaDesired);
        } else {
            existingCobblerDistro.setKsMeta(null);
        }
    }

    private boolean compareCobblerDistros(Distro cobblerDistro1, Distro cobblerDistro2) {
        if (!this.compareObjects(cobblerDistro1.getName(), cobblerDistro2.getName())) {
            return false;
        }
        if (!this.compareObjects(cobblerDistro1.getComment(), cobblerDistro2.getComment())) {
            return false;
        }
        if (!this.compareObjects(cobblerDistro1.getKernel(), cobblerDistro2.getKernel())) {
            return false;
        }
        if (!this.compareObjects(cobblerDistro1.getInitrd(), cobblerDistro2.getInitrd())) {
            return false;
        }
        Map ksMeta1 = cobblerDistro1.getKsMeta();
        Map ksMeta2 = cobblerDistro2.getKsMeta();
        String tree1 = null;
        String tree2 = null;
        if (ksMeta1 != null) {
            tree1 = (String)ksMeta1.get("tree");
        }
        if (ksMeta2 != null) {
            tree2 = (String)ksMeta2.get("tree");
        }
        return this.compareObjects(tree1, tree2);
    }

    private Distro instantiateCobblerDistro(CobblerConnection conn, Distribution distribution, String repoName, String rootUrl) {
        String distroRootUrl = rootUrl + repoName + "/distributions/" + distribution.getLabel();
        String kernel = distroRootUrl + "/images/pxeboot/vmlinuz";
        String initrd = distroRootUrl + "/images/pxeboot/initrd.img";
        String ksTree = distroRootUrl;
        Distro cobblerDistro = new Distro(conn);
        cobblerDistro.setName(distribution.getLabel());
        cobblerDistro.setComment("[rhq] " + distribution.getLabel());
        cobblerDistro.setKernel(kernel);
        cobblerDistro.setInitrd(initrd);
        HashMap<String, String> ksmeta = new HashMap<String, String>();
        ksmeta.put("tree", ksTree);
        cobblerDistro.setKsMeta(ksmeta);
        return cobblerDistro;
    }

    public String toString() {
        if (this.context == null) {
            return "<no context>";
        }
        StringBuilder str = new StringBuilder();
        str.append("plugin-key=").append(this.context.getPluginEnvironment().getPluginKey()).append(",");
        str.append("plugin-url=").append(this.context.getPluginEnvironment().getPluginUrl()).append(",");
        str.append("plugin-config=[").append(this.getPluginConfigurationString()).append(']');
        return str.toString();
    }

    private Map<String, Distro> getAllCobblerDistros() {
        HashMap<String, Distro> distros = new HashMap<String, Distro>();
        CobblerConnection conn = this.getConnection();
        Finder finder = Finder.getInstance();
        List objs = finder.listItems(conn, ObjectType.DISTRO);
        for (CobblerObject obj : objs) {
            if (obj instanceof Distro) {
                distros.put(((Distro)obj).getName(), (Distro)obj);
                continue;
            }
            log.error((Object)("Instead of a distro, Cobbler returned an object of type [" + obj.getClass() + "]: " + obj));
        }
        return distros;
    }

    private List<Profile> getAllCobblerProfiles() {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        CobblerConnection conn = this.getConnection();
        Finder finder = Finder.getInstance();
        List objs = finder.listItems(conn, ObjectType.PROFILE);
        for (CobblerObject obj : objs) {
            if (obj instanceof Profile) {
                profiles.add((Profile)obj);
                continue;
            }
            log.error((Object)("Instead of a profile, Cobbler returned an object of type [" + obj.getClass() + "]: " + obj));
        }
        return profiles;
    }

    private Map<Repo, Map<String, Distribution>> getAllDistributions() {
        PageList repoPage;
        int repoPageSize = 10;
        int distroPageSize = 10;
        HashMap<Repo, Map<String, Distribution>> reposDistros = new HashMap<Repo, Map<String, Distribution>>();
        RepoManagerLocal repoMgr = LookupUtil.getRepoManagerLocal();
        PageControl repoPC = new PageControl(0, 10);
        int totalReposProcessed = 0;
        while ((repoPage = repoMgr.findRepos(LookupUtil.getSubjectManager().getOverlord(), repoPC)).size() > 0) {
            block1: for (Repo repoPageItem : repoPage) {
                PageList distroPage;
                if (repoPageItem.isCandidate()) continue;
                HashMap<String, Distribution> distrosMap = (HashMap<String, Distribution>)reposDistros.get(repoPageItem);
                if (distrosMap == null) {
                    distrosMap = new HashMap<String, Distribution>();
                    reposDistros.put(repoPageItem, distrosMap);
                }
                PageControl distroPC = new PageControl(0, 10);
                int totalDistrosProcessed = 0;
                while ((distroPage = repoMgr.findAssociatedDistributions(LookupUtil.getSubjectManager().getOverlord(), repoPageItem.getId(), distroPC)).size() > 0) {
                    for (Distribution distroPageItem : distroPage) {
                        distrosMap.put(distroPageItem.getLabel(), distroPageItem);
                    }
                    if ((totalDistrosProcessed += distroPage.size()) >= distroPage.getTotalSize()) continue block1;
                    distroPC.setPageNumber(distroPC.getPageNumber() + 1);
                }
            }
            if ((totalReposProcessed += repoPage.size()) >= repoPage.getTotalSize()) break;
            repoPC.setPageNumber(repoPC.getPageNumber() + 1);
        }
        return reposDistros;
    }

    private CobblerConnection getConnection() {
        Configuration pc = this.context.getPluginConfiguration();
        String url = pc.getSimpleValue("url", "http://127.0.0.1");
        String username = pc.getSimpleValue("username", "");
        String password = pc.getSimpleValue("password", "");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Connecting to Cobbler at [" + url + "] as user [" + username + "]"));
        }
        CobblerConnection conn = new CobblerConnection(url, username, password);
        return conn;
    }

    private String getPluginConfigurationString() {
        String results = "";
        Configuration config = this.context.getPluginConfiguration();
        for (PropertySimple prop : config.getSimpleProperties().values()) {
            if (results.length() > 0) {
                results = results + ", ";
            }
            results = results + prop.getName() + "=" + prop.getStringValue();
        }
        return results;
    }

    private boolean compareObjects(Object o1, Object o2) {
        if (o1 != null) {
            return o1.equals(o2);
        }
        return o2 == null;
    }
}

