/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.disk;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.file.ContentFileInfo;
import org.rhq.core.util.file.ContentFileInfoFactory;
import org.rhq.enterprise.server.plugin.pc.content.ContentProvider;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetails;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetailsKey;
import org.rhq.enterprise.server.plugin.pc.content.PackageSource;
import org.rhq.enterprise.server.plugin.pc.content.PackageSyncReport;
import org.rhq.enterprise.server.plugin.pc.content.RepoDetails;
import org.rhq.enterprise.server.plugin.pc.content.RepoImportReport;
import org.rhq.enterprise.server.plugin.pc.content.RepoSource;
import org.rhq.enterprise.server.plugin.pc.content.SyncException;
import org.rhq.enterprise.server.plugin.pc.content.SyncProgressWeight;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskSource
implements ContentProvider,
PackageSource,
RepoSource {
    private File rootDirectory;
    private String rootDirectoryAbsolutePath;
    private Map<String, SupportedPackageType> supportedPackageTypes;
    private Configuration configuration;
    private boolean isRepoSource;
    private boolean isPackageSource;

    public void initialize(Configuration configuration) throws Exception {
        this.configuration = configuration;
        this.isPackageSource = ((PropertySimple)configuration.get("packageSourceEnabled")).getBooleanValue();
        this.isRepoSource = ((PropertySimple)configuration.get("repoSourceEnabled")).getBooleanValue();
        this.initializePackageTypes();
        String pathString = configuration.getSimpleValue("rootDirectory", null);
        this.setRootDirectory(new File(pathString));
        this.testConnection();
    }

    public void shutdown() {
        this.rootDirectory = null;
        this.rootDirectoryAbsolutePath = null;
        this.supportedPackageTypes = null;
    }

    public RepoImportReport importRepos() throws Exception {
        RepoImportReport report = new RepoImportReport();
        if (!this.isRepoSource) {
            return report;
        }
        File directory = this.getRootDirectory();
        this.generateRepoDetails(report, directory, null);
        return report;
    }

    public void synchronizePackages(String repoName, PackageSyncReport report, Collection<ContentProviderPackageDetails> existingPackages) throws SyncException, InterruptedException {
        if (!this.isPackageSource) {
            return;
        }
        ArrayList<ContentProviderPackageDetails> deletedPackages = new ArrayList<ContentProviderPackageDetails>();
        deletedPackages.addAll(existingPackages);
        long before = System.currentTimeMillis();
        this.syncPackages(report, repoName, deletedPackages, this.getRootDirectory());
        long elapsed = System.currentTimeMillis() - before;
        for (ContentProviderPackageDetails p : deletedPackages) {
            report.addDeletePackage(p);
        }
        report.setSummary("Synchronized [" + this.getRootDirectory() + "]. Elapsed time=[" + elapsed + "] ms");
    }

    public void testConnection() throws Exception {
        File root = this.getRootDirectory();
        if (!root.exists()) {
            throw new Exception("Disk source [" + root + "] does not exist");
        }
        if (!root.canRead()) {
            throw new Exception("Not permitted to read disk source [" + root + "] ");
        }
        if (!root.isDirectory()) {
            throw new Exception("Disk source [" + root + "] is not a directory");
        }
    }

    public InputStream getInputStream(String location) throws Exception {
        return new FileInputStream(new File(this.getRootDirectory(), location));
    }

    protected File getRootDirectory() {
        return this.rootDirectory;
    }

    protected void setRootDirectory(File path) {
        this.rootDirectory = path;
        this.rootDirectoryAbsolutePath = this.rootDirectory.getAbsolutePath();
    }

    protected Map<String, SupportedPackageType> getSupportedPackageTypes() {
        return this.supportedPackageTypes;
    }

    protected void setSupportedPackageTypes(Map<String, SupportedPackageType> supportedPackageTypes) {
        this.supportedPackageTypes = supportedPackageTypes;
    }

    protected void syncPackages(PackageSyncReport report, String repoName, List<ContentProviderPackageDetails> packages, File directory) throws SyncException {
        for (File file : directory.listFiles()) {
            if (!file.isDirectory()) continue;
            if (file.getName().equals(repoName)) {
                for (File filePackage : file.listFiles()) {
                    ContentProviderPackageDetails details = this.createPackage(filePackage);
                    if (details == null) continue;
                    ContentProviderPackageDetails existing = this.findPackage(packages, details);
                    if (existing == null) {
                        report.addNewPackage(details);
                        continue;
                    }
                    packages.remove(existing);
                    if (details.getFileCreatedDate().compareTo(existing.getFileCreatedDate()) <= 0) continue;
                    report.addUpdatedPackage(details);
                }
                break;
            }
            this.syncPackages(report, repoName, packages, file);
        }
    }

    protected ContentProviderPackageDetails createPackage(File file) throws SyncException {
        String md5;
        SupportedPackageType supportedPackageType = this.determinePackageType(file);
        if (supportedPackageType == null) {
            return null;
        }
        ContentFileInfo fileInfo = ContentFileInfoFactory.createContentFileInfo((File)file);
        try {
            md5 = MessageDigestGenerator.getDigestString((File)file);
        }
        catch (IOException e) {
            throw new SyncException("Error digesting file", (Exception)e);
        }
        String name = file.getName();
        String version = fileInfo.getVersion(md5);
        String packageTypeName = supportedPackageType.packageTypeName;
        String architectureName = supportedPackageType.architectureName;
        String resourceTypeName = supportedPackageType.resourceTypeName;
        String resourceTypePluginName = supportedPackageType.resourceTypePluginName;
        ContentProviderPackageDetailsKey key = new ContentProviderPackageDetailsKey(name, version, packageTypeName, architectureName, resourceTypeName, resourceTypePluginName);
        ContentProviderPackageDetails pkg = new ContentProviderPackageDetails(key);
        pkg.setDisplayName(name);
        pkg.setFileName(name);
        pkg.setFileCreatedDate(Long.valueOf(file.lastModified()));
        pkg.setFileSize(Long.valueOf(file.length()));
        pkg.setMD5(md5);
        pkg.setLocation(this.getRelativePath(file));
        pkg.setShortDescription(fileInfo.getDescription(null));
        return pkg;
    }

    protected ContentProviderPackageDetails findPackage(List<ContentProviderPackageDetails> packages, ContentProviderPackageDetails pkg) {
        for (ContentProviderPackageDetails p : packages) {
            if (!p.equals((Object)pkg)) continue;
            return p;
        }
        return null;
    }

    protected String getRelativePath(File file) {
        String relativePath;
        String fileAbsolutePath = file.getAbsolutePath();
        int idx = fileAbsolutePath.indexOf(this.rootDirectoryAbsolutePath);
        if (idx > -1) {
            relativePath = fileAbsolutePath.substring(idx + this.rootDirectoryAbsolutePath.length());
            if (relativePath.startsWith(File.separator)) {
                relativePath = relativePath.substring(1);
            }
        } else {
            relativePath = fileAbsolutePath;
        }
        return relativePath;
    }

    protected void initializePackageTypes() {
        HashMap<String, SupportedPackageType> supportedPackageTypes = new HashMap<String, SupportedPackageType>();
        SupportedPackageType supportedPackageType = new SupportedPackageType();
        supportedPackageType.packageTypeName = this.configuration.getSimpleValue("packageTypeName", null);
        supportedPackageType.architectureName = this.configuration.getSimpleValue("architectureName", null);
        String resourceAndPlugin = this.configuration.getSimpleValue("resourceType", null);
        String resourceType = resourceAndPlugin.substring(resourceAndPlugin.indexOf(45) + 1);
        String pluginType = resourceAndPlugin.substring(0, resourceAndPlugin.indexOf(45));
        supportedPackageType.resourceTypeName = resourceType;
        supportedPackageType.resourceTypePluginName = pluginType;
        String filenameFilter = this.configuration.getSimpleValue("filenameFilter", null);
        supportedPackageTypes.put(filenameFilter, supportedPackageType);
        this.setSupportedPackageTypes(supportedPackageTypes);
    }

    protected SupportedPackageType determinePackageType(File file) {
        String absolutePath = file.getAbsolutePath();
        for (Map.Entry<String, SupportedPackageType> entry : this.getSupportedPackageTypes().entrySet()) {
            if (!absolutePath.matches(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    protected void generateRepoDetails(RepoImportReport report, File base, String parentName) {
        for (File file : base.listFiles()) {
            if (!file.isDirectory()) continue;
            RepoDetails repo = new RepoDetails(file.getName(), parentName);
            report.addRepo(repo);
            this.generateRepoDetails(report, file, repo.getName());
        }
    }

    public SyncProgressWeight getSyncProgressWeight() {
        return new SyncProgressWeight(10, 1, 0, 0, 0);
    }

    protected class SupportedPackageType {
        public String packageTypeName;
        public String architectureName;
        public String resourceTypeName;
        public String resourceTypePluginName;

        protected SupportedPackageType() {
        }
    }
}

