/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.jboss.software;

import churchillobjects.rss4j.RssDocument;
import churchillobjects.rss4j.parser.RssParser;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.enterprise.server.plugin.pc.content.ContentProvider;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetails;
import org.rhq.enterprise.server.plugin.pc.content.PackageSource;
import org.rhq.enterprise.server.plugin.pc.content.PackageSyncReport;
import org.rhq.enterprise.server.plugin.pc.content.RepoDetails;
import org.rhq.enterprise.server.plugin.pc.content.RepoImportReport;
import org.rhq.enterprise.server.plugin.pc.content.RepoSource;
import org.rhq.enterprise.server.plugin.pc.content.SyncException;
import org.rhq.enterprise.server.plugin.pc.content.SyncProgressWeight;
import org.rhq.enterprise.server.plugins.jboss.software.RssFeedParser;

public class JBossSoftwareContentSourceAdapter
implements ContentProvider,
PackageSource,
RepoSource {
    private String url;
    private String username;
    private String password;
    private String proxyUrl;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private boolean active;
    private RssFeedParser parser = new RssFeedParser();
    private final Log log = LogFactory.getLog(this.getClass());

    public void initialize(Configuration configuration) throws Exception {
        this.url = this.safeGetConfigurationProperty("url", configuration);
        if (this.url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        PropertySimple activeProperty = configuration.getSimple("active");
        if (activeProperty != null) {
            this.active = activeProperty.getBooleanValue();
        }
        this.username = this.safeGetConfigurationProperty("username", configuration);
        this.password = this.safeGetConfigurationProperty("password", configuration);
        this.proxyUrl = this.safeGetConfigurationProperty("proxyUrl", configuration);
        this.proxyUsername = this.safeGetConfigurationProperty("proxyUsername", configuration);
        this.proxyPassword = this.safeGetConfigurationProperty("proxyPassword", configuration);
        String sProxyPort = this.safeGetConfigurationProperty("proxyPort", configuration);
        if (sProxyPort != null) {
            this.proxyPort = Integer.parseInt(sProxyPort);
        }
    }

    public void shutdown() {
    }

    public void testConnection() throws Exception {
        if (!this.active) {
            throw new Exception("Content source is NOT set to active - connection cannot be established.");
        }
        this.retrieveRssDocument();
    }

    public void synchronizePackages(String repoName, PackageSyncReport report, Collection<ContentProviderPackageDetails> existingPackages) throws SyncException, InterruptedException {
        RssDocument rssDocument;
        if (!this.active) {
            return;
        }
        try {
            rssDocument = this.retrieveRssDocument();
        }
        catch (Exception e) {
            throw new SyncException("Error retrieving RSS document.", e);
        }
        if (rssDocument == null) {
            throw new SyncException("Null RSS document received from adapter: " + this);
        }
        try {
            this.parser.parseResults(rssDocument, report, existingPackages);
        }
        catch (Exception e) {
            throw new SyncException("Error parsing RSS document.", e);
        }
    }

    public InputStream getInputStream(String location) throws Exception {
        int status;
        HttpClient client = new HttpClient();
        this.configureProxy(client);
        GetMethod method = new GetMethod(location);
        method.setDoAuthentication(true);
        method.setFollowRedirects(true);
        if (this.username != null && this.password != null) {
            method.addRequestHeader("username", this.username);
            method.addRequestHeader("password", this.password);
        }
        if ((status = client.executeMethod((HttpMethod)method)) != 200) {
            throw new Exception("Call to retrieve stream returned status code: " + status);
        }
        InputStream stream = method.getResponseBodyAsStream();
        return stream;
    }

    public RepoImportReport importRepos() throws Exception {
        RepoDetails repo = new RepoDetails("JBoss Patches");
        RepoImportReport report = new RepoImportReport();
        report.addRepo(repo);
        return report;
    }

    public String toString() {
        return "JBossSoftwareContentSourceAdapter[url=" + this.url + ", username=" + this.username + "]";
    }

    private String safeGetConfigurationProperty(String propertyName, Configuration configuration) {
        PropertySimple property = configuration.getSimple(propertyName);
        return property != null ? property.getStringValue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RssDocument retrieveRssDocument() throws Exception {
        HttpClient client = new HttpClient();
        this.configureProxy(client);
        URI feedURI = new URI(this.url);
        URL feedURL = feedURI.toURL();
        GetMethod method = new GetMethod(feedURL.toString());
        method.setDoAuthentication(true);
        if (this.username != null && this.password != null) {
            UsernamePasswordCredentials upc = new UsernamePasswordCredentials(this.username, this.password);
            client.getState().setCredentials("users", method.getHostConfiguration().getHost(), (Credentials)upc);
        }
        String rawFeed = null;
        try {
            String originalUrl = method.getURI().getURI();
            int status = client.executeMethod((HttpMethod)method);
            String currentUrl = method.getURI().getURI();
            if (!originalUrl.trim().equalsIgnoreCase(currentUrl.trim())) {
                method = new GetMethod(currentUrl);
                method.setDoAuthentication(true);
                if (this.username != null && this.password != null) {
                    UsernamePasswordCredentials upc = new UsernamePasswordCredentials(this.username, this.password);
                    client.getState().setCredentials("users", method.getHostConfiguration().getHost(), (Credentials)upc);
                }
                this.log.warn((Object)("Following redirect to [" + currentUrl + "]. You may need to update your feed URL if redirect is permanent."));
                status = client.executeMethod((HttpMethod)method);
            }
            if (status == 404) {
                throw new SyncException("Could not find the feed at URL [" + this.url + "]. Make sure the URL field correctly refers to the CSP feed location.");
            }
            if (status == 401 || status == 403) {
                throw new SyncException("Invalid login credentials specified for user [" + this.username + "]. Make sure " + "this user has an active account at the CSP and that the password is correct.");
            }
            if (status != 200) {
                throw new SyncException("The call to retrieve the RSS feed failed with status code: " + status);
            }
            rawFeed = method.getResponseBodyAsString();
        }
        finally {
            method.releaseConnection();
        }
        RssDocument parsedFeed = null;
        if (rawFeed != null) {
            parsedFeed = RssParser.parseRss((String)rawFeed);
        }
        return parsedFeed;
    }

    private void configureProxy(HttpClient client) {
        if (this.proxyUrl != null) {
            this.log.debug((Object)("Configuring feed for proxy. URL: " + this.proxyUrl + ", Port: " + this.proxyPort));
            HostConfiguration hostConfiguration = client.getHostConfiguration();
            hostConfiguration.setProxy(this.proxyUrl, this.proxyPort);
            if (this.proxyUsername != null) {
                this.log.debug((Object)("Configuring feed for authenticating proxy. User: " + this.proxyUsername));
                AuthScope proxyAuthScope = new AuthScope(this.proxyUrl, this.proxyPort, AuthScope.ANY_REALM);
                UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword);
                client.getState().setProxyCredentials(proxyAuthScope, (Credentials)proxyCredentials);
            }
        }
    }

    public SyncProgressWeight getSyncProgressWeight() {
        return SyncProgressWeight.DEFAULT_WEIGHTS;
    }
}

