/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.url;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import org.rhq.enterprise.server.plugins.url.IndexParser;
import org.rhq.enterprise.server.plugins.url.RemotePackageInfo;
import org.rhq.enterprise.server.plugins.url.UrlSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleIndexParser
implements IndexParser {
    @Override
    public Map<String, RemotePackageInfo> parse(InputStream indexStream, UrlSource contentSource) throws Exception {
        HashMap<String, RemotePackageInfo> fileList = new HashMap<String, RemotePackageInfo>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(indexStream));
        String line = reader.readLine();
        while (line != null) {
            String[] locationAndMd5;
            while (line.startsWith("/")) {
                line = line.length() > 1 ? line.substring(1) : "";
            }
            if (line.length() > 0 && (locationAndMd5 = line.split("\\|")).length == 2) {
                URL locationUrl = new URL(contentSource.getRootUrl().toString() + locationAndMd5[0]);
                RemotePackageInfo rpi = new RemotePackageInfo(locationAndMd5[0], locationUrl, locationAndMd5[1]);
                fileList.put(rpi.getLocation(), rpi);
            }
            line = reader.readLine();
        }
        return fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            String directoryString;
            File directory;
            if (args.length == 0) {
                System.err.println("You must provide the directory name where the content can be found.");
                System.exit(1);
            }
            if (!(directory = new File(directoryString = args[0])).isDirectory()) {
                System.err.println("You did not supply a valid directory name: " + directoryString);
                System.exit(1);
            }
            File index = new File(directory, "content-index.txt");
            PrintWriter writer = new PrintWriter(index);
            try {
                SimpleIndexParser.generatePackageIndex(directory, writer, directory);
            }
            finally {
                writer.close();
            }
        }
        catch (Throwable t) {
            System.err.println("Failed to generate content index file. Cause: " + t);
            t.printStackTrace(System.err);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void generatePackageIndex(File file, PrintWriter indexWriter, File root) throws Exception {
        if (file.isDirectory()) {
            File[] childFiles;
            for (File childFile : childFiles = file.listFiles()) {
                SimpleIndexParser.generatePackageIndex(childFile, indexWriter, root);
            }
        } else if (!file.getCanonicalPath().equals(new File(root, "content-index.txt").getCanonicalPath())) {
            String md5;
            String location = file.getCanonicalPath().substring(root.getCanonicalPath().length() + 1);
            FileInputStream is = null;
            try {
                int len;
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                is = new FileInputStream(file);
                byte[] bytes = new byte[1024];
                while ((len = is.read(bytes, 0, bytes.length)) != -1) {
                    messageDigest.update(bytes, 0, len);
                }
                bytes = messageDigest.digest();
                StringBuffer sb = new StringBuffer(bytes.length * 2);
                for (int i = 0; i < bytes.length; ++i) {
                    int hi = bytes[i] >> 4 & 0xF;
                    int lo = bytes[i] & 0xF;
                    sb.append(Character.forDigit(hi, 16));
                    sb.append(Character.forDigit(lo, 16));
                }
                md5 = sb.toString();
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            indexWriter.println(location.replace('\\', '/') + '|' + md5);
        }
    }
}

