/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.url;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.enterprise.server.plugin.pc.content.ContentProvider;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetails;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetailsKey;
import org.rhq.enterprise.server.plugin.pc.content.PackageSource;
import org.rhq.enterprise.server.plugin.pc.content.PackageSyncReport;
import org.rhq.enterprise.server.plugins.url.FullRemotePackageInfo;
import org.rhq.enterprise.server.plugins.url.IndexParser;
import org.rhq.enterprise.server.plugins.url.RemotePackageInfo;
import org.rhq.enterprise.server.plugins.url.SimpleIndexParser;
import org.rhq.enterprise.server.plugins.url.XmlIndexParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlProvider
implements ContentProvider,
PackageSource {
    private static final String DEFAULT_INDEX_FILENAME = "content-index.txt";
    private URL rootUrl;
    private String rootUrlString;
    private URL indexUrl;
    private Map<String, RemotePackageInfo.SupportedPackageType> supportedPackageTypes;

    protected String getRootUrlString() {
        return this.rootUrlString;
    }

    protected URL getRootUrl() {
        return this.rootUrl;
    }

    protected void setRootUrl(URL url) {
        this.rootUrl = url;
        this.rootUrlString = url.toString();
        if (!this.rootUrlString.endsWith("/")) {
            this.rootUrlString = this.rootUrlString + "/";
        }
    }

    protected URL getIndexUrl() {
        return this.indexUrl;
    }

    protected void setIndexUrl(URL indexURL) {
        this.indexUrl = indexURL;
    }

    protected Map<String, RemotePackageInfo.SupportedPackageType> getSupportedPackageTypes() {
        return this.supportedPackageTypes;
    }

    protected void setSupportedPackageTypes(Map<String, RemotePackageInfo.SupportedPackageType> supportedPackageTypes) {
        this.supportedPackageTypes = supportedPackageTypes;
    }

    public void initialize(Configuration configuration) throws Exception {
        this.initializePackageTypes(configuration);
        String rootUrlString = configuration.getSimpleValue("rootUrl", null);
        String indexFileString = configuration.getSimpleValue("indexFile", DEFAULT_INDEX_FILENAME);
        if (indexFileString.indexOf(":") > -1) {
            this.setIndexUrl(new URL(indexFileString));
        } else {
            if (!rootUrlString.endsWith("/") && !indexFileString.startsWith("/")) {
                indexFileString = "/" + indexFileString;
            }
            this.setIndexUrl(new URL(rootUrlString + indexFileString));
        }
        URI uri = new URI(rootUrlString);
        URL url = uri.toURL();
        this.setRootUrl(url);
        this.testConnection();
    }

    public void shutdown() {
        this.rootUrl = null;
        this.rootUrlString = null;
        this.indexUrl = null;
        this.supportedPackageTypes = null;
    }

    public void synchronizePackages(String repoName, PackageSyncReport report, Collection<ContentProviderPackageDetails> existingPackages) throws Exception {
        ArrayList<ContentProviderPackageDetails> deletedPackages = new ArrayList<ContentProviderPackageDetails>();
        deletedPackages.addAll(existingPackages);
        long before = System.currentTimeMillis();
        Map<String, RemotePackageInfo> locationList = this.getRemotePackageInfosFromIndex();
        for (RemotePackageInfo rpi : locationList.values()) {
            this.syncPackage(report, deletedPackages, rpi);
        }
        long elapsed = System.currentTimeMillis() - before;
        for (ContentProviderPackageDetails p : deletedPackages) {
            report.addDeletePackage(p);
        }
        report.setSummary("Synchronized [" + this.getRootUrl() + "]. Elapsed time=[" + elapsed + "] ms");
    }

    public void testConnection() throws Exception {
        URL url = this.getIndexUrl();
        URLConnection urlConn = url.openConnection();
        urlConn.getContentLength();
    }

    public InputStream getInputStream(String location) throws Exception {
        URL locationUrl = new URL(this.rootUrlString + location);
        return locationUrl.openStream();
    }

    protected InputStream getIndexInputStream() throws Exception {
        InputStream indexStream = this.getIndexUrl().openStream();
        return indexStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, RemotePackageInfo> getRemotePackageInfosFromIndex() throws Exception {
        IndexParser parser = this.getIndexUrl().toString().endsWith(".xml") ? new XmlIndexParser() : new SimpleIndexParser();
        HashMap<String, RemotePackageInfo> fileList = new HashMap();
        InputStream indexStream = this.getIndexInputStream();
        try {
            fileList = parser.parse(indexStream, this);
        }
        finally {
            indexStream.close();
        }
        return fileList;
    }

    protected void syncPackage(PackageSyncReport report, List<ContentProviderPackageDetails> packages, RemotePackageInfo rpi) throws Exception {
        ContentProviderPackageDetails details = this.createPackage(rpi);
        if (details != null) {
            ContentProviderPackageDetails existing = this.findPackage(packages, details);
            if (existing == null) {
                report.addNewPackage(details);
            } else {
                packages.remove(existing);
                if (details.getFileCreatedDate().compareTo(existing.getFileCreatedDate()) > 0) {
                    report.addUpdatedPackage(details);
                }
            }
        }
    }

    protected ContentProviderPackageDetails createPackage(RemotePackageInfo rpi) throws Exception {
        RemotePackageInfo.SupportedPackageType supportedPackageType = this.determinePackageType(rpi);
        if (supportedPackageType == null) {
            return null;
        }
        ContentProviderPackageDetails pkg = null;
        if (rpi instanceof FullRemotePackageInfo) {
            pkg = ((FullRemotePackageInfo)rpi).getContentSourcePackageDetails();
        }
        if (pkg == null) {
            String md5 = rpi.getMD5();
            String name = new File(rpi.getLocation()).getName();
            String version = md5;
            String packageTypeName = supportedPackageType.packageTypeName;
            String architectureName = supportedPackageType.architectureName;
            String resourceTypeName = supportedPackageType.resourceTypeName;
            String resourceTypePluginName = supportedPackageType.resourceTypePluginName;
            ContentProviderPackageDetailsKey key = new ContentProviderPackageDetailsKey(name, version, packageTypeName, architectureName, resourceTypeName, resourceTypePluginName);
            pkg = new ContentProviderPackageDetails(key);
            URLConnection urlConn = rpi.getUrl().openConnection();
            pkg.setFileCreatedDate(Long.valueOf(urlConn.getLastModified()));
            pkg.setFileSize(new Long(urlConn.getContentLength()));
            pkg.setDisplayName(name);
            pkg.setFileName(name);
            pkg.setMD5(md5);
            pkg.setLocation(rpi.getLocation());
            pkg.setShortDescription(null);
        }
        return pkg;
    }

    protected ContentProviderPackageDetails findPackage(List<ContentProviderPackageDetails> packages, ContentProviderPackageDetails pkg) {
        for (ContentProviderPackageDetails p : packages) {
            if (!p.equals((Object)pkg)) continue;
            return p;
        }
        return null;
    }

    protected void initializePackageTypes(Configuration config) {
        HashMap<String, RemotePackageInfo.SupportedPackageType> supportedPackageTypes = new HashMap<String, RemotePackageInfo.SupportedPackageType>();
        PropertyList list = config.getList("packageTypes");
        if (list != null) {
            List packageTypesList = list.getList();
            for (Property property : packageTypesList) {
                PropertyMap pkgType = (PropertyMap)property;
                RemotePackageInfo.SupportedPackageType supportedPackageType = new RemotePackageInfo.SupportedPackageType();
                supportedPackageType.packageTypeName = pkgType.getSimpleValue("packageTypeName", null);
                supportedPackageType.architectureName = pkgType.getSimpleValue("architectureName", null);
                supportedPackageType.resourceTypeName = pkgType.getSimpleValue("resourceTypeName", null);
                supportedPackageType.resourceTypePluginName = pkgType.getSimpleValue("resourceTypePluginName", null);
                String filenameFilter = pkgType.getSimpleValue("filenameFilter", null);
                supportedPackageTypes.put(filenameFilter, supportedPackageType);
            }
        }
        this.setSupportedPackageTypes(supportedPackageTypes);
    }

    protected RemotePackageInfo.SupportedPackageType determinePackageType(RemotePackageInfo rpi) {
        if (rpi.getSupportedPackageType() != null) {
            return rpi.getSupportedPackageType();
        }
        for (Map.Entry<String, RemotePackageInfo.SupportedPackageType> entry : this.getSupportedPackageTypes().entrySet()) {
            if (!rpi.getLocation().matches(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }
}

