/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.url;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetails;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetailsKey;
import org.rhq.enterprise.server.plugins.url.FullRemotePackageInfo;
import org.rhq.enterprise.server.plugins.url.IndexParser;
import org.rhq.enterprise.server.plugins.url.RemotePackageInfo;
import org.rhq.enterprise.server.plugins.url.UrlProvider;
import org.rhq.enterprise.server.xmlschema.generated.contentsource.packagedetails.ConfigurationType;
import org.rhq.enterprise.server.xmlschema.generated.contentsource.packagedetails.ListPropertyType;
import org.rhq.enterprise.server.xmlschema.generated.contentsource.packagedetails.MapPropertyType;
import org.rhq.enterprise.server.xmlschema.generated.contentsource.packagedetails.ObjectFactory;
import org.rhq.enterprise.server.xmlschema.generated.contentsource.packagedetails.PackageDetailsKeyType;
import org.rhq.enterprise.server.xmlschema.generated.contentsource.packagedetails.PackageDetailsType;
import org.rhq.enterprise.server.xmlschema.generated.contentsource.packagedetails.PackageType;
import org.rhq.enterprise.server.xmlschema.generated.contentsource.packagedetails.ResourceVersionsType;
import org.rhq.enterprise.server.xmlschema.generated.contentsource.packagedetails.SimplePropertyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlIndexParser
implements IndexParser {
    private final Log log = LogFactory.getLog(XmlIndexParser.class);
    private static final String PLUGIN_SCHEMA_PATH = "rhq-contentsource-packagedetails.xsd";

    @Override
    public Map<String, RemotePackageInfo> parse(InputStream indexStream, UrlProvider contentSource) throws Exception {
        return this.jaxbParse(indexStream, contentSource.getIndexUrl(), contentSource.getRootUrlString());
    }

    protected Map<String, RemotePackageInfo> jaxbParse(InputStream indexStream, URL indexUrl, String rootUrlString) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.rhq.enterprise.server.xmlschema.generated.contentsource.packagedetails");
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        URL pluginSchemaURL = XmlIndexParser.class.getClassLoader().getResource(PLUGIN_SCHEMA_PATH);
        Schema pluginSchema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(pluginSchemaURL);
        unmarshaller.setSchema(pluginSchema);
        ValidationEventCollector vec = new ValidationEventCollector();
        unmarshaller.setEventHandler((ValidationEventHandler)vec);
        BufferedReader reader = new BufferedReader(new InputStreamReader(indexStream));
        JAXBElement packagesXml = (JAXBElement)unmarshaller.unmarshal((Reader)reader);
        for (ValidationEvent event : vec.getEvents()) {
            this.log.debug((Object)("URL content source index [" + indexUrl + "] message {Severity: " + event.getSeverity() + ", Message: " + event.getMessage() + ", Exception: " + event.getLinkedException() + "}"));
        }
        HashMap<String, RemotePackageInfo> fileList = new HashMap<String, RemotePackageInfo>();
        List allPackages = ((PackageType)packagesXml.getValue()).getPackage();
        for (PackageDetailsType pkg : allPackages) {
            URL locationUrl = new URL(rootUrlString + pkg.getLocation());
            ContentProviderPackageDetails details = this.translateXmlToDomain(pkg);
            FullRemotePackageInfo rpi = new FullRemotePackageInfo(locationUrl, details);
            fileList.put(this.stripLeadingSlash(rpi.getLocation()), rpi);
        }
        return fileList;
    }

    protected ContentProviderPackageDetails translateXmlToDomain(PackageDetailsType pkg) throws Exception {
        PackageDetailsKeyType keyType = pkg.getPackageDetailsKey();
        try {
            ConfigurationType extraPropertiesXml;
            ContentProviderPackageDetailsKey key = new ContentProviderPackageDetailsKey(keyType.getName(), keyType.getVersion(), keyType.getPackageTypeName(), keyType.getArchitectureName(), keyType.getResourceTypeName(), keyType.getResourceTypePlugin());
            ContentProviderPackageDetails details = new ContentProviderPackageDetails(key);
            details.setDisplayName(pkg.getDisplayName());
            details.setDisplayVersion(pkg.getDisplayVersion());
            details.setShortDescription(pkg.getShortDescription());
            details.setLongDescription(pkg.getLongDescription());
            details.setClassification(pkg.getClassification());
            details.setFileName(pkg.getFileName());
            details.setFileSize(pkg.getFileSize());
            details.setFileCreatedDate(pkg.getFileCreatedDate());
            details.setMD5(pkg.getMd5());
            details.setSHA256(pkg.getSha256());
            details.setLicenseName(pkg.getLicenseName());
            details.setLicenseVersion(pkg.getLicenseVersion());
            if (pkg.getMetadata() != null) {
                details.setMetadata(pkg.getMetadata().getBytes());
            }
            details.setLocation(pkg.getLocation());
            ResourceVersionsType resourceVersions = pkg.getResourceVersions();
            if (resourceVersions != null) {
                details.setResourceVersions(new HashSet(resourceVersions.getResourceVersion()));
            }
            if ((extraPropertiesXml = pkg.getExtraProperties()) != null) {
                Configuration config = new Configuration();
                List configXml = extraPropertiesXml.getSimplePropertyOrListPropertyOrMapProperty();
                for (Object object : configXml) {
                    if (object instanceof SimplePropertyType) {
                        config.put(this.translateSimpleProperty((SimplePropertyType)object, null));
                        continue;
                    }
                    if (object instanceof ListPropertyType) {
                        config.put(this.translateListProperty((ListPropertyType)object, null));
                        continue;
                    }
                    if (object instanceof MapPropertyType) {
                        config.put(this.translateMapProperty((MapPropertyType)object, null));
                        continue;
                    }
                    throw new IllegalStateException("Unknown JAXB type: " + object);
                }
                details.setExtraProperties(config);
            }
            return details;
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to process package [" + keyType.getName() + " v" + keyType.getVersion() + ']'));
            throw e;
        }
    }

    protected Property translateSimpleProperty(SimplePropertyType object, String defaultName) {
        String name = object.getName();
        String value = object.getValue();
        return new PropertySimple(name != null ? name : defaultName, (Object)value);
    }

    protected Property translateListProperty(ListPropertyType object, String defaultName) {
        String name = object.getName();
        List listXml = object.getSimplePropertyOrListPropertyOrMapProperty();
        PropertyList list = new PropertyList(name != null ? name : defaultName);
        for (Object listItem : listXml) {
            if (listItem instanceof SimplePropertyType) {
                list.add(this.translateSimpleProperty((SimplePropertyType)listItem, name));
                continue;
            }
            if (listItem instanceof ListPropertyType) {
                list.add(this.translateListProperty((ListPropertyType)listItem, name));
                continue;
            }
            if (listItem instanceof MapPropertyType) {
                list.add(this.translateMapProperty((MapPropertyType)listItem, name));
                continue;
            }
            throw new IllegalStateException("Unknown JAXB type: " + object);
        }
        return list;
    }

    protected Property translateMapProperty(MapPropertyType object, String defaultName) {
        String name = object.getName();
        List mapXml = object.getSimplePropertyOrListPropertyOrMapProperty();
        PropertyMap map = new PropertyMap(name != null ? name : defaultName);
        for (Object mapItem : mapXml) {
            if (mapItem instanceof SimplePropertyType) {
                map.put(this.translateSimpleProperty((SimplePropertyType)mapItem, null));
                continue;
            }
            if (mapItem instanceof ListPropertyType) {
                map.put(this.translateListProperty((ListPropertyType)mapItem, null));
                continue;
            }
            if (mapItem instanceof MapPropertyType) {
                map.put(this.translateMapProperty((MapPropertyType)mapItem, null));
                continue;
            }
            throw new IllegalStateException("Unknown JAXB type: " + object);
        }
        return map;
    }

    protected String stripLeadingSlash(String str) {
        while (str.startsWith("/")) {
            str = str.length() > 1 ? str.substring(1) : "";
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            String directoryString;
            File directory;
            if (args.length != 5) {
                System.err.println("Syntax: <directory> <packageTypeName> <archName> <resTypeName> <resTypePlugin>");
                System.exit(1);
            }
            if (!(directory = new File(directoryString = args[0])).isDirectory()) {
                System.err.println("You did not supply a valid directory name: " + directoryString);
                System.exit(1);
            }
            PackageDetailsKeyType packageTypeInfo = new PackageDetailsKeyType();
            packageTypeInfo.setPackageTypeName(args[1]);
            packageTypeInfo.setArchitectureName(args[2]);
            packageTypeInfo.setResourceTypeName(args[3]);
            packageTypeInfo.setResourceTypePlugin(args[4]);
            File index = new File(directory, "content-index.xml");
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.rhq.enterprise.server.xmlschema.generated.contentsource.packagedetails");
            Marshaller marshaller = jaxbContext.createMarshaller();
            PackageType packagesXml = new PackageType();
            PrintWriter writer = new PrintWriter(index);
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            try {
                XmlIndexParser.generatePackageIndex(directory, packagesXml.getPackage(), directory, packageTypeInfo);
                marshaller.marshal((Object)new ObjectFactory().createPackages(packagesXml), (Writer)writer);
            }
            finally {
                writer.close();
            }
        }
        catch (Throwable t) {
            System.err.println("Failed to generate content index file. Cause: " + t);
            t.printStackTrace(System.err);
            System.exit(1);
        }
    }

    protected static void generatePackageIndex(File file, List<PackageDetailsType> list, File root, PackageDetailsKeyType packageTypeInfo) throws Exception {
        if (file.isDirectory()) {
            File[] childFiles;
            for (File childFile : childFiles = file.listFiles()) {
                XmlIndexParser.generatePackageIndex(childFile, list, root, packageTypeInfo);
            }
        } else if (!file.getCanonicalPath().equals(new File(root, "content-index.xml").getCanonicalPath())) {
            String relativeLocation = file.getCanonicalPath().substring(root.getCanonicalPath().length() + 1);
            String md5 = XmlIndexParser.generateHash(file, "MD5");
            String sha256 = XmlIndexParser.generateHash(file, "SHA-256");
            PackageDetailsKeyType detailsKeyType = new PackageDetailsKeyType();
            detailsKeyType.setName(file.getName());
            detailsKeyType.setVersion(md5);
            detailsKeyType.setPackageTypeName(packageTypeInfo.getPackageTypeName());
            detailsKeyType.setArchitectureName(packageTypeInfo.getArchitectureName());
            detailsKeyType.setResourceTypeName(packageTypeInfo.getResourceTypeName());
            detailsKeyType.setResourceTypePlugin(packageTypeInfo.getResourceTypePlugin());
            PackageDetailsType detailsType = new PackageDetailsType();
            detailsType.setPackageDetailsKey(detailsKeyType);
            detailsType.setDisplayName(file.getName());
            detailsType.setDisplayVersion(md5);
            detailsType.setFileName(file.getName());
            detailsType.setFileSize(Long.valueOf(file.length()));
            detailsType.setFileCreatedDate(Long.valueOf(file.lastModified()));
            detailsType.setMd5(md5);
            detailsType.setSha256(sha256);
            detailsType.setLocation(relativeLocation);
            list.add(detailsType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String generateHash(File file, String algorithm) throws Exception {
        String hash;
        FileInputStream is = null;
        try {
            int len;
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            is = new FileInputStream(file);
            byte[] bytes = new byte[1024];
            while ((len = is.read(bytes, 0, bytes.length)) != -1) {
                messageDigest.update(bytes, 0, len);
            }
            bytes = messageDigest.digest();
            StringBuffer sb = new StringBuffer(bytes.length * 2);
            for (int i = 0; i < bytes.length; ++i) {
                int hi = bytes[i] >> 4 & 0xF;
                int lo = bytes[i] & 0xF;
                sb.append(Character.forDigit(hi, 16));
                sb.append(Character.forDigit(lo, 16));
            }
            hash = sb.toString();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return hash;
    }
}

