/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.url;

import java.net.URL;

public class RemotePackageInfo {
    private String location;
    private URL url;
    private String sha256;
    private SupportedPackageType supportedPackageType;

    public RemotePackageInfo(String location, URL url, String sha256) {
        this.location = location;
        this.url = url;
        this.sha256 = sha256;
        this.supportedPackageType = null;
    }

    public String getLocation() {
        return this.location;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getSHA256() {
        return this.sha256;
    }

    public SupportedPackageType getSupportedPackageType() {
        return this.supportedPackageType;
    }

    public void setSupportedPackageType(SupportedPackageType type) {
        this.supportedPackageType = type;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("RemotePackageInfo: ");
        str.append("location=[").append(this.location);
        str.append("], url=[").append(this.url);
        str.append("], sha256=[").append(this.sha256);
        if (this.supportedPackageType != null) {
            str.append("], supportedPackageType=[").append(this.supportedPackageType.packageTypeName);
            str.append(",").append(this.supportedPackageType.architectureName);
            str.append(",").append(this.supportedPackageType.resourceTypeName);
            str.append(",").append(this.supportedPackageType.resourceTypePluginName);
            str.append("]");
        } else {
            str.append("], supportedPackageType=[unknown]");
        }
        return str.toString();
    }

    public static class SupportedPackageType {
        public String packageTypeName;
        public String architectureName;
        public String resourceTypeName;
        public String resourceTypePluginName;
    }
}

