/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.url;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.enterprise.server.plugins.url.IndexParser;
import org.rhq.enterprise.server.plugins.url.RemotePackageInfo;
import org.rhq.enterprise.server.plugins.url.UrlProvider;

public class SimpleIndexParser
implements IndexParser {
    @Override
    public Map<String, RemotePackageInfo> parse(InputStream indexStream, UrlProvider contentSource) throws Exception {
        HashMap<String, RemotePackageInfo> fileList = new HashMap<String, RemotePackageInfo>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(indexStream));
        String line = reader.readLine();
        while (line != null) {
            String[] locationAndSHA256;
            while (line.startsWith("/")) {
                line = line.length() > 1 ? line.substring(1) : "";
            }
            if (line.length() > 0 && (locationAndSHA256 = line.split("\\|")).length == 2) {
                URL locationUrl = new URL(contentSource.getRootUrl().toString() + locationAndSHA256[0]);
                RemotePackageInfo rpi = new RemotePackageInfo(locationAndSHA256[0], locationUrl, locationAndSHA256[1]);
                fileList.put(rpi.getLocation(), rpi);
            }
            line = reader.readLine();
        }
        return fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            String directoryString;
            File directory;
            if (args.length == 0) {
                System.err.println("You must provide the directory name where the content can be found.");
                System.exit(1);
            }
            if (!(directory = new File(directoryString = args[0])).isDirectory()) {
                System.err.println("You did not supply a valid directory name: " + directoryString);
                System.exit(1);
            }
            File index = new File(directory, "content-index.txt");
            PrintWriter writer = new PrintWriter(index);
            try {
                SimpleIndexParser.generatePackageIndex(directory, writer, directory);
            }
            finally {
                writer.close();
            }
        }
        catch (Throwable t) {
            System.err.println("Failed to generate content index file. Cause: " + t);
            t.printStackTrace(System.err);
            System.exit(1);
        }
    }

    protected static void generatePackageIndex(File file, PrintWriter indexWriter, File root) throws Exception {
        if (file.isDirectory()) {
            File[] childFiles;
            for (File childFile : childFiles = file.listFiles()) {
                SimpleIndexParser.generatePackageIndex(childFile, indexWriter, root);
            }
        } else if (!file.getCanonicalPath().equals(new File(root, "content-index.txt").getCanonicalPath())) {
            String location = file.getCanonicalPath().substring(root.getCanonicalPath().length() + 1);
            MessageDigestGenerator messageDigestGenerator = new MessageDigestGenerator("SHA-256");
            String sha256 = messageDigestGenerator.calcDigestString(file);
            indexWriter.println(location.replace('\\', '/') + '|' + sha256);
        }
    }
}

