/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.test.shrinkwrap;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchiveFormat;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.NamedAsset;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.formatter.Formatter;
import org.jboss.shrinkwrap.impl.base.ArchiveBase;
import org.jboss.shrinkwrap.spi.Configurable;
import org.rhq.test.shrinkwrap.AndFilter;
import org.rhq.test.shrinkwrap.FilteredView;

public class FilteredViewImpl
extends ArchiveBase<FilteredView>
implements FilteredView {
    private Filter<ArchivePath> filter;
    private final Archive<?> archive;

    public FilteredViewImpl(Archive<?> archive) {
        super(archive.getName(), ((Configurable)archive.as(Configurable.class)).getConfiguration());
        this.archive = archive;
    }

    public final <T extends Assignable> T as(Class<T> type) {
        return (T)this.getConfiguration().getExtensionLoader().load(type, (Archive)this);
    }

    protected final Archive<?> getArchive() {
        return this.archive;
    }

    public Configuration getConfiguration() {
        return ((Configurable)this.archive.as(Configurable.class)).getConfiguration();
    }

    @Override
    public FilteredView filterContents(Filter<ArchivePath> filter) {
        this.filter = filter;
        return this;
    }

    protected Class<FilteredView> getActualClass() {
        return FilteredView.class;
    }

    public FilteredView add(Asset asset, ArchivePath target) throws IllegalArgumentException {
        this.getArchive().add(asset, target);
        return this;
    }

    public FilteredView add(Asset asset, ArchivePath target, String name) throws IllegalArgumentException {
        this.getArchive().add(asset, target, name);
        return this;
    }

    public FilteredView add(Asset asset, String target, String name) throws IllegalArgumentException {
        this.getArchive().add(asset, target, name);
        return this;
    }

    public FilteredView add(NamedAsset namedAsset) throws IllegalArgumentException {
        this.getArchive().add(namedAsset);
        return this;
    }

    public FilteredView add(Asset asset, String target) throws IllegalArgumentException {
        this.getArchive().add(asset, target);
        return this;
    }

    public FilteredView addAsDirectory(String path) throws IllegalArgumentException {
        this.getArchive().addAsDirectory(path);
        return this;
    }

    public FilteredView addAsDirectories(String ... paths) throws IllegalArgumentException {
        this.getArchive().addAsDirectories(paths);
        return this;
    }

    public FilteredView addAsDirectory(ArchivePath path) throws IllegalArgumentException {
        this.getArchive().addAsDirectory(path);
        return this;
    }

    public FilteredView addAsDirectories(ArchivePath ... paths) throws IllegalArgumentException {
        this.getArchive().addAsDirectories(paths);
        return this;
    }

    public Node get(ArchivePath path) throws IllegalArgumentException {
        if (this.conforms(path)) {
            return new FilteringNode(this.getArchive().get(path));
        }
        return null;
    }

    public Node get(String path) throws IllegalArgumentException {
        if (this.conforms(path)) {
            return new FilteringNode(this.getArchive().get(path));
        }
        return null;
    }

    public <X extends Archive<X>> X getAsType(Class<X> type, String path) {
        if (this.conforms(path)) {
            return (X)this.getArchive().getAsType(type, path);
        }
        return null;
    }

    public <X extends Archive<X>> X getAsType(Class<X> type, ArchivePath path) {
        if (this.conforms(path)) {
            return (X)this.getArchive().getAsType(type, path);
        }
        return null;
    }

    public <X extends Archive<X>> Collection<X> getAsType(Class<X> type, Filter<ArchivePath> filter) {
        Filter<ArchivePath> f = filter;
        if (this.filter != null) {
            f = new AndFilter<ArchivePath>(filter, this.filter);
        }
        return this.getArchive().getAsType(type, f);
    }

    public <X extends Archive<X>> X getAsType(Class<X> type, String path, ArchiveFormat archiveFormat) {
        if (this.conforms(path)) {
            return (X)this.getArchive().getAsType(type, path, archiveFormat);
        }
        return null;
    }

    public <X extends Archive<X>> X getAsType(Class<X> type, ArchivePath path, ArchiveFormat archiveFormat) {
        if (this.conforms(path)) {
            return (X)this.getArchive().getAsType(type, path, archiveFormat);
        }
        return null;
    }

    public <X extends Archive<X>> Collection<X> getAsType(Class<X> type, Filter<ArchivePath> filter, ArchiveFormat archiveFormat) {
        Filter<ArchivePath> f = filter;
        if (this.filter != null) {
            f = new AndFilter<ArchivePath>(filter, this.filter);
        }
        return this.getArchive().getAsType(type, f, archiveFormat);
    }

    public boolean contains(ArchivePath path) throws IllegalArgumentException {
        if (this.conforms(path)) {
            return this.getArchive().contains(path);
        }
        return false;
    }

    public boolean contains(String path) throws IllegalArgumentException {
        if (this.conforms(path)) {
            return this.getArchive().contains(path);
        }
        return false;
    }

    public Node delete(ArchivePath path) throws IllegalArgumentException {
        return this.getArchive().delete(path);
    }

    public Node delete(String archivePath) throws IllegalArgumentException {
        return this.getArchive().delete(archivePath);
    }

    public Map<ArchivePath, Node> getContent() {
        if (this.filter == null) {
            return this.getArchive().getContent();
        }
        return this.getArchive().getContent(this.filter);
    }

    public Map<ArchivePath, Node> getContent(Filter<ArchivePath> filter) {
        Filter<ArchivePath> f = filter;
        if (this.filter != null) {
            f = new AndFilter<ArchivePath>(filter, this.filter);
        }
        return this.getArchive().getContent(f);
    }

    public FilteredView add(Archive<?> archive, ArchivePath path, Class<? extends StreamExporter> exporter) throws IllegalArgumentException {
        this.getArchive().add(archive, path, exporter);
        return this;
    }

    public FilteredView add(Archive<?> archive, String path, Class<? extends StreamExporter> exporter) throws IllegalArgumentException {
        this.getArchive().add(archive, path, exporter);
        return this;
    }

    public FilteredView merge(Archive<?> source) throws IllegalArgumentException {
        this.getArchive().merge(source);
        return this;
    }

    public FilteredView merge(Archive<?> source, Filter<ArchivePath> filter) throws IllegalArgumentException {
        this.getArchive().merge(source, filter);
        return this;
    }

    public FilteredView merge(Archive<?> source, ArchivePath path) throws IllegalArgumentException {
        this.getArchive().merge(source, path);
        return this;
    }

    public FilteredView merge(Archive<?> source, String path) throws IllegalArgumentException {
        this.getArchive().merge(source, path);
        return this;
    }

    public FilteredView merge(Archive<?> source, ArchivePath path, Filter<ArchivePath> filter) throws IllegalArgumentException {
        this.getArchive().merge(source, path, filter);
        return this;
    }

    public FilteredView merge(Archive<?> source, String path, Filter<ArchivePath> filter) throws IllegalArgumentException {
        this.getArchive().merge(source, path, filter);
        return this;
    }

    public String toString() {
        return this.getArchive().toString();
    }

    public String toString(boolean verbose) {
        return this.getArchive().toString(verbose);
    }

    public String toString(Formatter formatter) throws IllegalArgumentException {
        return this.getArchive().toString(formatter);
    }

    public void writeTo(OutputStream outputStream, Formatter formatter) throws IllegalArgumentException {
        this.getArchive().writeTo(outputStream, formatter);
    }

    private boolean conforms(ArchivePath path) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.include((Object)path);
    }

    private boolean conforms(String path) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.include((Object)ArchivePaths.create((String)path));
    }

    private class FilteringNode
    implements Node {
        private Node orig;

        public FilteringNode(Node orig) {
            this.orig = orig;
        }

        public Asset getAsset() {
            return this.orig.getAsset();
        }

        public Set<Node> getChildren() {
            if (FilteredViewImpl.this.filter == null) {
                return this.wrap(this.orig.getChildren());
            }
            Set children = this.orig.getChildren();
            LinkedHashSet<FilteringNode> ret = new LinkedHashSet<FilteringNode>();
            for (Node child : children) {
                if (!FilteredViewImpl.this.conforms(child.getPath())) continue;
                ret.add(new FilteringNode(child));
            }
            return Collections.unmodifiableSet(ret);
        }

        public ArchivePath getPath() {
            return this.orig.getPath();
        }

        public Set<Node> wrap(Set<Node> nodes) {
            LinkedHashSet<Node> ret = new LinkedHashSet<Node>(nodes.size());
            for (Node n : nodes) {
                ret.add(new FilteringNode(n));
            }
            return ret;
        }
    }
}

