/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.test.shrinkwrap;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.EventFilter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.container.ContainerBase;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.rhq.core.clientapi.agent.metadata.PluginDependencyGraph;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.test.shrinkwrap.RhqAgentPluginArchive;

public class RhqAgentPluginArchiveImpl
extends ContainerBase<RhqAgentPluginArchive>
implements RhqAgentPluginArchive {
    private static final Log LOG = LogFactory.getLog(RhqAgentPluginArchiveImpl.class);
    private static final ArchivePath PATH_MANIFEST = new BasicPath("META-INF");
    private static final ArchivePath PATH_RESOURCE = new BasicPath("/");
    private static final ArchivePath PATH_CLASSES = new BasicPath("/");
    private static final ArchivePath LIBRARY_PATH = new BasicPath("/lib");
    private static final ArchivePath REQUIRED_PLUGINS_PATH = new BasicPath(PATH_MANIFEST, "######REQUIRED_PLUGINS");
    private static final ArchivePath PLUGIN_DESCRIPTOR_PATH = new BasicPath(PATH_MANIFEST, "rhq-plugin.xml");

    public RhqAgentPluginArchiveImpl(Archive<?> delegate) {
        super(RhqAgentPluginArchive.class, delegate);
    }

    @Override
    public ArchivePath getRequiredPluginsPath() {
        return REQUIRED_PLUGINS_PATH;
    }

    protected ArchivePath getManifestPath() {
        return PATH_MANIFEST;
    }

    protected ArchivePath getClassesPath() {
        return PATH_CLASSES;
    }

    protected ArchivePath getResourcePath() {
        return PATH_RESOURCE;
    }

    public ArchivePath getLibraryPath() {
        return LIBRARY_PATH;
    }

    @Override
    public RhqAgentPluginArchive setPluginDescriptorFromTemplate(String resourceName, Map<String, String> replacementValues) throws IllegalArgumentException {
        File newDescriptorFile;
        Validate.notNull((Object)resourceName, (String)"resourceName should be specified");
        Validate.notNull(replacementValues, (String)"replacementValues should be specified");
        String templateXml = new String(StreamUtil.slurp((InputStream)new ClassLoaderAsset(resourceName).openStream()));
        for (Map.Entry<String, String> entry : replacementValues.entrySet()) {
            templateXml = templateXml.replace(entry.getKey(), entry.getValue());
        }
        try {
            newDescriptorFile = File.createTempFile(resourceName.replace(".xml", ""), ".xml");
            StreamUtil.copy((InputStream)new ByteArrayInputStream(templateXml.getBytes()), (OutputStream)new FileOutputStream(newDescriptorFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.setPluginDescriptor(newDescriptorFile);
    }

    @Override
    public RhqAgentPluginArchive setPluginDescriptor(String resourceName) throws IllegalArgumentException {
        Validate.notNull((Object)resourceName, (String)"ResourceName should be specified");
        return this.setPluginDescriptor((Asset)new ClassLoaderAsset(resourceName));
    }

    @Override
    public RhqAgentPluginArchive setPluginDescriptor(File file) throws IllegalArgumentException {
        Validate.notNull((Object)file, (String)"File should be specified");
        return this.setPluginDescriptor((Asset)new FileAsset(file));
    }

    @Override
    public RhqAgentPluginArchive setPluginDescriptor(URL url) throws IllegalArgumentException {
        Validate.notNull((Object)url, (String)"URL should be specified");
        return this.setPluginDescriptor((Asset)new UrlAsset(url));
    }

    @Override
    public RhqAgentPluginArchive setPluginDescriptor(Asset asset) throws IllegalArgumentException {
        Validate.notNull((Object)asset, (String)"Asset should be specified");
        return (RhqAgentPluginArchive)this.add(asset, PLUGIN_DESCRIPTOR_PATH);
    }

    @Override
    public RhqAgentPluginArchive withRequiredPluginsFrom(Collection<? extends Archive<?>> archives) throws IllegalArgumentException {
        String pluginName;
        this.delete(REQUIRED_PLUGINS_PATH);
        Node descriptor = this.get(PLUGIN_DESCRIPTOR_PATH);
        if (descriptor == null) {
            return this;
        }
        HashMap plugins = new HashMap();
        String myPluginName = pluginName = RhqAgentPluginArchiveImpl.getPluginName(this);
        plugins.put(pluginName, this);
        for (Archive<?> ar : archives) {
            if (!RhqAgentPluginArchiveImpl.isPlugin(ar)) continue;
            pluginName = RhqAgentPluginArchiveImpl.getPluginName(ar);
            plugins.put(pluginName, ar);
        }
        PluginDependencyGraph pdg = new PluginDependencyGraph();
        this.buildRequiredPlugins(this, plugins, pdg);
        for (String pn : pdg.getAllDependencies(myPluginName)) {
            Archive p = (Archive)plugins.get(pn);
            this.add(p, REQUIRED_PLUGINS_PATH, ZipExporter.class);
        }
        return this;
    }

    @Override
    public RhqAgentPluginArchive withRequiredPluginsFrom(Archive<?> ... archives) throws IllegalArgumentException {
        return this.withRequiredPluginsFrom(Arrays.asList(archives));
    }

    @Override
    public List<Archive<?>> getRequiredPlugins() {
        Node requiredPluginsRoot = this.get(REQUIRED_PLUGINS_PATH);
        if (requiredPluginsRoot == null) {
            return null;
        }
        ArrayList ret = new ArrayList();
        for (Node plugin : requiredPluginsRoot.getChildren()) {
            Asset a = plugin.getAsset();
            if (!(a instanceof ArchiveAsset)) continue;
            ret.add(((ArchiveAsset)a).getArchive());
        }
        return ret;
    }

    private List<PluginDependencyGraph.PluginDependency> asPdgPd(List<? extends PluginDependencyGraph.PluginDependency> source) {
        return source;
    }

    private void buildRequiredPlugins(Archive<?> archive, Map<String, Archive<?>> allAvailableArchives, PluginDependencyGraph graph) {
        List<PluginDep> requiredPlugins = RhqAgentPluginArchiveImpl.getRequiredPlugins(archive);
        String pluginName = RhqAgentPluginArchiveImpl.getPluginName(archive);
        graph.addPlugin(pluginName, this.asPdgPd(requiredPlugins));
        for (PluginDep pd : requiredPlugins) {
            Archive<?> a = allAvailableArchives.get(pd.name);
            this.buildRequiredPlugins(a, allAvailableArchives, graph);
        }
    }

    private static void closeReaderAndStream(XMLEventReader rdr, InputStream str, Archive<?> archive) {
        if (rdr != null) {
            try {
                rdr.close();
            }
            catch (XMLStreamException e) {
                LOG.error((Object)("Failed to close the XML reader of the plugin descriptor in archive [" + archive + "]"), (Throwable)e);
            }
        }
        try {
            str.close();
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to close the input stream of the plugin descriptor in archive [" + archive + "]"), (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<PluginDep> getRequiredPlugins(Archive<?> archive) {
        ArrayList<PluginDep> arrayList;
        ArrayList<PluginDep> ret = new ArrayList<PluginDep>();
        InputStream is = archive.get(PLUGIN_DESCRIPTOR_PATH).getAsset().openStream();
        XMLEventReader rdr = null;
        try {
            XMLEvent e;
            XMLInputFactory f = XMLInputFactory.newInstance();
            XMLEventReader r = f.createXMLEventReader(is);
            rdr = f.createFilteredReader(r, new EventFilter(){

                @Override
                public boolean accept(XMLEvent event) {
                    switch (event.getEventType()) {
                        case 1: 
                        case 8: {
                            return true;
                        }
                    }
                    return false;
                }
            });
            while ((e = rdr.nextEvent()) != null && e.getEventType() != 8) {
                Attribute useClassesAttr;
                StartElement el = e.asStartElement();
                if (!el.getName().getLocalPart().equals("depends")) continue;
                Attribute pluginAttr = el.getAttributeByName(new QName("plugin"));
                if (pluginAttr == null) {
                    throw new IllegalArgumentException("Couldn't find the 'plugin' attribute on a 'depends' element in the plugin descriptor of plugin '" + archive + "'.");
                }
                String pluginName = pluginAttr.getValue();
                boolean required = true;
                boolean useClasses = false;
                Attribute requiredAttr = el.getAttributeByName(new QName("required"));
                if (requiredAttr != null) {
                    required = Boolean.parseBoolean(requiredAttr.getValue());
                }
                if ((useClassesAttr = el.getAttributeByName(new QName("useClasses"))) != null) {
                    useClasses = Boolean.parseBoolean(useClassesAttr.getValue());
                }
                ret.add(new PluginDep(pluginName, useClasses, required));
            }
            arrayList = ret;
        }
        catch (XMLStreamException e) {
            try {
                throw new IllegalArgumentException("Failed to extract the required plugin names out of the RHQ plugin archive [" + archive + "]", e);
                catch (FactoryConfigurationError e2) {
                    throw new IllegalArgumentException("Failed to extract the required plugin name out of the RHQ plugin archive [" + archive + "]", e2);
                }
            }
            catch (Throwable throwable) {
                RhqAgentPluginArchiveImpl.closeReaderAndStream(rdr, is, archive);
                throw throwable;
            }
        }
        RhqAgentPluginArchiveImpl.closeReaderAndStream(rdr, is, archive);
        return arrayList;
    }

    private static boolean isPlugin(Archive<?> archive) {
        return archive.contains(PLUGIN_DESCRIPTOR_PATH);
    }

    private static String getPluginName(Archive<?> archive) {
        InputStream is = archive.get(PLUGIN_DESCRIPTOR_PATH).getAsset().openStream();
        XMLEventReader rdr = null;
        try {
            rdr = XMLInputFactory.newInstance().createXMLEventReader(is);
            XMLEvent event = null;
            while (rdr.hasNext() && (event = rdr.nextEvent()).getEventType() != 1) {
            }
            StartElement startElement = event.asStartElement();
            String tagName = startElement.getName().getLocalPart();
            if (!"plugin".equals(tagName)) {
                throw new IllegalArgumentException("Illegal start tag found in the plugin descriptor. Expected 'plugin' but found '" + tagName + "' in the plugin '" + archive + "'.");
            }
            Attribute nameAttr = startElement.getAttributeByName(new QName("name"));
            if (nameAttr == null) {
                throw new IllegalArgumentException("Couldn't find the name attribute on the plugin tag in the plugin descriptor of plugin '" + archive + "'.");
            }
            String string = nameAttr.getValue();
            return string;
        }
        catch (XMLStreamException e) {
            throw new IllegalArgumentException("Failed to extract the plugin name out of the RHQ plugin archive [" + archive + "]", e);
        }
        catch (FactoryConfigurationError e) {
            throw new IllegalArgumentException("Failed to extract the plugin name out of the RHQ plugin archive [" + archive + "]", e);
        }
        finally {
            RhqAgentPluginArchiveImpl.closeReaderAndStream(rdr, is, archive);
        }
    }

    private static class PluginDep
    extends PluginDependencyGraph.PluginDependency {
        public String name;

        public PluginDep(String name) {
            super(name);
            this.name = name;
        }

        public PluginDep(String name, boolean useClasses, boolean required) {
            super(name, useClasses, required);
            this.name = name;
        }
    }
}

