/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.sshd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import net.augeas.Augeas;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.util.ObjectUtil;
import org.rhq.core.system.AggregateProcessInfo;
import org.rhq.core.system.NetworkStats;
import org.rhq.core.system.ProcessInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSSHDComponent
implements ResourceComponent,
ConfigurationFacet,
MeasurementFacet {
    private ResourceContext resourceContext;
    private AggregateProcessInfo processInfo;

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
        this.getSSHDProcess();
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return this.processInfo.isRunning() ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    private void getSSHDProcess() {
        List procs = this.resourceContext.getSystemInformation().getProcesses("process|basename|match=sshd,process|basename|nomatch|parent=sshd");
        if (procs.size() == 1) {
            this.processInfo = ((ProcessInfo)procs.get(0)).getAggregateProcessTree();
        }
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration pluginConfiguration = this.resourceContext.getPluginConfiguration();
        ConfigurationDefinition resourceConfigurationDefinition = this.resourceContext.getResourceType().getResourceConfigurationDefinition();
        return this.loadResourceConfiguration(pluginConfiguration, resourceConfigurationDefinition);
    }

    public Configuration loadResourceConfiguration(Configuration pluginConfiguration, ConfigurationDefinition resourceConfigurationDefinition) throws Exception {
        List matches;
        PropertySimple lensesPathProperty = pluginConfiguration.getSimple("lenses-path");
        if (lensesPathProperty == null) {
            throw new Exception("Lenses path not found in plugin configuration, cannot retrieve configuration");
        }
        PropertySimple rootPathProperty = pluginConfiguration.getSimple("root-path");
        if (rootPathProperty == null) {
            throw new Exception("Root path not found in plugin configuration, cannot retrieve configuration");
        }
        String lensesPath = lensesPathProperty.getStringValue();
        String rootPath = rootPathProperty.getStringValue();
        Augeas augeas = new Augeas(rootPath, lensesPath);
        PropertySimple sshdPathProperty = pluginConfiguration.getSimple("config-path");
        if (sshdPathProperty == null) {
            throw new Exception("SSHD configuration path not found in plugin configuration, cannot retrive configuration");
        }
        String sshdPath = sshdPathProperty.getStringValue();
        if (!sshdPath.endsWith("/")) {
            sshdPath = sshdPath + "/";
        }
        if ((matches = augeas.match(sshdPath + "*")).size() == 0) {
            throw new Exception("Unable to load sshd_config data from augeas");
        }
        Collection properties = resourceConfigurationDefinition.getPropertyDefinitions().values();
        Configuration config = new Configuration();
        config.setNotes("Loaded from Augeas at " + new Date());
        for (PropertyDefinition p : properties) {
            if (p instanceof PropertyDefinitionSimple) {
                PropertyDefinitionSimple property = (PropertyDefinitionSimple)p;
                String value = augeas.get(sshdPath + property.getName());
                if (value == null) continue;
                if (property.getType() == PropertySimpleType.BOOLEAN) {
                    config.put((Property)new PropertySimple(property.getName(), (Object)value.equalsIgnoreCase("yes")));
                    continue;
                }
                config.put((Property)new PropertySimple(property.getName(), (Object)value));
                continue;
            }
            if (!(p instanceof PropertyDefinitionList)) continue;
            PropertyDefinitionList listDef = (PropertyDefinitionList)p;
            PropertyDefinitionMap mapDef = (PropertyDefinitionMap)listDef.getMemberDefinition();
            PropertyDefinitionSimple simpleDef = (PropertyDefinitionSimple)mapDef.getPropertyDefinitions().values().iterator().next();
            String name = simpleDef.getName();
            ArrayList<String> allValues = new ArrayList<String>();
            List tests = augeas.match(sshdPath + "*");
            for (String test : tests) {
                if (!test.matches(sshdPath + name + ".*")) continue;
                String data = augeas.get(test);
                allValues.addAll(Arrays.asList(data.split(" ")));
            }
            PropertyList list = new PropertyList(listDef.getName());
            for (String value : allValues) {
                PropertyMap map = new PropertyMap(mapDef.getName(), new Property[]{new PropertySimple(simpleDef.getName(), (Object)value)});
                list.add((Property)map);
            }
        }
        return config;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        NetworkStats stats = this.resourceContext.getSystemInformation().getNetworkStats("localhost", 22);
        this.processInfo.refresh();
        for (MeasurementScheduleRequest request : metrics) {
            if (request.getName().startsWith("NetworkStat.")) {
                int val = stats.getByName(request.getName().substring("NetworkStat.".length()));
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(val)));
                continue;
            }
            if (!request.getName().startsWith("Process.")) continue;
            Double value = ObjectUtil.lookupDeepNumericAttributeProperty((Object)this.processInfo, (String)request.getName().substring("Process.".length()));
            report.addData(new MeasurementDataNumeric(request, value));
        }
    }
}

