/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.twitter;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.event.EventContext;
import org.rhq.core.pluginapi.event.EventPoller;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.twitter.TwitterEventPoller;
import twitter4j.Paging;
import twitter4j.Status;
import twitter4j.Twitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwitterComponent
implements ResourceComponent,
OperationFacet,
MeasurementFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String TWIT_EVENT = "TwitterEvent";
    private static final int NOT_YET_SET = -1;
    EventContext eventContext;
    private String username;
    private String password;
    private String serverUrl;
    private String searchBaseUrl;
    private TwitterEventPoller eventPoller;
    private long lastId = -1L;
    private static final String HTTP_TWITTER_COM = "http://twitter.com/";

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public void start(ResourceContext context) throws Exception {
        Configuration conf = context.getPluginConfiguration();
        this.username = conf.getSimpleValue("user", null);
        this.password = conf.getSimpleValue("password", null);
        String url = conf.getSimpleValue("baseurl", HTTP_TWITTER_COM);
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        try {
            new URL(url);
            this.serverUrl = url;
        }
        catch (MalformedURLException e) {
            throw new InvalidPluginConfigurationException(e.getMessage());
        }
        url = conf.getSimpleValue("searchBaseUrl", "http://search.twitter.com/");
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        try {
            new URL(url);
            this.searchBaseUrl = url;
        }
        catch (MalformedURLException e) {
            throw new InvalidPluginConfigurationException(e.getMessage());
        }
        this.eventContext = context.getEventContext();
        this.eventPoller = new TwitterEventPoller(TWIT_EVENT);
        this.eventContext.registerEventPoller((EventPoller)this.eventPoller, 53);
    }

    public void stop() {
        this.eventContext.unregisterEventPoller(TWIT_EVENT);
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        for (MeasurementScheduleRequest req : metrics) {
            Twitter twitter;
            if (req.getName().equals("tweetCount")) {
                twitter = new Twitter(this.username, this.password, this.serverUrl);
                Paging paging = new Paging();
                if (this.lastId == -1L) {
                    paging.setSinceId(1);
                    paging.setCount(1);
                } else {
                    paging.setSinceId(this.lastId);
                    paging.setCount(100);
                }
                List statuses = twitter.getFriendsTimeline(paging);
                if (this.lastId > 0L) {
                    MeasurementDataNumeric res = new MeasurementDataNumeric(req, Double.valueOf(statuses.size()));
                    this.eventPoller.addStatuses(statuses);
                    report.addData(res);
                }
                if (statuses.size() <= 0) continue;
                this.lastId = ((Status)statuses.get(0)).getId();
                continue;
            }
            if (!req.getName().equals("followerCount")) continue;
            twitter = new Twitter(this.username, this.password, this.serverUrl);
            int count = twitter.getFollowersIDs().getIDs().length;
            MeasurementDataNumeric res = new MeasurementDataNumeric(req, Double.valueOf(count));
            report.addData(res);
        }
    }

    public OperationResult invokeOperation(String name, Configuration configuration) throws Exception {
        if (name != null && name.equals("postStatus")) {
            if (this.username == null || this.password == null) {
                throw new IllegalArgumentException("User or password were not set");
            }
            String message = configuration.getSimpleValue("message", null);
            Twitter twitter = new Twitter(this.username, this.password, this.serverUrl);
            twitter.setSource("Jopr");
            twitter.setUserAgent("Jopr");
            Status status = twitter.updateStatus(message);
            OperationResult result = new OperationResult("Posted " + status.getText());
            return result;
        }
        throw new UnsupportedOperationException("Operation " + name + " is not valid");
    }

    protected String getServerUrl() {
        return this.serverUrl;
    }

    protected String getSearchUrl() {
        return this.searchBaseUrl;
    }
}

