/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.virt;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.virt.DomainConfigurationEditor;
import org.rhq.plugins.virt.LibVirtConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualizationComponent
implements ResourceComponent,
MeasurementFacet,
OperationFacet,
ConfigurationFacet,
CreateChildResourceFacet {
    private Log log = LogFactory.getLog(VirtualizationComponent.class);
    private LibVirtConnection virt;
    private String domainName;
    private long cpuNanosLast;
    private long cpuCheckedLast;
    private AvailabilityType lastAvailability = AvailabilityType.DOWN;

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.virt = new LibVirtConnection();
        this.domainName = resourceContext.getResourceKey();
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        String state = String.valueOf(this.virt.getDomainInfo((String)this.domainName).domainInfo.state);
        if (state.equals("1") || state.equals("2")) {
            this.lastAvailability = AvailabilityType.UP;
        } else {
            if (state.equals("0")) {
                return this.lastAvailability;
            }
            this.lastAvailability = AvailabilityType.DOWN;
        }
        return this.lastAvailability;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        for (MeasurementScheduleRequest request : metrics) {
            if (request.getName().equals("cpuTime")) {
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(this.virt.getDomainInfo((String)this.domainName).domainInfo.cpuTime)));
                continue;
            }
            if (request.getName().equals("cpuPercentage")) {
                long checked = System.nanoTime();
                long cpuNanos = this.virt.getDomainInfo((String)this.domainName).domainInfo.cpuTime;
                if (this.cpuCheckedLast != 0L) {
                    long duration = checked - this.cpuCheckedLast;
                    long diff = cpuNanos - this.cpuNanosLast;
                    double percentage = (double)diff / (double)duration;
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(percentage)));
                }
                this.cpuCheckedLast = checked;
                this.cpuNanosLast = cpuNanos;
                continue;
            }
            if (!request.getName().equals("memoryUsage")) continue;
            report.addData(new MeasurementDataNumeric(request, Double.valueOf(this.virt.getDomainInfo((String)this.domainName).domainInfo.memory.longValue())));
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        int result = -1;
        this.log.info((Object)("Executing " + name + " operation on domain " + this.getDomainName()));
        if (name.equals("reboot")) {
            result = this.virt.domainReboot(this.domainName);
        } else if (name.equals("restore")) {
            result = this.virt.domainRestore(parameters.getSimpleValue("fromPath", null));
        } else if (name.equals("resume")) {
            result = this.virt.domainResume(this.domainName);
        } else if (name.equals("save")) {
            result = this.virt.domainSave(this.domainName, parameters.getSimpleValue("toPath", null));
        } else if (name.equals("shutdown")) {
            result = this.virt.domainShutdown(this.domainName);
        } else if (name.equals("suspend")) {
            result = this.virt.domainSuspend(this.domainName);
        } else if (name.equals("create")) {
            result = this.virt.domainCreate(this.domainName);
        }
        if (result < 0) {
            throw new Exception("Failed to run " + name + " command. Result was: " + result);
        }
        return new OperationResult();
    }

    public Configuration loadResourceConfiguration() {
        String xml = this.virt.getDomainXML(this.domainName);
        return DomainConfigurationEditor.getConfiguration(xml);
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        String xml = this.virt.getDomainXML(this.domainName);
        Configuration oldConfig = this.loadResourceConfiguration();
        Configuration newConfig = report.getConfiguration();
        String newXml = DomainConfigurationEditor.updateXML(report.getConfiguration(), xml);
        this.log.info((Object)"Calling libvirt to redefine domain");
        if (!this.virt.defineDomain(newXml)) {
            this.log.warn((Object)"Call to redefine domain did not return a domain pointer");
        }
        if (!oldConfig.getSimple("memory").getLongValue().equals(newConfig.getSimple("memory").getLongValue())) {
            this.virt.setMaxMemory(this.domainName, newConfig.getSimple("memory").getLongValue());
        }
        if (!oldConfig.getSimple("currentMemory").getLongValue().equals(newConfig.getSimple("currentMemory").getLongValue())) {
            this.virt.setMemory(this.domainName, newConfig.getSimple("currentMemory").getLongValue());
        }
        if (!oldConfig.getSimple("vcpu").getIntegerValue().equals(newConfig.getSimple("vcpu").getIntegerValue())) {
            this.virt.setVcpus(this.domainName, newConfig.getSimple("vcpu").getIntegerValue());
        }
        report.setStatus(ConfigurationUpdateStatus.SUCCESS);
    }

    public CreateResourceReport createResource(CreateResourceReport report) {
        String xml = DomainConfigurationEditor.getXml(report.getResourceConfiguration());
        this.log.info((Object)"Defining new domain");
        this.log.debug((Object)("New virtualization domain xml:\n" + xml));
        this.virt.defineDomain(xml);
        report.setStatus(CreateResourceStatus.SUCCESS);
        return report;
    }

    public LibVirtConnection getConnection() {
        return this.virt;
    }

    public String getDomainName() {
        return this.domainName;
    }
}

