/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.virt;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.plugins.virt.LibVirt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibVirtConnection {
    private LibVirt.ConnectionPointer connectionPointer;
    private Log log = LogFactory.getLog(LibVirtConnection.class);

    public LibVirtConnection() {
        LibVirt virtInstance = LibVirt.INSTANCE;
        if (virtInstance == null) {
            this.log.warn((Object)"Can not obtain an instance of libvirt");
            return;
        }
        this.connectionPointer = virtInstance.virConnectOpen(null);
        if (this.connectionPointer == null) {
            this.log.warn((Object)"Couldn't created authorized access to libvirt, using read only access");
            this.connectionPointer = LibVirt.INSTANCE.virConnectOpenReadOnly(null);
        }
    }

    public List<String> getDomainNames() {
        LibVirt virtInstance = LibVirt.INSTANCE;
        if (virtInstance == null) {
            return new ArrayList<String>();
        }
        String[] names = new String[100];
        for (int i = 0; i < 100; ++i) {
            names[i] = new String();
        }
        int code = virtInstance.virConnectListDefinedDomains(this.connectionPointer, names, 100);
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < code; ++i) {
            results.add(names[i]);
        }
        return results;
    }

    public static void main(String[] args) {
        LibVirtConnection c = new LibVirtConnection();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LibVirt virtInstance = LibVirt.INSTANCE;
        if (virtInstance != null) {
            virtInstance.virConnectClose(this.connectionPointer);
        }
    }

    public int[] getDomainIds() throws Exception {
        int[] ids = new int[100];
        int result = LibVirt.INSTANCE.virConnectListDomains(this.connectionPointer, ids, 100);
        if (result < 0) {
            throw new Exception("Couldn't list domain ids");
        }
        int[] found = new int[result];
        for (int i = 0; i < result; ++i) {
            found[i] = ids[i];
        }
        return found;
    }

    public void printDomainInfo(DomainInfo domainInfo) {
        System.out.println("\tDOMAIN INFO: \n\tstate=" + String.valueOf(domainInfo.domainInfo.state) + "\n\tmem=" + domainInfo.domainInfo.maxMem.longValue() + "\n\tfree=" + domainInfo.domainInfo.memory.longValue() + "\n\tCPUs=" + domainInfo.domainInfo.nrVirtCpu + "\n\tcpu=" + domainInfo.domainInfo.cpuTime);
    }

    public DomainInfo getDomainInfo(String domainName) {
        LibVirt.DomainPointer domainPointer = LibVirt.INSTANCE.virDomainLookupByName(this.connectionPointer, domainName);
        DomainInfo info = new DomainInfo();
        info.name = LibVirt.INSTANCE.virDomainGetName(domainPointer);
        LibVirt.VirDomainInfo domainInfo = new LibVirt.VirDomainInfo();
        int result = LibVirt.INSTANCE.virDomainGetInfo(domainPointer, domainInfo);
        info.domainInfo = domainInfo;
        return info;
    }

    public DomainInfo getDomainInfo(int id) {
        LibVirt.DomainPointer domainPointer = LibVirt.INSTANCE.virDomainLookupByID(this.connectionPointer, id);
        DomainInfo info = new DomainInfo();
        info.name = LibVirt.INSTANCE.virDomainGetName(domainPointer);
        LibVirt.VirDomainInfo domainInfo = new LibVirt.VirDomainInfo();
        int result = LibVirt.INSTANCE.virDomainGetInfo(domainPointer, domainInfo);
        info.domainInfo = domainInfo;
        return info;
    }

    public String getDomainXML(String domainName) {
        LibVirt.DomainPointer domainPointer = LibVirt.INSTANCE.virDomainLookupByName(this.connectionPointer, domainName);
        String xml = LibVirt.INSTANCE.virDomainGetXMLDesc(domainPointer, 0);
        return xml;
    }

    public int domainReboot(String domainName) {
        LibVirt.DomainPointer domainPointer = LibVirt.INSTANCE.virDomainLookupByName(this.connectionPointer, domainName);
        return LibVirt.INSTANCE.virDomainReboot(domainPointer, 0);
    }

    public int domainRestore(String toPath) {
        return LibVirt.INSTANCE.virDomainRestore(this.connectionPointer, toPath);
    }

    public int domainSave(String domainName, String toPath) {
        LibVirt.DomainPointer domainPointer = LibVirt.INSTANCE.virDomainLookupByName(this.connectionPointer, domainName);
        return LibVirt.INSTANCE.virDomainSave(domainPointer, toPath);
    }

    public int domainResume(String domainName) {
        LibVirt.DomainPointer domainPointer = LibVirt.INSTANCE.virDomainLookupByName(this.connectionPointer, domainName);
        return LibVirt.INSTANCE.virDomainResume(domainPointer);
    }

    public int domainShutdown(String domainName) {
        LibVirt.DomainPointer domainPointer = LibVirt.INSTANCE.virDomainLookupByName(this.connectionPointer, domainName);
        return LibVirt.INSTANCE.virDomainShutdown(domainPointer);
    }

    public int domainSuspend(String domainName) {
        LibVirt.DomainPointer domainPointer = LibVirt.INSTANCE.virDomainLookupByName(this.connectionPointer, domainName);
        return LibVirt.INSTANCE.virDomainSuspend(domainPointer);
    }

    public int domainCreate(String domainName) {
        LibVirt.DomainPointer domainPointer = LibVirt.INSTANCE.virDomainLookupByName(this.connectionPointer, domainName);
        return LibVirt.INSTANCE.virDomainCreate(domainPointer);
    }

    public boolean defineDomain(String xml) {
        LibVirt.DomainPointer ptr = LibVirt.INSTANCE.virDomainDefineXML(this.connectionPointer, xml);
        return ptr != null;
    }

    public void setMaxMemory(String domainName, long size) {
        LibVirt.DomainPointer domainPointer = LibVirt.INSTANCE.virDomainLookupByName(this.connectionPointer, domainName);
        int result = LibVirt.INSTANCE.virDomainSetMaxMemory(domainPointer, size);
        if (result < 0) {
            throw new RuntimeException("Failed to set max memory");
        }
    }

    public void setMemory(String domainName, long size) {
        LibVirt.DomainPointer domainPointer = LibVirt.INSTANCE.virDomainLookupByName(this.connectionPointer, domainName);
        int result = LibVirt.INSTANCE.virDomainSetMemory(domainPointer, size);
        if (result < 0) {
            throw new RuntimeException("Failed to set memory");
        }
    }

    public void setVcpus(String domainName, int count) {
        LibVirt.DomainPointer domainPointer = LibVirt.INSTANCE.virDomainLookupByName(this.connectionPointer, domainName);
        int result = LibVirt.INSTANCE.virDomainSetVcpus(domainPointer, count);
        if (result < 0) {
            throw new RuntimeException("Failed to set vcpu count");
        }
    }

    public LibVirt.VirDomainInterfaceStats getDomainInterfaceStats(String domainName, String path) {
        LibVirt.DomainPointer domainPointer = LibVirt.INSTANCE.virDomainLookupByName(this.connectionPointer, domainName);
        LibVirt.VirDomainInterfaceStats stats = new LibVirt.VirDomainInterfaceStats();
        LibVirt.INSTANCE.virDomainInterfaceStats(domainPointer, path, stats, 64);
        return stats;
    }

    public LibVirt.VirDomainBlockStats getDomainBlockStats(String domainName, String path) {
        LibVirt.DomainPointer domainPointer = LibVirt.INSTANCE.virDomainLookupByName(this.connectionPointer, domainName);
        LibVirt.VirDomainBlockStats stats = new LibVirt.VirDomainBlockStats();
        LibVirt.INSTANCE.virDomainBlockStats(domainPointer, path, stats, 40);
        return stats;
    }

    public static class DomainInfo {
        public int id;
        public String name;
        public String uuid;
        public LibVirt.VirDomainInfo domainInfo;
    }
}

