/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.virt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.virt.LibVirtConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualizationDiscoveryComponent
implements ResourceDiscoveryComponent {
    private Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext resourceDiscoveryContext) throws InvalidPluginConfigurationException, Exception {
        int[] ids;
        LibVirtConnection virt;
        HashSet<DiscoveredResourceDetails> details = new HashSet<DiscoveredResourceDetails>();
        try {
            virt = new LibVirtConnection();
        }
        catch (Throwable t) {
            this.log.warn((Object)("Can not load native library for libvirt: " + t.getMessage()));
            return details;
        }
        try {
            ids = virt.getDomainIds();
        }
        catch (Exception e) {
            this.log.info((Object)("Failure obtaining domains from libvirt: " + e.getMessage()));
            return details;
        }
        List<String> guests = virt.getDomainNames();
        for (int id : ids) {
            if (id == 0 && resourceDiscoveryContext.getResourceType().getName().equals("Virtual Host") || id != 0 && !resourceDiscoveryContext.getResourceType().getName().equals("Virtual Host")) {
                LibVirtConnection.DomainInfo domainInfo = virt.getDomainInfo(id);
                DiscoveredResourceDetails detail = new DiscoveredResourceDetails(resourceDiscoveryContext.getResourceType(), domainInfo.name, domainInfo.name, "0", "Virtualization Domain", null, null);
                details.add(detail);
            }
            if (resourceDiscoveryContext.getResourceType().getName().equals("Virtual Host")) continue;
            for (String guestName : guests) {
                LibVirtConnection.DomainInfo domainInfo = virt.getDomainInfo(guestName);
                DiscoveredResourceDetails detail = new DiscoveredResourceDetails(resourceDiscoveryContext.getResourceType(), domainInfo.name, domainInfo.name, "0", "Virtualization Guest Domain", null, null);
                details.add(detail);
            }
        }
        return details;
    }

    public static void main(String[] args) throws IOException {
        String line;
        String virsh = "/usr/bin/virsh";
        ProcessBuilder pb = new ProcessBuilder(virsh, "list");
        pb.redirectErrorStream(true);
        Process proc = pb.start();
        BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        StringBuilder builder = new StringBuilder();
        input.readLine();
        input.readLine();
        while ((line = input.readLine()) != null) {
            String[] vars;
            for (String var : vars = line.split("\\s*")) {
                System.out.println(var);
            }
        }
        input.close();
        System.out.println(builder.toString());
    }
}

