/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.virt;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.libvirt.DomainInfo;
import org.libvirt.LibvirtException;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.virt.LibVirtConnection;
import org.rhq.plugins.virt.VirtualizationHostComponent;
import org.rhq.plugins.virt.XMLEditor;

public class VirtualizationDomainComponent
implements ResourceComponent<VirtualizationHostComponent>,
MeasurementFacet,
OperationFacet,
ConfigurationFacet,
CreateChildResourceFacet,
DeleteResourceFacet {
    private Log log = LogFactory.getLog(VirtualizationDomainComponent.class);
    private String domainName;
    private String uri;
    private long cpuNanosLast;
    private long cpuCheckedLast;
    ResourceContext<VirtualizationHostComponent> resourceContext;

    public void start(ResourceContext<VirtualizationHostComponent> resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.uri = resourceContext.getPluginConfiguration().getSimpleValue("connectionURI", "");
        this.domainName = resourceContext.getResourceKey();
        this.resourceContext = resourceContext;
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        try {
            LibVirtConnection virt = this.getConnection();
            DomainInfo.DomainState state = virt.getDomainInfo((String)this.domainName).domainInfo.state;
            switch (state) {
                case VIR_DOMAIN_RUNNING: {
                    return AvailabilityType.UP;
                }
                case VIR_DOMAIN_PAUSED: {
                    return AvailabilityType.UP;
                }
            }
            return AvailabilityType.DOWN;
        }
        catch (LibvirtException e) {
            this.log.error((Object)("Exception caught retriveing the domain info for " + this.domainName));
            throw new RuntimeException(e);
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        LibVirtConnection virt = this.getConnection();
        for (MeasurementScheduleRequest request : metrics) {
            if (request.getName().equals("cpuTime")) {
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(virt.getDomainInfo((String)this.domainName).domainInfo.cpuTime)));
                continue;
            }
            if (request.getName().equals("cpuPercentage")) {
                long checked = System.nanoTime();
                long cpuNanos = virt.getDomainInfo((String)this.domainName).domainInfo.cpuTime;
                if (this.cpuCheckedLast != 0L) {
                    long duration = checked - this.cpuCheckedLast;
                    long diff = cpuNanos - this.cpuNanosLast;
                    double percentage = (double)diff / (double)duration;
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(percentage)));
                }
                this.cpuCheckedLast = checked;
                this.cpuNanosLast = cpuNanos;
                continue;
            }
            if (!request.getName().equals("memoryUsage")) continue;
            report.addData(new MeasurementDataNumeric(request, Double.valueOf(virt.getDomainInfo((String)this.domainName).domainInfo.memory)));
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        int result = -1;
        LibVirtConnection virt = this.getConnection();
        this.log.info((Object)("Executing " + name + " operation on domain " + this.getDomainName()));
        if (name.equals("reboot")) {
            result = virt.domainReboot(this.domainName);
        } else if (name.equals("restore")) {
            result = virt.domainRestore(parameters.getSimpleValue("fromPath", null));
        } else if (name.equals("resume")) {
            result = virt.domainResume(this.domainName);
        } else if (name.equals("save")) {
            result = virt.domainSave(this.domainName, parameters.getSimpleValue("toPath", null));
        } else if (name.equals("shutdown")) {
            result = virt.domainShutdown(this.domainName);
        } else if (name.equals("suspend")) {
            result = virt.domainSuspend(this.domainName);
        } else if (name.equals("start")) {
            result = virt.domainCreate(this.domainName);
        } else if (name.equals("destroy")) {
            result = virt.domainDestroy(this.domainName);
        }
        if (result < 0) {
            throw new Exception("Failed to run " + name + " command. Result was: " + result);
        }
        return new OperationResult();
    }

    public Configuration loadResourceConfiguration() throws LibvirtException {
        LibVirtConnection virt = this.getConnection();
        String xml = virt.getDomainXML(this.domainName);
        return XMLEditor.getDomainConfiguration(xml);
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        try {
            LibVirtConnection virt = this.getConnection();
            String xml = virt.getDomainXML(this.domainName);
            Configuration oldConfig = this.loadResourceConfiguration();
            if (oldConfig == null) {
                throw new IllegalStateException("Failed to parse the XML specification for domain '" + this.domainName + "'.");
            }
            Configuration newConfig = report.getConfiguration();
            String newXml = XMLEditor.updateDomainXML(report.getConfiguration(), xml);
            this.log.info((Object)"Calling libvirt to redefine domain");
            if (!virt.defineDomain(newXml)) {
                this.log.warn((Object)"Call to redefine domain did not return a domain pointer");
            }
            if (!oldConfig.getSimple("memory").getLongValue().equals(newConfig.getSimple("memory").getLongValue())) {
                virt.setMaxMemory(this.domainName, newConfig.getSimple("memory").getLongValue());
            }
            if (!oldConfig.getSimple("currentMemory").getLongValue().equals(newConfig.getSimple("currentMemory").getLongValue())) {
                virt.setMemory(this.domainName, newConfig.getSimple("currentMemory").getLongValue());
            }
            if (!oldConfig.getSimple("vcpu").getIntegerValue().equals(newConfig.getSimple("vcpu").getIntegerValue())) {
                virt.setVcpus(this.domainName, newConfig.getSimple("vcpu").getIntegerValue());
            }
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (LibvirtException e) {
            throw new RuntimeException(e);
        }
    }

    public CreateResourceReport createResource(CreateResourceReport report) {
        String xml = XMLEditor.getDomainXml(report.getResourceConfiguration());
        return report;
    }

    public LibVirtConnection getConnection() throws LibvirtException {
        return ((VirtualizationHostComponent)this.resourceContext.getParentResourceComponent()).getConnection();
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void deleteResource() throws Exception {
        LibVirtConnection virt = this.getConnection();
        virt.domainDelete(this.domainName);
    }
}

