/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.virt;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.libvirt.LibvirtException;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.virt.LibVirtConnection;
import org.rhq.plugins.virt.VirtualizationDomainComponent;
import org.rhq.plugins.virt.VirtualizationHostComponent;
import org.rhq.plugins.virt.XMLEditor;

public class VirtualizationNetworkComponent
implements ResourceComponent<VirtualizationHostComponent>,
MeasurementFacet,
ConfigurationFacet,
CreateChildResourceFacet,
DeleteResourceFacet {
    private Log log = LogFactory.getLog(VirtualizationDomainComponent.class);
    private String networkName;
    private long cpuNanosLast;
    private long cpuCheckedLast;
    ResourceContext<VirtualizationHostComponent> resourceContext;

    public void start(ResourceContext<VirtualizationHostComponent> resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.networkName = resourceContext.getResourceKey();
        this.resourceContext = resourceContext;
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        try {
            LibVirtConnection virt = this.getConnection();
            return virt.isNetworkActive(this.networkName) ? AvailabilityType.UP : AvailabilityType.DOWN;
        }
        catch (LibvirtException e) {
            this.log.error((Object)("Exception caught retriveing the domain info for " + this.networkName));
            throw new RuntimeException(e);
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
    }

    public Configuration loadResourceConfiguration() throws LibvirtException {
        LibVirtConnection virt = this.getConnection();
        String xml = virt.getNetworkXML(this.networkName);
        boolean autostart = virt.getNetwork((String)this.networkName).autostart;
        return XMLEditor.getNetworkConfiguration(xml, autostart);
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        try {
            LibVirtConnection virt = this.getConnection();
            Configuration config = report.getConfiguration();
            boolean autostart = config.getSimple("autostart").getBooleanValue();
            String xml = XMLEditor.getNetworkXml(config);
            virt.updateNetwork(this.networkName, xml, autostart);
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (LibvirtException e) {
            throw new RuntimeException(e);
        }
    }

    public CreateResourceReport createResource(CreateResourceReport report) {
        return report;
    }

    public void deleteResource() throws Exception {
    }

    public LibVirtConnection getConnection() throws LibvirtException {
        return ((VirtualizationHostComponent)this.resourceContext.getParentResourceComponent()).getConnection();
    }

    public String getNetworkName() {
        return this.networkName;
    }
}

