/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.virt;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.libvirt.LibvirtException;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.virt.LibVirtConnection;

public class VirtualizationNetworkDiscoveryComponent
implements ResourceDiscoveryComponent {
    private Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext resourceDiscoveryContext) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> details = new HashSet<DiscoveredResourceDetails>();
        String uri = resourceDiscoveryContext.getParentResourceContext().getPluginConfiguration().getSimpleValue("connectionURI", "");
        LibVirtConnection virt = null;
        try {
            virt = new LibVirtConnection(uri);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Can not load native library for libvirt: " + t.getMessage()), t);
            virt.close();
            return details;
        }
        List<String> definedNetworks = null;
        List<String> activeNetworks = null;
        try {
            definedNetworks = virt.getDefinedNetworks();
            activeNetworks = virt.getNetworks();
        }
        catch (Exception e) {
            this.log.info((Object)("Failure obtaining domains from libvirt: " + e.getMessage()));
            virt.close();
            return details;
        }
        for (String net : definedNetworks) {
            details.add(this.createResource(resourceDiscoveryContext.getResourceType(), virt.getNetwork(net)));
        }
        for (String net : activeNetworks) {
            details.add(this.createResource(resourceDiscoveryContext.getResourceType(), virt.getNetwork(net)));
        }
        virt.close();
        return details;
    }

    public DiscoveredResourceDetails createResource(ResourceType resourceType, LibVirtConnection.NetworkInfo net) throws LibvirtException {
        String name = net.name;
        DiscoveredResourceDetails detail = new DiscoveredResourceDetails(resourceType, name, name, null, "Virtual Network Named " + name, null, null);
        return detail;
    }
}

