/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.virt;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.rhq.core.domain.configuration.AbstractPropertyMap;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.plugins.virt.LibVirtConnection;

public class XMLEditor {
    private static Log log = LogFactory.getLog(LibVirtConnection.class);

    public static String updateDomainXML(Configuration config, String xmlToEdit) {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((Reader)new StringReader(xmlToEdit));
            Element root = doc.getRootElement();
            root.setAttribute("type", config.getSimple("type").getStringValue());
            XMLEditor.updateSimpleNode((AbstractPropertyMap)config, root, "name");
            XMLEditor.updateSimpleNode((AbstractPropertyMap)config, root, "uuid");
            XMLEditor.updateSimpleNode((AbstractPropertyMap)config, root, "memory");
            XMLEditor.updateSimpleNode((AbstractPropertyMap)config, root, "currentMemory");
            XMLEditor.updateSimpleNode((AbstractPropertyMap)config, root, "vcpu");
            XMLEditor.updateSimpleNode((AbstractPropertyMap)config, root, "on_poweroff");
            XMLEditor.updateSimpleNode((AbstractPropertyMap)config, root, "on_reboot");
            XMLEditor.updateSimpleNode((AbstractPropertyMap)config, root, "on_crash");
            XMLOutputter outputter = new XMLOutputter();
            outputter.getFormat().setIndent("    ");
            outputter.getFormat().setLineSeparator("\n");
            return outputter.outputString(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getDomainXml(Configuration config) {
        Document doc = new Document();
        Element root = new Element("domain");
        doc.setRootElement(root);
        root.setAttribute("type", config.getSimple("type").getStringValue());
        XMLEditor.addSimpleNode((AbstractPropertyMap)config, root, "name");
        XMLEditor.addSimpleNode((AbstractPropertyMap)config, root, "uuid");
        XMLEditor.addSimpleNode((AbstractPropertyMap)config, root, "memory");
        XMLEditor.addSimpleNode((AbstractPropertyMap)config, root, "currentMemory");
        XMLEditor.addSimpleNode((AbstractPropertyMap)config, root, "vcpu");
        XMLEditor.addSimpleNode((AbstractPropertyMap)config, root, "on_poweroff");
        XMLEditor.addSimpleNode((AbstractPropertyMap)config, root, "on_reboot");
        XMLEditor.addSimpleNode((AbstractPropertyMap)config, root, "on_crash");
        Element devices = new Element("devices");
        root.addContent((Content)devices);
        PropertyList interfaces = config.getList("interfaces");
        for (Property intf : interfaces.getList()) {
            PropertyMap intfMap = (PropertyMap)intf;
            Element intfElement = new Element("interface");
            devices.addContent((Content)intfElement);
            XMLEditor.addSimpleAttribute((AbstractPropertyMap)intfMap, intfElement, "type", "type");
            Element sourceElement = new Element("source");
            intfElement.addContent((Content)sourceElement);
            XMLEditor.addSimpleAttribute((AbstractPropertyMap)intfMap, sourceElement, "source", "bridge");
            Element targetElement = new Element("target");
            intfElement.addContent((Content)targetElement);
            XMLEditor.addSimpleAttribute((AbstractPropertyMap)intfMap, targetElement, "target", "dev");
            Element macElement = new Element("mac");
            intfElement.addContent((Content)macElement);
            XMLEditor.addSimpleAttribute((AbstractPropertyMap)intfMap, macElement, "mac", "address");
            Element scriptElement = new Element("script");
            intfElement.addContent((Content)scriptElement);
            XMLEditor.addSimpleAttribute((AbstractPropertyMap)intfMap, scriptElement, "script", "path");
        }
        PropertyList disks = config.getList("disks");
        for (Property disk : disks.getList()) {
            PropertyMap diskMap = (PropertyMap)disk;
            Element diskElement = new Element("disk");
            devices.addContent((Content)diskElement);
            XMLEditor.addSimpleAttribute((AbstractPropertyMap)diskMap, diskElement, "type", "type");
            XMLEditor.addSimpleAttribute((AbstractPropertyMap)diskMap, diskElement, "device", "dev");
            Element driverElement = new Element("driver");
            diskElement.addContent((Content)driverElement);
            XMLEditor.addSimpleAttribute((AbstractPropertyMap)diskMap, driverElement, "driverName", "name");
            XMLEditor.addSimpleAttribute((AbstractPropertyMap)diskMap, driverElement, "driverType", "type");
            Element sourceElement = new Element("source");
            diskElement.addContent((Content)sourceElement);
            XMLEditor.addSimpleAttribute((AbstractPropertyMap)diskMap, driverElement, "sourceFile", "file");
            XMLEditor.addSimpleAttribute((AbstractPropertyMap)diskMap, driverElement, "sourceDevice", "dev");
            Element targetElement = new Element("target");
            diskElement.addContent((Content)targetElement);
            XMLEditor.addSimpleAttribute((AbstractPropertyMap)diskMap, driverElement, "targetDevice", "dev");
            XMLEditor.addSimpleAttribute((AbstractPropertyMap)diskMap, driverElement, "targetBus", "bus");
        }
        XMLOutputter outputter = new XMLOutputter();
        outputter.getFormat().setIndent("    ");
        outputter.getFormat().setLineSeparator("\n");
        return outputter.outputString(doc);
    }

    public static Configuration getDomainConfiguration(String xml) {
        if (xml == null) {
            return null;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((Reader)new StringReader(xml));
            Configuration config = new Configuration();
            Element root = doc.getRootElement();
            String type = root.getAttribute("type").getValue();
            config.put((Property)new PropertySimple("type", (Object)type));
            XMLEditor.addChildTextSimpleProperty(config, root, "name");
            XMLEditor.addChildTextSimpleProperty(config, root, "uuid");
            XMLEditor.addChildTextSimpleProperty(config, root, "memory");
            XMLEditor.addChildTextSimpleProperty(config, root, "currentMemory");
            XMLEditor.addChildTextSimpleProperty(config, root, "vcpu");
            XMLEditor.addChildTextSimpleProperty(config, root, "on_poweroff");
            XMLEditor.addChildTextSimpleProperty(config, root, "on_reboot");
            XMLEditor.addChildTextSimpleProperty(config, root, "on_crash");
            Element devices = root.getChild("devices");
            PropertyList interfaces = new PropertyList("interfaces");
            config.put((Property)interfaces);
            List interfaceElementList = devices.getChildren("interface");
            for (Element interfaceElement : interfaceElementList) {
                PropertyMap intf = new PropertyMap("interface");
                String iType = interfaceElement.getAttribute("type").getValue();
                intf.put((Property)new PropertySimple("type", (Object)iType));
                XMLEditor.addChildAttribute((AbstractPropertyMap)intf, interfaceElement, "mac", "address", "macAddress");
                XMLEditor.addChildAttribute((AbstractPropertyMap)intf, interfaceElement, "target", "dev", "target");
                XMLEditor.addChildAttribute((AbstractPropertyMap)intf, interfaceElement, "source", "bridge", "source");
                XMLEditor.addChildAttribute((AbstractPropertyMap)intf, interfaceElement, "script", "path", "script");
                interfaces.add((Property)intf);
            }
            PropertyList disks = new PropertyList("disks");
            config.put((Property)disks);
            List diskElementList = devices.getChildren("disk");
            for (Element diskElement : diskElementList) {
                PropertyMap disk = new PropertyMap("disk");
                Attribute diskType = diskElement.getAttribute("type");
                String dType = diskType != null ? diskType.getValue() : "block";
                disk.put((Property)new PropertySimple("type", (Object)dType));
                Attribute diskDevice = diskElement.getAttribute("device");
                if (diskDevice != null) {
                    disk.put((Property)new PropertySimple("device", (Object)diskDevice.getValue()));
                }
                XMLEditor.addChildAttribute((AbstractPropertyMap)disk, diskElement, "driver", "name", "driverName");
                XMLEditor.addChildAttribute((AbstractPropertyMap)disk, diskElement, "driver", "type", "driverType");
                XMLEditor.addChildAttribute((AbstractPropertyMap)disk, diskElement, "source", "file", "sourceFile");
                XMLEditor.addChildAttribute((AbstractPropertyMap)disk, diskElement, "source", "dev", "sourceDevice");
                XMLEditor.addChildAttribute((AbstractPropertyMap)disk, diskElement, "target", "dev", "targetDevice");
                XMLEditor.addChildAttribute((AbstractPropertyMap)disk, diskElement, "target", "bus", "targetBus");
                disks.add((Property)disk);
            }
            return config;
        }
        catch (Exception e) {
            log.error((Object)"Error parsing the domain XML", (Throwable)e);
            return null;
        }
    }

    public static Configuration getNetworkConfiguration(String xml, boolean autostart) {
        if (xml == null) {
            return null;
        }
        Configuration config = new Configuration();
        try {
            Element dhcp;
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((Reader)new StringReader(xml));
            Element root = doc.getRootElement();
            XMLEditor.addChildTextSimpleProperty(config, root, "name");
            XMLEditor.addChildTextSimpleProperty(config, root, "uuid");
            config.put((Property)new PropertySimple("autostart", (Object)autostart));
            XMLEditor.addChildAttribute((AbstractPropertyMap)config, root, "bridge", "name", "bridge");
            XMLEditor.addChildAttribute((AbstractPropertyMap)config, root, "forward", "mode", "forwardMode");
            XMLEditor.addChildAttribute((AbstractPropertyMap)config, root, "forward", "dev", "forwardDevice");
            XMLEditor.addChildAttribute((AbstractPropertyMap)config, root, "ip", "address", "ipaddress");
            XMLEditor.addChildAttribute((AbstractPropertyMap)config, root, "ip", "netmask", "netmask");
            Element ip = root.getChild("ip");
            if (ip != null && (dhcp = ip.getChild("dhcp")) != null) {
                XMLEditor.addChildAttribute((AbstractPropertyMap)config, dhcp, "range", "start", "dhcpStart");
                XMLEditor.addChildAttribute((AbstractPropertyMap)config, dhcp, "range", "end", "dhcpEnd");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error parsing the network XML", (Throwable)e);
        }
        return config;
    }

    public static String getNetworkXml(Configuration config) {
        Document doc = new Document();
        Element root = new Element("network");
        doc.setRootElement(root);
        XMLEditor.addSimpleNode((AbstractPropertyMap)config, root, "name");
        XMLEditor.addSimpleNode((AbstractPropertyMap)config, root, "uuid");
        Element bridge = new Element("bridge");
        bridge.setAttribute("name", config.getSimpleValue("bridge", ""));
        root.addContent((Content)bridge);
        Element forward = new Element("forward");
        forward.setAttribute("mode", config.getSimpleValue("forwardMode", ""));
        forward.setAttribute("dev", config.getSimpleValue("forwardDevice", ""));
        root.addContent((Content)forward);
        Element ip = new Element("ip");
        ip.setAttribute("address", config.getSimpleValue("ipaddress", ""));
        ip.setAttribute("netmask", config.getSimpleValue("netmask", ""));
        root.addContent((Content)ip);
        Element dhcp = new Element("dhcp");
        Element range = new Element("range");
        range.setAttribute("start", config.getSimpleValue("dhcpStart", ""));
        range.setAttribute("end", config.getSimpleValue("dhcpEnd", ""));
        dhcp.addContent((Content)range);
        root.addContent((Content)dhcp);
        XMLOutputter outputter = new XMLOutputter();
        outputter.getFormat().setIndent("    ");
        outputter.getFormat().setLineSeparator("\n");
        return outputter.outputString(doc);
    }

    private static void addSimpleNode(AbstractPropertyMap config, Element parent, String name) {
        PropertySimple prop = config.getSimple(name);
        if (prop != null) {
            Element e = new Element(name);
            e.setText(prop.getStringValue());
            parent.addContent((Content)e);
        }
    }

    private static void addSimpleAttribute(AbstractPropertyMap config, Element element, String configName, String attributeName) {
        PropertySimple prop = config.getSimple(configName);
        if (prop != null) {
            element.setAttribute(attributeName, prop.getStringValue());
        }
    }

    private static void updateSimpleNode(AbstractPropertyMap config, Element parent, String name) {
        Element e = parent.getChild(name);
        e.setText(config.getSimple(name).getStringValue());
    }

    private static void addChildAttribute(AbstractPropertyMap config, Element element, String childElementName, String childAttributeName, String propertyName) {
        String attributeValue;
        Element child = element.getChild(childElementName);
        if (child != null && (attributeValue = child.getAttributeValue(childAttributeName)) != null) {
            config.put((Property)new PropertySimple(propertyName, (Object)attributeValue));
        }
    }

    private static void addChildTextSimpleProperty(Configuration config, Element root, String property) {
        String val = root.getChildText(property);
        config.put((Property)new PropertySimple(property, (Object)val));
    }
}

