/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.gui.webdav;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.gui.webdav.GetableBasicResource;

public class ConfigResource
extends GetableBasicResource {
    private Configuration configuration;
    private String content;

    public ConfigResource(Subject subject, Resource managedResource) {
        super(subject, managedResource);
    }

    public String getUniqueId() {
        return "config_" + this.getConfiguration().getId();
    }

    public String getName() {
        return "resource_configuration.xml";
    }

    public Date getModifiedDate() {
        return new Date(this.getConfiguration().getModifiedTime());
    }

    public Date getCreateDate() {
        return new Date(this.getConfiguration().getCreatedTime());
    }

    protected String loadContent() {
        if (this.content == null) {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Configuration.class, Property.class});
                Marshaller marshaller = context.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                marshaller.marshal((Object)this.getConfiguration(), (OutputStream)baos);
                this.content = baos.toString();
            }
            catch (JAXBException e) {
                throw new RuntimeException("Failed to translate configuration to XML", e);
            }
        }
        return this.content;
    }

    private Configuration getConfiguration() {
        if (this.configuration == null) {
            ConfigurationManagerLocal cm = LookupUtil.getConfigurationManager();
            this.configuration = cm.getResourceConfiguration(this.getManagedResource().getId());
        }
        return this.configuration;
    }
}

