/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.gui.webdav;

import com.bradmcevoy.http.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.composite.ResourceFacets;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.gui.webdav.AuthenticatedCollectionResource;
import org.rhq.gui.webdav.AvailabilityResource;
import org.rhq.gui.webdav.BasicResource;
import org.rhq.gui.webdav.ConfigResource;
import org.rhq.gui.webdav.MeasurementDataResource;
import org.rhq.gui.webdav.SafeEncoder;
import org.rhq.gui.webdav.TraitsResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFolder
extends BasicResource
implements AuthenticatedCollectionResource {
    private List<Resource> children;

    public ResourceFolder(Subject subject, org.rhq.core.domain.resource.Resource managedResource) {
        super(subject, managedResource);
    }

    public String getUniqueId() {
        return String.valueOf(this.getManagedResource().getId());
    }

    public String getName() {
        String name = this.getManagedResource().getName();
        return SafeEncoder.encode((String)name);
    }

    public Date getModifiedDate() {
        return new Date(this.getManagedResource().getMtime());
    }

    public Date getCreateDate() {
        return new Date(this.getManagedResource().getCtime());
    }

    public Resource child(String childName) {
        List children = this.getChildren();
        for (Resource child : children) {
            if (!childName.equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    public List<? extends Resource> getChildren() {
        return this.getChildren(this.getSubject());
    }

    public List<? extends Resource> getChildren(Subject subject) {
        if (this.children == null) {
            ResourceManagerLocal rm = LookupUtil.getResourceManager();
            PageList childs = rm.findChildResources(subject, this.getManagedResource().getId(), PageControl.getUnlimitedInstance());
            this.children = new ArrayList(childs.size());
            for (org.rhq.core.domain.resource.Resource child : childs) {
                if (child.getInventoryStatus() != InventoryStatus.COMMITTED) continue;
                this.children.add(new ResourceFolder(subject, child));
            }
            ResourceTypeManagerLocal rtm = LookupUtil.getResourceTypeManager();
            ResourceFacets facets = rtm.getResourceFacets(this.getManagedResource().getResourceType().getId());
            this.children.add(new AvailabilityResource(subject, this.getManagedResource()));
            if (facets.isConfiguration()) {
                this.children.add(new ConfigResource(subject, this.getManagedResource()));
            }
            if (facets.isMeasurement()) {
                this.children.add(new TraitsResource(subject, this.getManagedResource()));
            }
            if (facets.isMeasurement()) {
                this.children.add(new MeasurementDataResource(subject, this.getManagedResource()));
            }
        }
        return this.children;
    }
}

