/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.gui.webdav;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.PropFindableResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.composite.ResourceComposite;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.gui.webdav.AuthenticatedCollectionResource;
import org.rhq.gui.webdav.Authenticator;
import org.rhq.gui.webdav.ResourceFolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootFolder
extends Authenticator
implements AuthenticatedCollectionResource,
PropFindableResource {
    private static final Log LOG = LogFactory.getLog(RootFolder.class);
    private List<ResourceFolder> roots;

    public RootFolder() {
        super(null);
    }

    public String getUniqueId() {
        return "/";
    }

    public String getName() {
        return "/";
    }

    public Date getModifiedDate() {
        return new Date();
    }

    public Date getCreateDate() {
        return new Date();
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        boolean authorized;
        boolean bl = authorized = auth != null && auth.getTag() != null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RootFolder auth=[" + (auth != null ? auth.getTag() : auth) + "], isAuthorized=" + authorized));
        }
        return authorized;
    }

    public String checkRedirect(Request request) {
        return null;
    }

    public Resource child(String childName) {
        List children = this.getChildren();
        for (Resource child : children) {
            if (!childName.equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    public List<? extends Resource> getChildren() {
        return this.getChildren(this.getSubject());
    }

    public List<? extends Resource> getChildren(Subject subject) {
        if (this.roots == null) {
            ResourceManagerLocal rm = LookupUtil.getResourceManager();
            PageList foundRoots = rm.findResourceComposites(subject, ResourceCategory.PLATFORM, null, null, null, null, true, PageControl.getUnlimitedInstance());
            if (foundRoots != null) {
                this.roots = new ArrayList(foundRoots.size());
                for (ResourceComposite comp : foundRoots) {
                    this.roots.add(new ResourceFolder(subject, comp.getResource()));
                }
            } else {
                this.roots = new ArrayList();
            }
        }
        return this.roots;
    }
}

