/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cassandra;

import java.util.HashSet;
import java.util.Set;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;

public class ColumnFamilyDiscoveryComponent
extends MBeanResourceDiscoveryComponent<JMXComponent<?>> {
    private static final String COLUMN_FAMILY_MARKER = "columnfamily=";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JMXComponent<?>> context) {
        Set discoveredResources = super.discoverResources(context, false);
        String keyspace = context.getParentResourceContext().getResourceKey();
        HashSet<DiscoveredResourceDetails> selectedResources = new HashSet<DiscoveredResourceDetails>();
        for (DiscoveredResourceDetails columnFamilyMBean : discoveredResources) {
            if (!columnFamilyMBean.getResourceKey().contains("keyspace=" + keyspace)) continue;
            String resourceKey = columnFamilyMBean.getResourceKey();
            if ((resourceKey = resourceKey.substring(resourceKey.indexOf(COLUMN_FAMILY_MARKER) + COLUMN_FAMILY_MARKER.length())).indexOf(44) > -1) {
                resourceKey = resourceKey.substring(0, resourceKey.indexOf(44));
            }
            columnFamilyMBean.setResourceKey(resourceKey);
            columnFamilyMBean.setResourceName(resourceKey);
            selectedResources.add(columnFamilyMBean);
        }
        return selectedResources;
    }
}

