/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cassandra;

import java.util.Set;
import org.rhq.core.domain.util.StringUtils;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;

public class MetricsDiscoveryComponent
extends MBeanResourceDiscoveryComponent<JMXComponent<?>> {
    public static final String PROPERTY_NAME_MARKER = "nameMarker";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JMXComponent<?>> context) {
        String nameMarker = context.getDefaultPluginConfiguration().getSimpleValue(PROPERTY_NAME_MARKER);
        Set discoveredResources = super.discoverResources(context, true);
        for (DiscoveredResourceDetails discoveredResource : discoveredResources) {
            String updatedResourceName = discoveredResource.getResourceName();
            int index = updatedResourceName.indexOf(nameMarker);
            if (index == -1 || (updatedResourceName = updatedResourceName.substring(index + nameMarker.length())).length() == 0) continue;
            updatedResourceName = StringUtils.deCamelCase((String)updatedResourceName);
            discoveredResource.setResourceName(updatedResourceName);
        }
        return discoveredResources;
    }
}

