/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cassandra;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.system.FileSystemInfo;
import org.rhq.plugins.cassandra.CassandraNodeComponent;
import org.rhq.plugins.cassandra.ComplexConfigurationResourceComponent;
import org.rhq.plugins.jmx.JMXComponent;

public class StorageServiceComponent
extends ComplexConfigurationResourceComponent {
    private static final String OWNERSHIP_METRIC_NAME = "Ownership";
    private static final String DATA_DISK_USED_PERCENTAGE_METRIC_NAME = "Calculated.DataDiskUsedPercentage";
    private static final String TOTAL_DISK_USED_PERCENTAGE_METRIC_NAME = "Calculated.TotalDiskUsedPercentage";
    private static final String FREE_DISK_TO_DATA_SIZE_RATIO_METRIC_NAME = "Calculated.FreeDiskToDataSizeRatio";
    private static final String DATA_FILE_LOCATIONS_NAME = "AllDataFileLocations";
    private static final String LOAD_NAME = "Load";
    private Log log = LogFactory.getLog(StorageServiceComponent.class);
    private InetAddress host;

    public void start(ResourceContext<JMXComponent<?>> context) {
        super.start(context);
        CassandraNodeComponent parrent = (CassandraNodeComponent)context.getParentResourceComponent();
        try {
            this.host = InetAddress.getByName(parrent.getHost());
        }
        catch (UnknownHostException e) {
            this.log.error((Object)("Unable to convert hostname[" + parrent.getHost() + "] into IP address for " + context.getResourceKey()), (Throwable)e);
        }
    }

    public AvailabilityType getAvailability() {
        ResourceContext context = this.getResourceContext();
        try {
            EmsAttribute initializedAttr;
            Boolean initialized;
            EmsBean emsBean = this.loadBean();
            if (emsBean == null) {
                this.log.warn((Object)("Unable to establish JMX connection to " + context.getResourceKey()));
                return AvailabilityType.DOWN;
            }
            AvailabilityType availability = AvailabilityType.UP;
            EmsAttribute nativeTransportEnabledAttr = emsBean.getAttribute("NativeTransportRunning");
            Boolean nativeTransportEnabled = (Boolean)nativeTransportEnabledAttr.getValue();
            if (!nativeTransportEnabled.booleanValue()) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("Native transport is disabled for " + context.getResourceKey()));
                }
                availability = AvailabilityType.DOWN;
            }
            if (!(initialized = (Boolean)(initializedAttr = emsBean.getAttribute("Initialized")).getValue()).booleanValue()) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)(context.getResourceKey() + " is not initialized"));
                }
                availability = AvailabilityType.DOWN;
            }
            return availability;
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to determine availability for " + context.getResourceKey()), (Throwable)e);
            return AvailabilityType.UNKNOWN;
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if (name.equals("takeSnapshot")) {
            return this.takeSnapshot(parameters);
        }
        if (name.equals("setLog4jLevel")) {
            return this.setLog4jLevel(parameters);
        }
        return super.invokeOperation(name, parameters);
    }

    private OperationResult takeSnapshot(Configuration parameters) {
        EmsBean emsBean = this.getEmsBean();
        EmsOperation operation = emsBean.getOperation("takeSnapshot", new Class[]{String.class, String[].class});
        String snapshotName = parameters.getSimpleValue("snapshotName");
        if (snapshotName == null || snapshotName.trim().isEmpty()) {
            snapshotName = System.currentTimeMillis() + "";
        }
        operation.invoke(new Object[]{snapshotName, new String[0]});
        return new OperationResult();
    }

    private OperationResult setLog4jLevel(Configuration parameters) {
        EmsBean emsBean = this.getEmsBean();
        EmsOperation operation = emsBean.getOperation("setLog4jLevel", new Class[]{String.class, String.class});
        String classQualifier = parameters.getSimpleValue("classQualifier");
        String level = parameters.getSimpleValue("level");
        operation.invoke(new Object[]{classQualifier, level});
        return new OperationResult();
    }

    protected void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests, EmsBean bean) {
        super.getValues(report, requests, bean);
        EmsAttribute loadAttribute = bean.getAttribute(LOAD_NAME);
        Object loadValue = loadAttribute.refresh();
        EmsAttribute dataFileLocationAttribute = bean.getAttribute(DATA_FILE_LOCATIONS_NAME);
        Object dataFileLocationValue = dataFileLocationAttribute.refresh();
        double load = 0.0;
        if (loadValue != null && dataFileLocationValue != null && dataFileLocationValue instanceof String[]) {
            load = Double.parseDouble(loadValue.toString());
            load /= 1024.0;
        }
        for (MeasurementScheduleRequest request : requests) {
            if (OWNERSHIP_METRIC_NAME.equals(request.getName()) && this.host != null) {
                EmsAttribute attribute = bean.getAttribute(OWNERSHIP_METRIC_NAME);
                Object valueObject = attribute.refresh();
                if (!(valueObject instanceof Map)) break;
                Map ownership = (Map)valueObject;
                Float value = (Float)ownership.get(this.host);
                if (value == null) {
                    for (Map.Entry entry : ownership.entrySet()) {
                        if (!((InetAddress)entry.getKey()).getHostAddress().equals(this.host.getHostAddress())) continue;
                        value = (Float)entry.getValue();
                        break;
                    }
                }
                if (value.floatValue() > 1.0f) {
                    value = Float.valueOf(1.0f);
                }
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(value.doubleValue())));
                break;
            }
            if (!DATA_DISK_USED_PERCENTAGE_METRIC_NAME.equals(request.getName()) && !TOTAL_DISK_USED_PERCENTAGE_METRIC_NAME.equals(request.getName()) && !FREE_DISK_TO_DATA_SIZE_RATIO_METRIC_NAME.equals(request.getName())) continue;
            double metricValue = this.getDiskUsageMetric(request, load, (String[])dataFileLocationValue);
            report.addData(new MeasurementDataNumeric(request, Double.valueOf(metricValue)));
        }
    }

    private double getDiskUsageMetric(MeasurementScheduleRequest request, double dataSize, String[] paths) {
        ArrayList<String> visitedMountPoints = new ArrayList<String>();
        long totalDiskSpace = 0L;
        long totalFreeDiskSpace = 0L;
        long totalUsedDiskSpace = 0L;
        for (String path : paths) {
            try {
                FileSystemInfo fileSystemInfo = this.getResourceContext().getSystemInformation().getFileSystem(path);
                if (visitedMountPoints.contains(fileSystemInfo.getMountPoint())) continue;
                visitedMountPoints.add(fileSystemInfo.getMountPoint());
                totalDiskSpace += fileSystemInfo.getFileSystemUsage().getTotal();
                totalFreeDiskSpace += fileSystemInfo.getFileSystemUsage().getFree();
                totalUsedDiskSpace += fileSystemInfo.getFileSystemUsage().getUsed();
            }
            catch (Exception e) {
                this.log.error((Object)("Unable to determine file system usage information for data file location " + path), (Throwable)e);
            }
        }
        double metricValue = 0.0;
        if (totalDiskSpace != 0L) {
            double rawPercentage = 0.0;
            if (DATA_DISK_USED_PERCENTAGE_METRIC_NAME.equals(request.getName())) {
                rawPercentage = dataSize / (double)totalDiskSpace;
            } else if (TOTAL_DISK_USED_PERCENTAGE_METRIC_NAME.equals(request.getName())) {
                rawPercentage = (double)totalUsedDiskSpace / (double)totalDiskSpace;
            } else if (FREE_DISK_TO_DATA_SIZE_RATIO_METRIC_NAME.equals(request.getName())) {
                rawPercentage = (double)totalFreeDiskSpace / dataSize;
            }
            metricValue = (double)Math.round(rawPercentage * 100.0) / 100.0;
        }
        return metricValue;
    }
}

