/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.file.JarContentFileInfo;
import org.rhq.plugins.jbossas.JBossASServerComponent;
import org.rhq.plugins.jbossas.helper.MainDeployer;
import org.rhq.plugins.jbossas.util.FileContentDelegate;
import org.rhq.plugins.jmx.MBeanResourceComponent;

public class ApplicationComponent
extends MBeanResourceComponent<JBossASServerComponent<?>>
implements ContentFacet,
DeleteResourceFacet,
OperationFacet {
    private static final String BACKUP_FILE_SUFFIX = ".rej";
    private static final String PKG_TYPE_FILE = "file";
    private static final String ARCHITECTURE = "noarch";
    private static final String FILENAME_PLUGIN_CONFIG_PROP = "filename";
    private static final String APPLICATION_PATH_TRAIT = "Application.path";
    private static final String APPLICATION_EXPLODED_TRAIT = "Application.exploded";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        Configuration pluginConfiguration = this.getResourceContext().getPluginConfiguration();
        String fullFileName = pluginConfiguration.getSimpleValue(FILENAME_PLUGIN_CONFIG_PROP, null);
        File packageFile = new File(fullFileName);
        try {
            File fileToSend;
            if (packageFile.isDirectory()) {
                fileToSend = File.createTempFile("rhq", ".zip");
                ZipUtil.zipFileOrDirectory((File)packageFile, (File)fileToSend);
            } else {
                fileToSend = packageFile;
            }
            return new BufferedInputStream(new FileInputStream(fileToSend));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to retrieve package bits for " + packageDetails, e);
        }
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
        HashSet<ResourcePackageDetails> packages = new HashSet<ResourcePackageDetails>();
        Configuration pluginConfiguration = this.getResourceContext().getPluginConfiguration();
        String fullFileName = pluginConfiguration.getSimpleValue(FILENAME_PLUGIN_CONFIG_PROP, null);
        if (fullFileName == null) {
            throw new IllegalStateException("Plugin configuration does not contain the full file name of the EAR/WAR file.");
        }
        File file = new File(fullFileName);
        if (file.exists()) {
            String fileName = new File(fullFileName).getName();
            String sha256 = this.getSHA256(file);
            String version = this.getVersion(sha256);
            String displayVersion = this.getDisplayVersion(file);
            PackageDetailsKey key = new PackageDetailsKey(fileName, version, PKG_TYPE_FILE, ARCHITECTURE);
            ResourcePackageDetails details = new ResourcePackageDetails(key);
            details.setFileName(fileName);
            details.setLocation(file.getPath());
            if (!file.isDirectory()) {
                details.setFileSize(Long.valueOf(file.length()));
            }
            details.setFileCreatedDate(Long.valueOf(file.lastModified()));
            details.setSHA256(sha256);
            details.setInstallationTimestamp(Long.valueOf(System.currentTimeMillis()).longValue());
            details.setDisplayVersion(displayVersion);
            packages.add(details);
        }
        return packages;
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> packages) {
        throw new UnsupportedOperationException("Cannot remove the package backing an EAR/WAR resource.");
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails packageDetails) {
        return null;
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        File tempFile;
        if (packages.size() != 1) {
            this.log.warn((Object)"Request to update an EAR/WAR file contained multiple packages.");
            DeployPackagesResponse response = new DeployPackagesResponse(ContentResponseResult.FAILURE);
            response.setOverallRequestErrorMessage("When deploying an EAR/WAR, only one EAR/WAR can be updated at a time.");
            return response;
        }
        ResourcePackageDetails packageDetails = packages.iterator().next();
        Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
        File appFile = new File(pluginConfig.getSimple(FILENAME_PLUGIN_CONFIG_PROP).getStringValue());
        if (!appFile.exists()) {
            return this.failApplicationDeployment("Could not find application to update at location: " + appFile, packageDetails);
        }
        try {
            tempFile = this.writeNewAppBitsToTempFile(appFile, contentServices, packageDetails);
        }
        catch (Exception e) {
            return this.failApplicationDeployment("Error writing new application bits to temporary file - cause: " + e, packageDetails);
        }
        boolean isExploded = appFile.isDirectory();
        File backupOfOriginalFile = new File(appFile.getPath() + BACKUP_FILE_SUFFIX);
        appFile.renameTo(backupOfOriginalFile);
        this.moveTempFileToDeployLocation(tempFile, appFile, isExploded);
        MainDeployer mainDeployer = this.getParentResourceComponent().getMainDeployer();
        try {
            mainDeployer.redeploy(appFile);
            try {
                FileUtils.purge((File)backupOfOriginalFile, (boolean)true);
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to delete backup of original file: " + backupOfOriginalFile));
            }
        }
        catch (Exception e) {
            String errorMessage = ThrowableUtil.getAllMessages((Throwable)e);
            try {
                FileUtils.purge((File)appFile, (boolean)true);
                backupOfOriginalFile.renameTo(appFile);
                mainDeployer.redeploy(appFile);
                errorMessage = errorMessage + " ***** ROLLED BACK TO ORIGINAL APPLICATION FILE. *****";
            }
            catch (Exception e1) {
                errorMessage = errorMessage + " ***** FAILED TO ROLLBACK TO ORIGINAL APPLICATION FILE. *****: " + ThrowableUtil.getAllMessages((Throwable)e1);
            }
            return this.failApplicationDeployment(errorMessage, packageDetails);
        }
        DeployPackagesResponse response = new DeployPackagesResponse(ContentResponseResult.SUCCESS);
        DeployIndividualPackageResponse packageResponse = new DeployIndividualPackageResponse(packageDetails.getKey(), ContentResponseResult.SUCCESS);
        response.addPackageResponse(packageResponse);
        return response;
    }

    public void deleteResource() throws Exception {
        Configuration pluginConfiguration = this.getResourceContext().getPluginConfiguration();
        String fullFileName = pluginConfiguration.getSimple(FILENAME_PLUGIN_CONFIG_PROP).getStringValue();
        File file = new File(fullFileName);
        if (file.exists()) {
            try {
                this.getParentResourceComponent().undeployFile(file);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to undeploy file [" + file + "]."), (Throwable)e);
                throw e;
            }
            finally {
                try {
                    FileUtils.purge((File)file, (boolean)true);
                }
                catch (IOException e) {
                    this.log.error((Object)("Failed to delete file [" + file + "]."), (Throwable)e);
                    throw e;
                }
            }
        }
        this.log.info((Object)("deleteResource: File [" + fullFileName + "] was not found - ignoring."));
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        if (!requests.isEmpty()) {
            Configuration pluginConfig = this.getResourceContext().getPluginConfiguration();
            String path = pluginConfig.getSimpleValue(FILENAME_PLUGIN_CONFIG_PROP, null);
            for (MeasurementScheduleRequest request : requests) {
                String metricName = request.getName();
                if (metricName.equals(APPLICATION_PATH_TRAIT)) {
                    MeasurementDataTrait trait = new MeasurementDataTrait(request, path);
                    report.addData(trait);
                    continue;
                }
                if (!metricName.equals(APPLICATION_EXPLODED_TRAIT)) continue;
                boolean exploded = new File(path).isDirectory();
                MeasurementDataTrait trait = new MeasurementDataTrait(request, exploded ? "yes" : "no");
                report.addData(trait);
            }
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if ("revert".equals(name)) {
            try {
                this.revertFromBackupFile();
                return new OperationResult("Successfully reverted from backup");
            }
            catch (Exception e) {
                throw new RuntimeException("Error reverting from Backup: " + e.getMessage());
            }
        }
        return super.invokeOperation(name, parameters);
    }

    public String getApplicationName() {
        String resourceKey = this.getResourceContext().getResourceKey();
        return resourceKey.substring(resourceKey.lastIndexOf(61) + 1);
    }

    public String getFileName() {
        Configuration pluginConfiguration = this.getResourceContext().getPluginConfiguration();
        return pluginConfiguration.getSimple(FILENAME_PLUGIN_CONFIG_PROP).getStringValue();
    }

    public JBossASServerComponent<?> getParentResourceComponent() {
        return (JBossASServerComponent)this.getResourceContext().getParentResourceComponent();
    }

    public void revertFromBackupFile() throws Exception {
        Configuration pluginConfiguration = this.getResourceContext().getPluginConfiguration();
        String fullFileName = pluginConfiguration.getSimple(FILENAME_PLUGIN_CONFIG_PROP).getStringValue();
        String fileName = fullFileName != null && fullFileName.endsWith("/") ? fullFileName.substring(0, fullFileName.length() - 1) : fullFileName;
        File backup = new File(fileName + ".bak");
        if (!backup.exists()) {
            throw new FileNotFoundException("Backup file " + backup + " does not exist");
        }
        File directory = backup.getParentFile();
        if (!directory.canWrite()) {
            throw new IOException("Can not modify directory " + directory);
        }
        File file = new File(fullFileName);
        File tmpBackup = new File(fileName + ".tmp.bak");
        boolean good = file.renameTo(tmpBackup);
        if (!good) {
            throw new IOException("Aborted as it is not possible to move to original to a tmp backup at " + tmpBackup);
        }
        good = backup.renameTo(file);
        if (!good) {
            good = tmpBackup.renameTo(file);
            if (!good) {
                throw new IOException("Installing backup " + backup + " failed and re-installing the original from " + tmpBackup + " failed too. Please correct this manually");
            }
        } else {
            FileUtils.purge((File)tmpBackup, (boolean)true);
        }
        this.getParentResourceComponent().deployFile(file);
    }

    private DeployPackagesResponse failApplicationDeployment(String errorMessage, ResourcePackageDetails packageDetails) {
        DeployPackagesResponse response = new DeployPackagesResponse(ContentResponseResult.FAILURE);
        DeployIndividualPackageResponse packageResponse = new DeployIndividualPackageResponse(packageDetails.getKey(), ContentResponseResult.FAILURE);
        packageResponse.setErrorMessage(errorMessage);
        response.addPackageResponse(packageResponse);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTempFileToDeployLocation(File newApplication, File appFile, boolean isExploded) {
        InputStream tempIs = null;
        try {
            if (isExploded) {
                tempIs = new BufferedInputStream(new FileInputStream(newApplication));
                appFile.mkdirs();
                ZipUtil.unzipFile((InputStream)tempIs, (File)appFile);
            } else {
                newApplication.renameTo(appFile);
            }
        }
        catch (IOException e) {
            this.log.error((Object)("Error writing updated package bits to the existing application location: " + appFile), (Throwable)e);
        }
        finally {
            if (tempIs != null) {
                try {
                    tempIs.close();
                }
                catch (IOException e) {
                    this.log.error((Object)"Error closing temporary input stream", (Throwable)e);
                }
            }
        }
    }

    private File writeNewAppBitsToTempFile(File file, ContentServices contentServices, ResourcePackageDetails packageDetails) throws Exception {
        File tempDir = this.getResourceContext().getTemporaryDirectory();
        File tempFile = new File(tempDir.getAbsolutePath(), file.getName() + UUID.randomUUID().getLeastSignificantBits());
        if (tempFile.exists()) {
            this.log.warn((Object)("Existing temporary file found and will be deleted at: " + tempFile));
            tempFile.delete();
        }
        OutputStream tempOutputStream = null;
        try {
            tempOutputStream = new BufferedOutputStream(new FileOutputStream(tempFile));
            contentServices.downloadPackageBits(this.getResourceContext().getContentContext(), packageDetails.getKey(), tempOutputStream, true);
        }
        catch (IOException e) {
            this.log.error((Object)("Error writing updated application bits to temporary location: " + tempFile), (Throwable)e);
            throw e;
        }
        finally {
            if (tempOutputStream != null) {
                try {
                    tempOutputStream.close();
                }
                catch (IOException e) {
                    this.log.error((Object)"Error closing temporary output stream", (Throwable)e);
                }
            }
        }
        if (!tempFile.exists()) {
            this.log.error((Object)("Temporary file for application update not written to: " + tempFile));
            throw new Exception();
        }
        return tempFile;
    }

    private String getSHA256(File file) {
        String sha256;
        block2: {
            sha256 = null;
            try {
                FileContentDelegate fileContentDelegate = new FileContentDelegate(file, null, null);
                sha256 = fileContentDelegate.getSHA(file);
            }
            catch (Exception iex) {
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug((Object)("Problem calculating digest of package [" + file.getPath() + "]." + iex.getMessage()));
            }
        }
        return sha256;
    }

    private String getVersion(String sha256) {
        return "[sha256=" + sha256 + "]";
    }

    private String getDisplayVersion(File file) {
        JarContentFileInfo contentFileInfo = new JarContentFileInfo(file);
        return contentFileInfo.getVersion(null);
    }
}

