/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.snmptrapd;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.pluginapi.event.EventPoller;
import org.rhq.plugins.snmptrapd.SnmpTrapdComponent;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class SnmpTrapEventPoller
implements EventPoller,
CommandResponder {
    private final List<Event> events = new Vector<Event>();
    private OID severityOid = null;
    private Properties translation;
    private Log log = LogFactory.getLog(SnmpTrapEventPoller.class);

    public SnmpTrapEventPoller() {
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream in = cl.getResourceAsStream("MibTrans.properties");
        this.translation = new Properties();
        try {
            if (in != null) {
                this.translation.load(in);
                in.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SnmpTrapEventPoller(String severityOidString) {
        this();
        if (severityOidString != null) {
            this.severityOid = new OID(severityOidString);
        }
    }

    public String getEventType() {
        return "SnmpTrap";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Event> poll() {
        HashSet<Event> eventSet = new HashSet<Event>();
        List<Event> list = this.events;
        synchronized (list) {
            eventSet.addAll(this.events);
            this.events.clear();
        }
        return eventSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPdu(CommandResponderEvent cre) {
        String sourceAddr;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("recv: " + cre));
        }
        PDU pdu = cre.getPDU();
        Address addr = cre.getPeerAddress();
        if (addr instanceof IpAddress) {
            sourceAddr = ((IpAddress)addr).getInetAddress().toString();
            if (sourceAddr.startsWith("/")) {
                sourceAddr = sourceAddr.substring(1);
            }
        } else {
            sourceAddr = "snmp-agent";
        }
        if (pdu != null) {
            StringBuffer payload = new StringBuffer();
            if (pdu instanceof PDUv1) {
                PDUv1 v1pdu = (PDUv1)pdu;
                long timeTicks = v1pdu.getTimestamp();
                payload.append("Traptype (generic, specific): ");
                payload.append(v1pdu.getGenericTrap()).append(", ").append(v1pdu.getSpecificTrap()).append("\n");
                payload.append("Timestamp: " + new TimeTicks(timeTicks).toString());
                payload.append("\n");
            }
            ++SnmpTrapdComponent.trapCount;
            EventSeverity severity = EventSeverity.INFO;
            Vector vbs = pdu.getVariableBindings();
            for (VariableBinding vb : vbs) {
                OID oid = vb.getOid();
                Variable var = vb.getVariable();
                int syntax = vb.getSyntax();
                String oids = oid.toString();
                if (this.translation.getProperty(oids) != null) {
                    oids = this.translation.getProperty(oids);
                }
                payload.append(oids);
                payload.append(": ");
                payload.append(var.toString());
                payload.append("\n");
                if (this.severityOid == null || oid.compareTo((Object)this.severityOid) != 0) continue;
                String sev = var.toString();
                if (sev.toLowerCase().contains("high")) {
                    severity = EventSeverity.ERROR;
                    continue;
                }
                if (sev.toLowerCase().contains("medium")) {
                    severity = EventSeverity.WARN;
                    continue;
                }
                severity = EventSeverity.INFO;
            }
            Event event = new Event(this.getEventType(), sourceAddr, System.currentTimeMillis(), severity, payload.toString());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("queue event " + event));
            }
            List<Event> list = this.events;
            synchronized (list) {
                this.events.add(event);
            }
        }
    }
}

