/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.server;

import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryCallback;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.util.obfuscation.Obfuscator;

public class DiscoveryCallbackImpl
implements ResourceDiscoveryCallback {
    private static final String PLUGIN_CONFIG_HOME_DIR = "homeDir";
    private static final String PLUGIN_CONFIG_PASSWORD = "password";
    private static final String PROP_SERVER_PROP_FILE = "../bin/rhq-server.properties";
    private static final String PROP_SERVER_MGMT_USER_PASSWORD = "rhq.server.management.password";
    private Log log = LogFactory.getLog(DiscoveryCallbackImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceDiscoveryCallback.DiscoveryCallbackResults discoveredResources(DiscoveredResourceDetails discoveredDetails) throws Exception {
        ProcessInfo processInfo = discoveredDetails.getProcessInfo();
        ResourceDiscoveryCallback.DiscoveryCallbackResults result = ResourceDiscoveryCallback.DiscoveryCallbackResults.UNPROCESSED;
        if (!this.isRhqServer(processInfo)) {
            return result;
        }
        result = ResourceDiscoveryCallback.DiscoveryCallbackResults.PROCESSED;
        String name = discoveredDetails.getResourceName();
        discoveredDetails.setResourceName(name + " RHQ Server");
        String homeDirStr = discoveredDetails.getPluginConfiguration().getSimpleValue(PLUGIN_CONFIG_HOME_DIR);
        if (null == homeDirStr || homeDirStr.isEmpty()) {
            this.log.warn((Object)"The configuration property [homeDir] is not set - will not be able to connect to the RHQ Server instance");
            return result;
        }
        File homeDirFile = new File(homeDirStr);
        File serverPropertiesFile = new File(homeDirFile, PROP_SERVER_PROP_FILE);
        if (!serverPropertiesFile.exists()) {
            this.log.warn((Object)("The server properties file [" + serverPropertiesFile.getAbsolutePath() + "] does not exist - will not be able to connect to the RHQ Server instance"));
            return result;
        }
        try {
            Properties props = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(serverPropertiesFile);
                props.load(fis);
            }
            finally {
                if (null != fis) {
                    fis.close();
                }
            }
            String encodedPassword = props.getProperty(PROP_SERVER_MGMT_USER_PASSWORD);
            if (null == encodedPassword || encodedPassword.isEmpty()) {
                this.log.warn((Object)"The server property [rhq.server.management.password] is not set - will not be able to connect to the RHQ Server instance");
                return result;
            }
            String password = Obfuscator.decode((String)encodedPassword);
            Configuration pluginConfig = discoveredDetails.getPluginConfiguration();
            pluginConfig.put((Property)new PropertySimple(PLUGIN_CONFIG_PASSWORD, (Object)password));
            discoveredDetails.setPluginConfiguration(pluginConfig);
        }
        catch (Throwable t) {
            this.log.warn((Object)"Problem setting RHQ Server management password - will not be able to connect to the RHQ Server instance", t);
        }
        return result;
    }

    private boolean isRhqServer(ProcessInfo process) {
        String commandLine;
        if (File.separatorChar == '/') {
            String prop = process.getEnvironmentVariable("JAVA_OPTS");
            return null != prop && prop.contains("-Dapp.name=rhq-server");
        }
        ProcessInfo parentProcess = process.getParentProcess();
        return null != parentProcess && null != (commandLine = Arrays.toString(parentProcess.getCommandLine())) && commandLine.contains("rhq-server-wrapper.conf");
    }
}

