/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.model;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.el.Expression;
import javax.faces.context.FacesContext;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.ExtendedDataModel;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.model.SequenceRange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.gui.model.PagedDataProvider;
import org.richfaces.model.FilterField;
import org.richfaces.model.Modifiable;
import org.richfaces.model.Ordering;
import org.richfaces.model.SortField2;

public class PagedDataModel<T>
extends ExtendedDataModel
implements Modifiable {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected Object currentRowKey;
    protected PageList<T> currentPage;
    protected LinkedHashMap<Object, T> currentPageDataByKey;
    private PagedDataProvider<T> dataProvider;
    private PageControl defaultPageControl;
    private SequenceRange currentSequenceRange;
    private List<OrderingField> currentOrderingFields = Collections.emptyList();
    private boolean sortRequested;

    public PagedDataModel(PagedDataProvider<T> dataProvider) {
        this.dataProvider = dataProvider;
        this.defaultPageControl = new PageControl(0, 15);
    }

    public Object getRowKey() {
        return this.currentRowKey;
    }

    public void setRowKey(Object key) {
        this.currentRowKey = key;
    }

    public void walk(FacesContext facesContext, DataVisitor dataVisitor, Range range, Object argument) throws IOException {
        boolean newPageRequested;
        SequenceRange sequenceRange = (SequenceRange)range;
        boolean bl = newPageRequested = this.currentSequenceRange == null || sequenceRange.getFirstRow() != this.currentSequenceRange.getFirstRow() || sequenceRange.getRows() != this.currentSequenceRange.getRows();
        if (newPageRequested) {
            this.log.info((Object)"*** New page requested.");
        }
        this.currentSequenceRange = sequenceRange;
        if (newPageRequested || this.sortRequested) {
            PageControl pageControl = this.createPageControl();
            this.loadDataPage(pageControl);
            this.sortRequested = false;
        }
        for (Object key : this.currentPageDataByKey.keySet()) {
            dataVisitor.process(facesContext, key, argument);
        }
    }

    public void modify(List<FilterField> filterFields, List<SortField2> sortFields) {
        if (!this.sortRequested) {
            List<OrderingField> orderingFields = this.toOrderingFields(sortFields);
            this.fixOrder(orderingFields);
            boolean bl = this.sortRequested = !orderingFields.equals(this.currentOrderingFields);
            if (this.sortRequested) {
                this.log.info((Object)("*** Sort requested - order: " + orderingFields + ", previous order: " + this.currentOrderingFields));
            }
            this.currentOrderingFields = orderingFields;
        }
    }

    public boolean isRowAvailable() {
        if (this.currentRowKey == null) {
            return false;
        }
        return this.currentPageDataByKey.containsKey(this.currentRowKey);
    }

    public Object getRowData() {
        if (this.currentRowKey == null) {
            return null;
        }
        T dataObject = this.currentPageDataByKey.get(this.currentRowKey);
        if (dataObject == null) {
            this.loadDataPage(this.defaultPageControl);
        }
        return dataObject;
    }

    public int getRowCount() {
        if (this.currentPage == null) {
            this.loadDataPage(this.defaultPageControl);
        }
        return this.currentPage.getTotalSize();
    }

    public void setRowIndex(int rowIndex) {
        throw new UnsupportedOperationException("This method is not called by the RichFaces rich:extendedDataTable component.");
    }

    public void setWrappedData(Object data) {
        throw new UnsupportedOperationException("This method is not called by the RichFaces rich:extendedDataTable component.");
    }

    public int getRowIndex() {
        throw new UnsupportedOperationException("This method is not called by the rich:extendedDataTable component.");
    }

    public Object getWrappedData() {
        throw new UnsupportedOperationException("This method is not called by the rich:extendedDataTable component.");
    }

    private PageControl createPageControl() {
        int pageSize = this.currentSequenceRange.getRows();
        int pageNumber = this.currentSequenceRange.getFirstRow() / pageSize;
        PageControl pageControl = new PageControl(pageNumber, pageSize);
        pageControl.getOrderingFields().addAll(this.currentOrderingFields);
        return pageControl;
    }

    private List<OrderingField> toOrderingFields(List<SortField2> sortFields) {
        if (sortFields == null) {
            sortFields = Collections.emptyList();
        }
        ArrayList<OrderingField> orderingFields = new ArrayList<OrderingField>(sortFields.size());
        for (SortField2 sortField2 : sortFields) {
            Expression expression = sortField2.getExpression();
            String expressionString = expression.getExpressionString();
            String field = expression.isLiteralText() ? expressionString : expressionString.replaceAll("[#|$]\\{", "").replaceAll("\\}", "");
            Ordering ordering = sortField2.getOrdering();
            PageOrdering pageOrdering = ordering == Ordering.ASCENDING ? PageOrdering.ASC : PageOrdering.DESC;
            OrderingField orderingField = new OrderingField(field, pageOrdering);
            orderingFields.add(orderingField);
        }
        return orderingFields;
    }

    private void loadDataPage(PageControl pageControl) {
        this.currentPage = this.getDataPage(pageControl);
        this.currentPageDataByKey = new LinkedHashMap(this.currentPage.size());
        for (Object dataObject : this.currentPage) {
            Object key = this.getPrimaryKey(dataObject);
            this.currentPageDataByKey.put(key, dataObject);
        }
    }

    protected Object getPrimaryKey(T object) {
        Method method;
        try {
            method = object.getClass().getMethod("getId", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(object.getClass() + " does not define a public getId() method.");
        }
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to invoke getId() on " + object + ".", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PageList<T> getDataPage(PageControl pageControl) {
        PageList<T> results = null;
        boolean tryQueryAgain = false;
        try {
            if (this.log.isTraceEnabled()) {
                // empty if block
            }
            if (pageControl.getPageSize() == -1 && pageControl.getPageNumber() != 0) {
                if (this.log.isTraceEnabled()) {
                    // empty if block
                }
                pageControl.setPageNumber(0);
            }
            results = this.dataProvider.getDataPage(pageControl);
            if (this.log.isTraceEnabled()) {
                // empty if block
            }
            if (results.getTotalSize() <= pageControl.getStartRow() || results.isEmpty() && pageControl.getPageNumber() != 0) {
                if (!this.log.isTraceEnabled() || results.getTotalSize() <= pageControl.getStartRow()) {
                    // empty if block
                }
                pageControl.reset();
                if (this.log.isTraceEnabled()) {
                    // empty if block
                }
                tryQueryAgain = true;
            }
        }
        catch (Throwable t) {
            pageControl.reset();
            if (this.log.isTraceEnabled()) {
                // empty if block
            }
            tryQueryAgain = true;
        }
        if (tryQueryAgain) {
            if (this.log.isTraceEnabled()) {
                // empty if block
            }
            try {
                results = this.dataProvider.getDataPage(pageControl);
                if (!this.log.isTraceEnabled()) {
                    // empty if block
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (results != null) return results;
        return new PageList<T>();
    }

    private void fixOrder(List<OrderingField> orderingFields) {
        Collections.reverse(orderingFields);
        if (this.currentOrderingFields != null && orderingFields.size() > 1 && orderingFields.size() == this.currentOrderingFields.size()) {
            int sortFieldsSize = orderingFields.size();
            for (int i = 1; i < sortFieldsSize; ++i) {
                OrderingField orderingField = orderingFields.get(i);
                OrderingField currentOrderingField = this.currentOrderingFields.get(i);
                if (!orderingField.getField().equals(currentOrderingField.getField()) || orderingField.getOrdering() == currentOrderingField.getOrdering()) continue;
                orderingFields.remove(i);
                orderingFields.add(0, orderingField);
            }
        }
    }
}

