/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.pluginapi.util.CommandLineOption;
import org.rhq.core.pluginapi.util.JavaCommandLine;
import org.rhq.core.system.ProcessInfo;

public class AS7CommandLine
extends JavaCommandLine {
    public static final String HOME_DIR_SYSPROP = "jboss.home.dir";
    private static final String APP_SERVER_MODULE_NAME_PREFIX = "org.jboss.as";
    private static final CommandLineOption PROPERTIES_OPTION = new CommandLineOption("P", "properties", true);
    private static final String[] PROPERTIES_OPTION_PREFIXES = new String[]{"-" + PROPERTIES_OPTION.getShortName(), "--" + PROPERTIES_OPTION.getLongName()};
    private static final Log LOG = LogFactory.getLog(AS7CommandLine.class);
    private String appServerModuleName;
    private List<String> appServerArgs;
    private ProcessInfo process;

    public AS7CommandLine(String[] args) {
        super(args, true, EnumSet.of(JavaCommandLine.OptionValueDelimiter.WHITESPACE, JavaCommandLine.OptionValueDelimiter.EQUALS_SIGN), EnumSet.of(JavaCommandLine.OptionValueDelimiter.WHITESPACE, JavaCommandLine.OptionValueDelimiter.EQUALS_SIGN));
    }

    public AS7CommandLine(ProcessInfo process) {
        this(process.getCommandLine());
        this.process = process;
    }

    @NotNull
    public String getAppServerModuleName() {
        if (!this.isArgumentsParsed()) {
            this.parseCommandLine();
        }
        return this.appServerModuleName;
    }

    @NotNull
    public List<String> getAppServerArguments() {
        if (!this.isArgumentsParsed()) {
            this.parseCommandLine();
        }
        return this.appServerArgs;
    }

    protected void parseCommandLine() {
        super.parseCommandLine();
        List classArgs = super.getClassArguments();
        int classArgsSize = classArgs.size();
        for (int i = 0; i < classArgsSize; ++i) {
            String classArg = (String)classArgs.get(i);
            if (!classArg.startsWith(APP_SERVER_MODULE_NAME_PREFIX)) continue;
            this.appServerModuleName = classArg;
            if (i + 1 < classArgsSize) {
                this.appServerArgs = Collections.unmodifiableList(classArgs.subList(i + 1, classArgsSize));
                break;
            }
            this.appServerArgs = Collections.emptyList();
            break;
        }
        if (this.appServerModuleName == null) {
            throw new IllegalArgumentException("Class arguments do not contain an argument starting with \"org.jboss.as\".");
        }
    }

    protected void processClassArgument(String classArg, String nextArg) {
        Properties props;
        URL propertiesURL;
        super.processClassArgument(classArg, nextArg);
        String propertiesOptionValue = null;
        for (String propertiesOption : PROPERTIES_OPTION_PREFIXES) {
            if (!classArg.startsWith(propertiesOption)) continue;
            propertiesOptionValue = propertiesOption.length() < classArg.length() && classArg.charAt(propertiesOption.length()) == '=' ? classArg.substring(propertiesOption.length() + 1) : nextArg;
        }
        if (propertiesOptionValue != null && (propertiesURL = this.toURL(propertiesOptionValue)) != null && (props = this.loadProperties(propertiesURL)) != null) {
            Map sysProps = this.getSystemProperties();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                sysProps.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private URL toURL(String value) {
        URL propertiesURL;
        try {
            String path;
            File file;
            propertiesURL = new URL(value);
            if (propertiesURL.getProtocol().equals("file") && !(file = new File(path = propertiesURL.getPath())).isAbsolute()) {
                File absoluteFile = this.getAbsoluteFile(file);
                propertiesURL = absoluteFile.toURI().toURL();
            }
        }
        catch (MalformedURLException murle) {
            File file = new File(value);
            File absoluteFile = this.getAbsoluteFile(file);
            try {
                propertiesURL = absoluteFile.toURI().toURL();
            }
            catch (MalformedURLException murle2) {
                propertiesURL = null;
                LOG.error((Object)("Value of class option " + PROPERTIES_OPTION + " (" + value + ") is not a valid URL."));
            }
        }
        return propertiesURL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File getAbsoluteFile(File file) {
        if (file.isAbsolute()) return file;
        if (this.process != null && this.process.getExecutable() != null) {
            String cwd = this.process.getExecutable().getCwd();
            return new File(cwd, file.getPath());
        }
        String homeDir = (String)this.getSystemProperties().get(HOME_DIR_SYSPROP);
        if (homeDir != null) {
            File binDir = new File(homeDir, "bin");
            return new File(binDir, file.getPath());
        }
        LOG.error((Object)("Failed to resolve relative properties file path [" + file + "]."));
        return null;
    }

    private Properties loadProperties(URL propertiesURL) {
        InputStream inputStream;
        URLConnection urlConnection;
        try {
            urlConnection = propertiesURL.openConnection();
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to connect to URL [" + propertiesURL + "]."), (Throwable)e);
            return null;
        }
        try {
            inputStream = urlConnection.getInputStream();
            if (inputStream == null) {
                LOG.error((Object)("Failed to read from URL [" + propertiesURL + "]."));
                return null;
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to read from URL [" + propertiesURL + "]."), (Throwable)e);
            return null;
        }
        Properties props = new Properties();
        try {
            props.load(inputStream);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to parse properties from URL [" + propertiesURL + "]."), (Throwable)e);
            return null;
        }
        return props;
    }
}

